/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.client.resources;

import com.github.yukkuritaku.modernwarpmenu.data.layout.Layout;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Warp;
import com.github.yukkuritaku.modernwarpmenu.data.layout.WarpIcon;
import com.github.yukkuritaku.modernwarpmenu.state.ModernWarpMenuState;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;

public class LayoutManager
extends class_4080<LayoutList>
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();

    private static void loadLayout(class_3298 resource, class_2960 layoutId, ImmutableMap.Builder<class_2960, Layout> builder) {
        try (BufferedReader reader = resource.method_43039();){
            JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            Layout layout = (Layout)Layout.CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonParseException::new);
            builder.put((Object)layoutId, (Object)layout);
        }
        catch (Exception e) {
            LayoutManager.handleLoadException(resource, layoutId, e);
        }
    }

    private static void handleLoadException(class_3298 resource, class_2960 location, Exception e) {
        class_128 crashReport = new class_128("Your Modern Warp Menu resource pack may be outdated", (Throwable)e);
        class_129 resourceCategory = crashReport.method_562("Resource");
        class_129 resourcePackCategory = crashReport.method_562("Resource Pack");
        resourceCategory.method_578("Path", (Object)location.toString());
        resourcePackCategory.method_578("Name", (Object)resource.method_45304().method_56926().comp_2330().getString());
        throw new class_148(crashReport);
    }

    protected LayoutList prepare(class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder layoutBuilder = ImmutableMap.builder();
        Map resources = resourceManager.method_14488("layouts", resourceLocation -> resourceLocation.method_12836().equalsIgnoreCase("modernwarpmenu") && resourceLocation.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            LayoutManager.loadLayout((class_3298)entry.getValue(), location, (ImmutableMap.Builder<class_2960, Layout>)layoutBuilder);
        }
        return new LayoutList((Map<class_2960, Layout>)layoutBuilder.build());
    }

    protected void apply(LayoutList object, class_3300 resourceManager, class_3695 profiler) {
        for (Map.Entry<class_2960, Layout> layoutEntry : object.layouts.entrySet()) {
            WarpIcon icon = layoutEntry.getValue().warpIcon();
            Warp.setWarpIcon(icon);
            Layout layout = layoutEntry.getValue();
            switch (layout.layoutType()) {
                case OVERWORLD: {
                    ModernWarpMenuState.setOverworldLayout(layout);
                    break;
                }
                case RIFT: {
                    ModernWarpMenuState.setRiftLayout(layout);
                }
            }
        }
        object.layouts.forEach((key, value) -> LOGGER.info("Layout loaded {}", key));
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"modernwarpmenu", (String)"constants");
    }

    public record LayoutList(Map<class_2960, Layout> layouts) {
    }
}

