/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.data.layout;

import com.github.yukkuritaku.modernwarpmenu.data.layout.Button;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Island;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Layout;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Warp;
import com.github.yukkuritaku.modernwarpmenu.data.layout.WarpIcon;
import com.github.yukkuritaku.modernwarpmenu.data.layout.texture.LayoutTexture;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public class LayoutProvider
implements class_2405 {
    private final List<LayoutFile> layouts = Collections.synchronizedList(new LinkedList());
    private final class_7784.class_7489 pathProvider;
    private final String modid;
    private final CompletableFuture<class_7225.class_7874> lookupProvider;

    public LayoutProvider(FabricDataOutput output, String modid, CompletableFuture<class_7225.class_7874> lookupProvider) {
        this.pathProvider = output.method_45973(class_7784.class_7490.field_39368, "layouts");
        this.modid = modid;
        this.lookupProvider = lookupProvider;
    }

    protected Path getPath(class_2960 id) {
        return this.pathProvider.method_44107(id);
    }

    private CompletableFuture<?> generateLayouts(class_7403 cache) {
        CompletableFuture[] completableFutures = new CompletableFuture[this.layouts.size()];
        int size = 0;
        for (LayoutFile layout : this.layouts) {
            Path target = this.getPath(class_2960.method_60655((String)this.modid, (String)layout.fileName));
            completableFutures[size++] = class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)Layout.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)layout.layout).getOrThrow()), (Path)target);
        }
        return CompletableFuture.allOf(completableFutures);
    }

    private void addLayouts() {
        this.layouts.add(new LayoutFile(new Layout(Layout.LayoutType.OVERWORLD, Layout.EMPTY, List.of(new Island("Hub", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/hub.png"), 883, 674), 24, 17, 0, 0.25f, List.of(new Warp(19, 11, "Spawn", "hub"), new Warp(17, 25, "Museum", "museum"), new Warp(3, 15, "Crypts", "crypts"), new Warp(26, 18, "Wizard", "wizard"), new Warp(37, 28, "Sirius (DA)", "da"), new Warp(1, 22, "Ruins", "castle"))), new Island("Crimson Isle", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/crimson_isle.png"), 926, 656), 18, 1, 2, 0.25f, List.of(new Warp(4, 30, "Spawn", "isle"), new Warp(22, 8, "Skull", "skull"), new Warp(27, 14, "Tomb", "smold"), new Warp(12, 12, "Wasteland", "wasteland", List.of("bingo")), new Warp(11, 2, "Dragontail", "dragontail", List.of("bingo")), new Warp(21, 24, "Scarleton", "scarleton", List.of("bingo")))), new Island("Spider's Den", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/spiders_den.png"), 790, 522), 14, 12, 1, 0.15f, List.of(new Warp(23, 23, "Spawn", "spider"), new Warp(31, 1, "Top", "top"), new Warp(6, 16, "Arachne", "arachne"))), new Island("The End", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/end.png"), 707, 667), 2, 2, 2, 0.15f, List.of(new Warp(27, 18, "Spawn", "end"), new Warp(11, 30, "Nest", "drag"), new Warp(24, 28, "Void", "void"))), new Island("Gold Mine", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/gold_mine.png"), 464, 493), 32, 9, 1, 0.1f, List.of(new Warp(8, 20, "Spawn", "gold"))), new Island("Deep Caverns", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/deep_caverns.png"), 397, 509), 39, 2, 2, 0.135f, List.of(new Warp(5, 21, "Spawn", "deep"), new Warp(32, 12, "Dwarven\nMines", "dwarves"), new Warp(20, 5, "Forge", "forge"), new Warp(8, 12, "Tunnels", "tunnels"), new Warp(31, 26, "Hollows", "ch"), new Warp(18, 30, "Nucleus", "nucleus"))), new Island("Home", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/private_island.png"), 414, 488), 43, 27, 1, 0.05f, List.of(new Warp(3, 3, "Spawn", "home"))), new Island("Garden", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/garden.png"), 941, 569), 48, 27, 2, 0.1f, List.of(new Warp(10, 8, "Spawn", "garden"))), new Island("The Barn", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/barn.png"), 1080, 1080), 41, 16, 1, 0.11f, List.of(new Warp(1, 19, "Spawn", "barn"))), new Island("Mushroom Desert", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/mushroom_desert.png"), 827, 604), 50, 2, 2, 0.15f, List.of(new Warp(14, 29, "Spawn", "desert"), new Warp(12, 8, "Trapper", "trapper"))), new Island("The Park", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/park.png"), 1371, 1028), 12, 22, 0, 0.15f, List.of(new Warp(34, 32, "Spawn", "park"), new Warp(28, 14, "Cave", "howl"), new Warp(16, 6, "Jungle", "jungle"))), new Island("Galetea", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/galatea.png"), 1129, 871), 1, 18, 0, 0.15f, List.of(new Warp(13, 28, "Spawn", "galatea"), new Warp(22, 15, "Murkwater", "murkwater"))), new Island("Bayou", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/bayou.png"), 951, 875), 51, 16, 0, 0.1f, List.of(new Warp(5, 3, "Spawn", "bayou"))), new Island("Jerry's Workshop", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/jerrys_workshop.png"), 890, 602), 2, 28, 2, 0.15f, List.of(new Warp(22, 16, "Jerry", "jerry", List.of("jerry")))), new Island("Dungeon Hub", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/dungeon_hub.png"), 256, 512), 56, 26, 2, 0.03f, List.of(new Warp(6, 15, "Spawn", "dungeons")))), new WarpIcon(new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/portal.png"), 207, 256), 0.02f), new Button(new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"icon.png"), 512, 512), 60, 31, 0.03f), new Button(new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/regular_warp_menu.png"), 128, 64), 60, 29, 0.03f)), "layout"));
        this.layouts.add(new LayoutFile(new Layout(Layout.LayoutType.RIFT, Layout.EMPTY, List.of(new Island("Rift", new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/islands/rift.png"), 974, 1051), 21, 6, 0, 0.35f, List.of(new Warp(18, 25, "Wizard Tower", 10), new Warp(8, 23, "Lagoon Hut", 11), new Warp(18, 11, "Dreadfarm", 12), new Warp(22, 19, "Plaza", 13), new Warp(11, 18, "Colosseum", 14), new Warp(31, 28, "Stillgore Ch\u00e2teau", 15), new Warp(24, 23, "Mountaintop", 16)))), new WarpIcon(new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/portal.png"), 207, 256), 0.02f), new Button(new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"icon.png"), 512, 512), 60, 31, 0.05f), new Button(new LayoutTexture(class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/regular_warp_menu.png"), 128, 64), 60, 29, 0.05f)), "rift_layout"));
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        this.addLayouts();
        return CompletableFuture.allOf(this.generateLayouts(output));
    }

    public String method_10321() {
        return "layouts";
    }

    public record LayoutFile(Layout layout, String fileName) {
    }
}

