/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.data.layout;

import com.github.yukkuritaku.modernwarpmenu.data.layout.WarpIcon;
import com.github.yukkuritaku.modernwarpmenu.data.layout.texture.LayoutTexture;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1041;
import net.minecraft.class_3544;
import net.minecraft.class_5699;

public record Warp(int gridX, int gridY, String displayName, String commandName, List<String> tags, int slotIndex, boolean hideButton) {
    public static final MapCodec<Warp> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33441.fieldOf("grid_x").forGetter(warp -> warp.gridX), (App)class_5699.field_33441.fieldOf("grid_y").forGetter(warp -> warp.gridY), (App)class_5699.field_41759.fieldOf("display_name").forGetter(warp -> warp.displayName), (App)Codec.STRING.optionalFieldOf("command_name", (Object)"").forGetter(warp -> warp.commandName), (App)Codec.STRING.listOf().optionalFieldOf("tags", List.of()).forGetter(warp -> warp.tags), (App)Codec.INT.optionalFieldOf("slot_index", (Object)-1).forGetter(warp -> warp.slotIndex), (App)Codec.BOOL.optionalFieldOf("hide_button", (Object)false).forGetter(warp -> warp.hideButton)).apply((Applicative)instance, Warp::new)).validate(Warp::validate);
    public static final int GRID_UNIT_WIDTH_FACTOR = 40;
    private static final Pattern TAG_VALIDATION_PATTERN = Pattern.compile("[a-z\\d-]");
    private static WarpIcon warpIcon;
    private static int width;
    private static int height;

    public Warp(int gridX, int gridY, String displayName, String commandName) {
        this(gridX, gridY, displayName, commandName, List.of(), -1, false);
    }

    public Warp(int gridX, int gridY, String displayName, String commandName, List<String> tags) {
        this(gridX, gridY, displayName, commandName, tags, -1, false);
    }

    public Warp(int gridX, int gridY, String displayName, int slotIndex) {
        this(gridX, gridY, displayName, "", List.of(), slotIndex, false);
    }

    public static void initDefaults(class_1041 window) {
        width = (int)((float)window.method_4486() * warpIcon.widthPercentage());
        float scaleFactor = (float)width / (float)warpIcon.texture().width();
        height = (int)((float)warpIcon.texture().height() * scaleFactor);
    }

    private static DataResult<Warp> validate(Warp warp) {
        if (class_3544.method_15438((String)warp.commandName) && warp.commandName.length() > 1 && warp.slotIndex < 0) {
            return DataResult.error(() -> "Warp " + warp.displayName + " must have a command name or a slot index");
        }
        if (class_3544.method_15438((String)warp.commandName) && warp.commandName.length() > 1 && !warp.commandName.matches("(?i)/?[a-z]+")) {
            return DataResult.error(() -> "Warp " + warp.displayName + "'s command name contains invalid characters.");
        }
        if (!warp.tags.isEmpty()) {
            for (String tag : warp.tags) {
                if (TAG_VALIDATION_PATTERN.asPredicate().test(tag)) continue;
                return DataResult.error(() -> tag + " is not a valid warp tag.");
            }
        }
        if (warp.gridX < 0 || warp.gridX > 40) {
            return DataResult.error(() -> "Warp " + warp.displayName + " grid_x is outside island");
        }
        if (warp.gridY < 0 || warp.gridY > 40) {
            return DataResult.error(() -> "Warp " + warp.displayName + " grid_y is outside island");
        }
        return DataResult.success((Object)warp);
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public String getWarpCommand() {
        return this.commandName.equals("/garry") ? this.commandName : "/warp " + this.commandName;
    }

    public LayoutTexture getWarpTextureLocation() {
        return warpIcon.texture();
    }

    public LayoutTexture getWarpHoverEffectTextureLocation() {
        return warpIcon.hoverEffectTexture();
    }

    public static void setWarpIcon(WarpIcon warpIcon) {
        Warp.warpIcon = warpIcon;
    }
}

