/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.menu;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3544;
import net.minecraft.class_5699;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.slf4j.Logger;

public record ItemMatchCondition(int inventorySlot, String itemName, List<String> itemNameList, String itemId, List<String> itemIdList, String skyBlockItemId, List<String> skyBlockItemIdList, Pattern loreMatchPattern) {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Pattern EMPTY_PATTERN = Pattern.compile("");
    public static final MapCodec<ItemMatchCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33441.fieldOf("inventory_slot").forGetter(ItemMatchCondition::inventorySlot), (App)Codec.STRING.optionalFieldOf("item_name", (Object)"").forGetter(ItemMatchCondition::itemName), (App)Codec.STRING.listOf().optionalFieldOf("item_name_list", List.of()).forGetter(ItemMatchCondition::itemNameList), (App)Codec.STRING.optionalFieldOf("item_id", (Object)"").forGetter(ItemMatchCondition::itemId), (App)Codec.STRING.listOf().optionalFieldOf("item_id_list", List.of()).forGetter(ItemMatchCondition::itemIdList), (App)Codec.STRING.optionalFieldOf("skyblock_item_id", (Object)"").forGetter(ItemMatchCondition::skyBlockItemId), (App)Codec.STRING.listOf().optionalFieldOf("skyblock_item_id_list", List.of()).forGetter(ItemMatchCondition::skyBlockItemIdList), (App)class_5699.field_37408.optionalFieldOf("lore_match_pattern", (Object)EMPTY_PATTERN).forGetter(ItemMatchCondition::loreMatchPattern)).apply((Applicative)instance, ItemMatchCondition::new)).validate(ItemMatchCondition::validate);

    public boolean inventoryContainsMatchingItem(class_1263 container) {
        if (container == null) {
            throw new NullPointerException("Inventory cannot be null");
        }
        if (container.method_5439() <= 0) {
            throw new IllegalArgumentException("Cannot check for matching item in empty inventory");
        }
        if (container.method_5439() < this.inventorySlot) {
            throw new IllegalArgumentException(String.format("Inventory size (%d) is smaller than match condition slot index (%d)", container.method_5439(), this.inventorySlot));
        }
        class_1799 stack = container.method_5438(this.inventorySlot);
        if (!stack.method_7960()) {
            if (!class_3544.method_15438((String)this.itemName) || !this.itemNameList.isEmpty()) {
                boolean itemNameMatches;
                String itemStackName = stack.method_57826(class_9334.field_49631) ? class_124.method_539((String)stack.method_7964().getString()) : null;
                boolean bl = itemNameMatches = itemStackName != null && (itemStackName.equals(this.itemName) || this.itemNameList.contains(itemStackName));
                if (!itemNameMatches) {
                    LOGGER.warn("Item name mismatch\nExpected {} ; Found {}", (Object)this.itemName, (Object)itemStackName);
                    return false;
                }
            }
            if (!class_3544.method_15438((String)this.itemId) || !this.itemIdList.isEmpty()) {
                boolean minecraftItemIDMatches;
                String stackItemId = stack.method_41409().method_55840();
                boolean bl = minecraftItemIDMatches = stackItemId.equals(this.itemId) || this.itemIdList.contains(stackItemId);
                if (!minecraftItemIDMatches) {
                    LOGGER.warn("Minecraft Item ID mismatch\nExpected {} ; Found {}", (Object)this.itemId, (Object)stackItemId);
                    return false;
                }
            }
            class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
            if (!class_3544.method_15438((String)this.skyBlockItemId) || !this.skyBlockItemIdList.isEmpty()) {
                boolean skyBlockItemIDMatches;
                Optional extraAttributes = tag.method_10562("ExtraAttributes");
                if (extraAttributes.isEmpty()) {
                    return false;
                }
                Optional skyBlockId = ((class_2487)extraAttributes.get()).method_10558("id");
                boolean bl = skyBlockItemIDMatches = skyBlockId.isPresent() && (((String)skyBlockId.get()).equals(this.skyBlockItemId) || this.skyBlockItemIdList.contains(skyBlockId.get()));
                if (!skyBlockItemIDMatches) {
                    LOGGER.warn("SkyBlock Item ID mismatch\nExpected {} ; Found {}", (Object)this.skyBlockItemId, (Object)skyBlockId);
                    return false;
                }
            }
            if (this.loreMatchPattern != EMPTY_PATTERN && !Objects.equals(this.loreMatchPattern.pattern(), EMPTY_PATTERN.pattern())) {
                Optional display = tag.method_10562("display");
                if (display.isEmpty()) {
                    return false;
                }
                Optional lore = ((class_2487)display.get()).method_10554("Lore");
                if (lore.isPresent() && !((class_2499)lore.get()).isEmpty()) {
                    StringBuilder loreBuilder = new StringBuilder();
                    for (int i = 0; i < ((class_2499)lore.get()).size(); ++i) {
                        loreBuilder.append(((class_2499)lore.get()).method_10608(i)).append("\n");
                    }
                    loreBuilder.deleteCharAt(loreBuilder.length() - 1);
                    String loreString = loreBuilder.toString();
                    boolean lorePatternMatches = this.loreMatchPattern.asPredicate().test(loreString);
                    if (!lorePatternMatches) {
                        LOGGER.warn("Lore did not match pattern\nItem lore: {}", (Object)lore);
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static DataResult<ItemMatchCondition> validate(ItemMatchCondition condition) {
        if (condition.itemName == null && condition.itemNameList.isEmpty() && condition.itemId == null && condition.itemIdList.isEmpty() && condition.skyBlockItemId == null && condition.skyBlockItemIdList.isEmpty() && condition.loreMatchPattern == null) {
            return DataResult.error(() -> "No item name, Minecraft item Id, SkyBlock item Id, or lore criteria specified.");
        }
        if (!class_3544.method_15438((String)condition.itemName) && !condition.itemNameList.isEmpty()) {
            return DataResult.error(() -> "item_name and item_name_list cannot both be set. Only one can be set.");
        }
        if (!class_3544.method_15438((String)condition.itemId) && !condition.itemIdList.isEmpty()) {
            return DataResult.error(() -> "item_id and item_id_list cannot both be set. Only one can be set.");
        }
        if (!class_3544.method_15438((String)condition.skyBlockItemId) && !condition.skyBlockItemIdList.isEmpty()) {
            return DataResult.error(() -> "skyblock_item_id and skyblock_item_id_list cannot both be set. Only one can be set.");
        }
        return DataResult.success((Object)condition);
    }
}

