/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.listeners;

import com.github.yukkuritaku.modernwarpmenu.data.settings.SettingsManager;
import com.github.yukkuritaku.modernwarpmenu.state.GameState;
import io.netty.channel.ChannelHandler;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.minecraft.class_156;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ChannelHandler.Sharable
public class SkyBlockJoinListener {
    private static final String SERVER_BRAND_START = "Hypixel BungeeCord";
    private static final int SCOREBOARD_CHECK_TIME_OUT = 5000;
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean serverBrandChecked;
    private boolean onHypixel;
    private boolean scoreboardChecked;
    private long lastWorldSwitchTime;

    public void registerEvents() {
        ClientLoginConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (this.onHypixel) {
                this.serverBrandChecked = false;
                this.onHypixel = false;
                GameState.setOnSkyBlock(false);
                LOGGER.info("Disconnected from Hypixel.");
            }
        });
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, level) -> {
            this.lastWorldSwitchTime = class_156.method_658();
            this.serverBrandChecked = false;
            this.scoreboardChecked = false;
            GameState.setOnSkyBlock(false);
        });
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            if (!this.serverBrandChecked || this.onHypixel && !this.scoreboardChecked) {
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return;
                }
                String serverBrand = player.field_3944.method_52790();
                if (!this.serverBrandChecked) {
                    boolean bl = this.onHypixel = serverBrand != null && serverBrand.startsWith(SERVER_BRAND_START);
                    if (serverBrand != null) {
                        this.serverBrandChecked = true;
                    } else {
                        LOGGER.warn("Server brand is null, retrying...");
                    }
                    if (SettingsManager.get().debug.debugModeEnabled) {
                        LOGGER.info("Server Brand: {}", (Object)serverBrand);
                    }
                    if (this.onHypixel) {
                        LOGGER.info("Player joined Hypixel.");
                    }
                }
                if (this.onHypixel && !this.scoreboardChecked) {
                    boolean newSkyBlockState;
                    class_269 scoreboard = player.method_7327();
                    boolean bl = newSkyBlockState = scoreboard.method_1170("SBScoreboard") != null;
                    if (newSkyBlockState != GameState.isOnSkyBlock()) {
                        if (newSkyBlockState) {
                            LOGGER.info("Player joined SkyBlock.");
                        } else {
                            LOGGER.info("Player left SkyBlock.");
                        }
                        GameState.setOnSkyBlock(newSkyBlockState);
                        this.scoreboardChecked = true;
                    }
                    if (class_156.method_658() - this.lastWorldSwitchTime > 5000L) {
                        this.scoreboardChecked = true;
                    }
                }
            }
        });
    }
}

