/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.client.gui.components;

import com.github.yukkuritaku.modernwarpmenu.client.gui.components.CustomContainerButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.grid.GridRectangle;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.transition.ScaleTransition;
import com.github.yukkuritaku.modernwarpmenu.data.layout.texture.LayoutTexture;
import com.github.yukkuritaku.modernwarpmenu.data.settings.SettingsManager;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9848;
import org.joml.Matrix4f;

public class ScaleTransitionButton
extends CustomContainerButton {
    private static final float HOVERED_BRIGHTNESS = 1.0f;
    private static final float UN_HOVERED_BRIGHTNESS = 0.9f;
    protected GridRectangle buttonRectangle;
    protected ScaleTransition transition;
    protected float scaledXPosition;
    protected float scaledYPosition;
    protected float scaledWidth;
    protected float scaledHeight;

    public ScaleTransitionButton(int x, int y, int width, int height, class_2561 message, LayoutTexture backgroundTexture, LayoutTexture foregroundTexture, class_4185.class_4241 onPress, class_4185.class_7841 createNarration) {
        super(x, y, width, height, message, backgroundTexture, foregroundTexture, onPress, createNarration);
    }

    public void calculateHoverState(int mouseX, int mouseY) {
        this.field_22762 = (float)mouseX >= this.scaledXPosition && (float)mouseY >= this.scaledYPosition && (float)mouseX <= this.scaledXPosition + this.scaledWidth && (float)mouseY <= this.scaledYPosition + this.scaledHeight;
    }

    public void transitionStep(long scaleTransitionDuration, float hoveredScale) {
        this.transition.step();
        if (this.field_22762) {
            if (this.transition.getEndScale() == 1.0f) {
                this.transition = new ScaleTransition((long)(this.transition.getProgress() * (float)scaleTransitionDuration), this.transition.getCurrentScale(), hoveredScale);
            }
        } else if (this.transition.getEndScale() == hoveredScale) {
            this.transition = new ScaleTransition((long)(this.transition.getProgress() * (float)scaleTransitionDuration), this.transition.getCurrentScale(), 1.0f);
        }
    }

    public void renderBorder(class_332 guiGraphics, int color) {
        class_4587 stack = guiGraphics.method_51448();
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, (float)this.getZLevel());
        guiGraphics.method_25292((int)this.scaledXPosition, (int)(this.scaledXPosition + this.scaledWidth), (int)this.scaledYPosition, color);
        guiGraphics.method_25301((int)this.scaledXPosition, (int)this.scaledYPosition, (int)(this.scaledYPosition + this.scaledHeight), color);
        guiGraphics.method_25292((int)this.scaledXPosition, (int)(this.scaledXPosition + this.scaledWidth), (int)(this.scaledYPosition + this.scaledHeight), color);
        guiGraphics.method_25301((int)(this.scaledXPosition + this.scaledWidth), (int)this.scaledYPosition, (int)(this.scaledYPosition + this.scaledHeight), color);
        stack.method_22909();
    }

    protected void renderButtonTexture(class_332 guiGraphics, class_2960 texture) {
        class_4587 stack = guiGraphics.method_51448();
        Matrix4f pose = stack.method_23760().method_23761();
        int color = this.field_22762 ? new Color(1.0f, 1.0f, 1.0f, 1.0f).getRGB() : new Color(0.9f, 0.9f, 0.9f, 1.0f).getRGB();
        guiGraphics.method_64039(multiBufferSource -> {
            class_4588 consumer = multiBufferSource.getBuffer(class_1921.method_62277((class_2960)texture));
            consumer.method_22918(pose, this.scaledXPosition, this.scaledYPosition + this.scaledHeight, (float)this.getZLevel()).method_22913(0.0f, 1.0f).method_39415(color);
            consumer.method_22918(pose, this.scaledXPosition + this.scaledWidth, this.scaledYPosition + this.scaledHeight, (float)this.getZLevel()).method_22913(1.0f, 1.0f).method_39415(color);
            consumer.method_22918(pose, this.scaledXPosition + this.scaledWidth, this.scaledYPosition, (float)this.getZLevel()).method_22913(1.0f, 0.0f).method_39415(color);
            consumer.method_22918(pose, this.scaledXPosition, this.scaledYPosition, (float)this.getZLevel()).method_22913(0.0f, 0.0f).method_39415(color);
        });
    }

    public void renderMessageString(class_332 guiGraphics, float xOffset, float yOffset, Color textColor) {
        String[] lines = this.method_25369().getString().split("\n");
        class_4587 stack = guiGraphics.method_51448();
        Color color = this.field_22762 ? new Color((int)((float)textColor.getRed() * 1.0f), (int)((float)textColor.getGreen() * 1.0f), (int)((float)textColor.getBlue() * 1.0f), 255) : new Color((int)((float)textColor.getRed() * 0.9f), (int)((float)textColor.getGreen() * 0.9f), (int)((float)textColor.getBlue() * 0.9f), 255);
        stack.method_22903();
        stack.method_46416(this.scaledXPosition + xOffset, this.scaledYPosition + yOffset, (float)(this.getZLevel() + 1));
        stack.method_22905(this.transition.getCurrentScale(), this.transition.getCurrentScale(), 1.0f);
        for (int i = 0; i < lines.length; ++i) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            String string = lines[i];
            Objects.requireNonNull(class_310.method_1551().field_1772);
            guiGraphics.method_25300(class_3272, string, 0, 9 * i, color.getRGB());
        }
        stack.method_22909();
    }

    protected void renderForegroundLayer(class_332 guiGraphics, class_2960 foregroundTexture) {
        if (foregroundTexture != null) {
            this.renderButtonTexture(guiGraphics, foregroundTexture);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22764) {
            this.method_48579(guiGraphics, mouseX, mouseY, partialTick);
            this.field_41095.method_56142(this.method_49606(), this.method_25370(), this.method_48202());
        }
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22764) {
            this.buttonRectangle.scale(this.transition.getCurrentScale());
            this.scaledXPosition = this.buttonRectangle.getXPosition();
            this.scaledYPosition = this.buttonRectangle.getYPosition();
            this.scaledWidth = this.buttonRectangle.getWidth();
            this.scaledHeight = this.buttonRectangle.getHeight();
            this.renderButtonTexture(guiGraphics, this.backgroundTexture.location());
            if (SettingsManager.get().debug.debugModeEnabled && SettingsManager.get().debug.drawBorders) {
                this.renderBorder(guiGraphics, class_9848.method_61317((float)1.0f));
            }
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && mouseX >= (double)this.scaledXPosition && mouseY >= (double)this.scaledYPosition && mouseX <= (double)(this.scaledXPosition + this.scaledWidth) && mouseY <= (double)(this.scaledYPosition + this.scaledHeight);
    }
}

