/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.client.gui.screens;

import com.github.yukkuritaku.modernwarpmenu.ModernWarpMenu;
import com.github.yukkuritaku.modernwarpmenu.client.gui.components.ConfigButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.components.CustomContainerButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.components.IslandButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.components.RegularWarpMenuButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.components.TimedMessageButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.components.WarpButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.CustomContainerScreen;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.grid.ScaledGrid;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Island;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Layout;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Warp;
import com.github.yukkuritaku.modernwarpmenu.data.settings.SettingsManager;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.menu.Menu;
import com.github.yukkuritaku.modernwarpmenu.listeners.InventoryChangeListener;
import com.github.yukkuritaku.modernwarpmenu.mixin.ScreenAccessor;
import com.github.yukkuritaku.modernwarpmenu.state.ModernWarpMenuState;
import com.github.yukkuritaku.modernwarpmenu.utils.ChatUtils;
import com.github.yukkuritaku.modernwarpmenu.utils.GameCheckUtils;
import com.github.yukkuritaku.modernwarpmenu.utils.WarpVisibilityCheckUtils;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_7940;
import net.minecraft.class_9848;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public class ModernWarpScreen
extends CustomContainerScreen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final long WARP_FAIL_COOL_DOWN = 500L;
    private static final long WARP_FAIL_TOOLTIP_DISPLAY_TIME = 2000L;
    public final Menu warpMenu;
    private Layout layout;
    private final class_1277 chestInventory;
    private ConfigButton configButton;
    private InventoryChangeListener inventoryListener;
    protected int lastSlotIndexToCheck;
    private RuntimeException guiInitException;
    private class_2561 warpFailMessage;
    private final class_2561 originalTitle;
    protected long warpFailCoolDownExpiryTime;
    private long warpFailTooltipExpiryTime;

    public ModernWarpScreen(Menu warpMenu, class_1707 menu, class_1661 playerInventory, Layout layout) {
        super(menu, playerInventory, layout.backgroundTexture(), (class_2561)class_2561.method_43473());
        this.warpMenu = warpMenu;
        this.layout = layout;
        this.chestInventory = (class_1277)((class_1707)playerInventory.field_7546.field_7512).method_7629();
        if (SettingsManager.get().general.warpMenuEnabled) {
            this.setCustomUIState(true, true);
            this.inventoryListener = new InventoryChangeListener(new ChestItemChangeCallback(this));
            this.chestInventory.method_5489((class_1265)this.inventoryListener);
        }
        this.originalTitle = class_2561.method_43470((String)warpMenu.getDisplayName());
    }

    public ScaledGrid getScaledGrid() {
        return this.grid;
    }

    private void onChestItemChange(int triggerCount) {
        if (triggerCount > (this.lastSlotIndexToCheck + 1) * 2) {
            try {
                boolean menuItemsMatch = GameCheckUtils.menuItemsMatch(this.warpMenu, (class_1263)this.chestInventory);
                this.setCustomUIState(menuItemsMatch, menuItemsMatch);
                this.updateButtonStates();
                this.configButton.setVisible(menuItemsMatch);
                if (!menuItemsMatch) {
                    ChatUtils.sendMessageWithModNamePrefix("Warning: Chest has correct name but items mismatched");
                }
            }
            catch (RuntimeException e) {
                ChatUtils.sendErrorMessageWithCopyableThrowable("modernwarpmenu.errors.modernWarpScreen.itemMatchFailed", e);
                this.setCustomUIState(false, false);
            }
            finally {
                class_310.method_1551().execute(() -> this.chestInventory.method_5488((class_1265)this.inventoryListener));
            }
        }
    }

    public void drawExceptionScreen(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
        for (class_4068 renderable : ((ScreenAccessor)((Object)this)).getRenderables()) {
            renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.method_51448().method_22909();
        for (class_364 listener : this.method_25396()) {
            ((class_4185)listener).method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void addIslandButtons() {
        for (Island island : this.layout.islandList()) {
            this.addIslandButton(island);
        }
    }

    protected void addIslandButton(Island island) {
        if (!island.warpList.isEmpty()) {
            IslandButton button = new IslandButton(this, this.window, island, islandButton -> this.islandButtonHandler((IslandButton)islandButton), Supplier::get);
            this.method_37063((class_364)button);
            for (Warp warp : island.warpList) {
                this.method_37063((class_364)new WarpButton(button, warp, warpButton -> this.warpButtonHandler((WarpButton)warpButton), Supplier::get));
            }
        }
    }

    protected void islandButtonHandler(IslandButton button) {
    }

    protected void warpButtonHandler(WarpButton button) {
    }

    public void onWarpFail(String failMessageKey, Object ... replacements) {
        long currentTime = class_156.method_658();
        this.warpFailCoolDownExpiryTime = currentTime + 500L;
        this.warpFailTooltipExpiryTime = currentTime + 2000L;
        this.warpFailMessage = class_2561.method_43469((String)failMessageKey, (Object[])replacements).method_27692(class_124.field_1061);
    }

    protected void clickSlot(int slotIndex) {
        if (slotIndex >= 0 && slotIndex < ((class_1707)this.field_2797).field_7761.size()) {
            class_1735 slotToClick = (class_1735)((class_1707)this.field_2797).field_7761.get(slotIndex);
            if (slotToClick.method_7681()) {
                if (((class_1707)this.field_2797).method_34255().method_7960()) {
                    this.method_2383((class_1735)((class_1707)this.field_2797).field_7761.get(slotIndex), slotIndex, 0, class_1713.field_7790);
                } else {
                    this.onWarpFail(ModernWarpMenu.getFullLanguageKey("errors.mouseIsHoldingItem"), new Object[0]);
                }
            } else {
                this.onWarpFail(ModernWarpMenu.getFullLanguageKey("errors.slotHasNoItem"), slotIndex);
            }
        } else {
            this.onWarpFail(ModernWarpMenu.getFullLanguageKey("errors.slotNumberOutOfBounds"), slotIndex);
        }
    }

    private void renderDebugStrings(class_332 guiGraphics, List<class_2561> debugStrings, int drawX, int drawY, int nearestGridX, int nearestGridY, int zLevel) {
        debugStrings.add((class_2561)class_2561.method_43470((String)("gridX: " + nearestGridX)));
        debugStrings.add((class_2561)class_2561.method_43470((String)("gridY: " + nearestGridY)));
        if (zLevel > -1) {
            debugStrings.add((class_2561)class_2561.method_43470((String)("zLevel: " + zLevel)));
        }
        guiGraphics.method_64038(class_310.method_1551().field_1772, debugStrings, Optional.empty(), drawX, drawY);
        guiGraphics.method_25294(drawX - 2, drawY - 2, drawX + 2, drawY + 2, Color.RED.getRGB());
    }

    protected void method_25426() {
        super.method_25426();
        this.window = class_310.method_1551().method_22683();
        this.grid = new ScaledGrid(0.0f, 0.0f, (float)this.window.method_4486(), (float)this.window.method_4502(), 36, 64, false);
        Warp.initDefaults(this.window);
        this.configButton = new ConfigButton(this.layout, this.window, button -> {
            if (SettingsManager.get().general.warpMenuEnabled) {
                ModernWarpMenuState.setOpenConfigMenuRequested(true);
                if (class_310.method_1551().field_1724 != null) {
                    class_310.method_1551().field_1724.method_7346();
                }
            } else {
                SettingsManager.get().general.warpMenuEnabled = true;
                SettingsManager.save();
                ChatUtils.sendMessageWithModNamePrefix((class_2561)class_2561.method_43471((String)"modernwarpmenu.messages.modernWarpMenuEnabled").method_27692(class_124.field_1060));
                if (GameCheckUtils.menuItemsMatch(this.warpMenu, (class_1263)this.chestInventory)) {
                    this.setCustomUIState(true, true);
                } else {
                    ModernWarpMenuState.setOpenConfigMenuRequested(true);
                    if (class_310.method_1551().field_1724 != null) {
                        class_310.method_1551().field_1724.method_7346();
                    }
                }
            }
        }, Supplier::get);
        this.method_37063((class_364)this.configButton);
        if (this.lastSlotIndexToCheck > this.chestInventory.method_5439()) {
            ChatUtils.sendMessageWithModNamePrefix((class_2561)class_2561.method_43469((String)"modernwarpmenu.errors.modernWarpScreen.chestInventoryTooSmall", (Object[])new Object[]{this.chestInventory.method_5439(), this.lastSlotIndexToCheck}).method_27692(class_124.field_1061));
            this.setCustomUIState(false, false);
            this.chestInventory.method_5488((class_1265)this.inventoryListener);
            return;
        }
        if (SettingsManager.get().general.showRegularWarpMenuButton) {
            this.method_37063((class_364)new RegularWarpMenuButton(this.layout, this.window, this.grid, button -> {
                if (SettingsManager.get().general.warpMenuEnabled) {
                    SettingsManager.get().general.warpMenuEnabled = false;
                    SettingsManager.save();
                    this.setCustomUIState(false, false);
                }
            }, Supplier::get));
        }
        try {
            this.addIslandButtons();
            this.updateButtonStates();
        }
        catch (RuntimeException e) {
            this.guiInitException = e;
            this.method_37067();
            class_310.method_1551().execute(() -> this.chestInventory.method_5488((class_1265)this.inventoryListener));
            int lineCount = 2;
            int labelX = 0;
            int labelY = this.field_22790 / 5;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int ySpacing = 9 + 3;
            for (int i = 0; i < lineCount; ++i) {
                if (i == 0) {
                    widget = new class_7940(labelX, labelY, (class_2561)class_2561.method_43469((String)"modernwarpmenu.errors.modernWarpScreen.initFailed", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()}).method_27692(class_124.field_1061), class_310.method_1551().field_1772);
                    widget.method_48983(class_9848.method_61317((float)1.0f));
                    widget.method_25358(this.field_22789);
                    widget.method_48981(true);
                    this.method_37060((class_4068)widget);
                } else {
                    widget = new class_7940(labelX, labelY, (class_2561)class_2561.method_43470((String)String.format("%s : %s", this.guiInitException.getClass().getName(), this.guiInitException.getLocalizedMessage())).method_27692(class_124.field_1068), class_310.method_1551().field_1772);
                    widget.method_48983(class_9848.method_61317((float)1.0f));
                    widget.method_25358(this.field_22789);
                    widget.method_48981(true);
                    this.method_37060((class_4068)widget);
                }
                labelY += ySpacing;
            }
            this.method_37063((class_364)new TimedMessageButton(this.field_22789 / 2 - 100, labelY + ySpacing, (class_2561)class_2561.method_43471((String)"modernwarpmenu.gui.buttons.copyToClipboard"), button -> {
                class_3728.method_27551((class_310)class_310.method_1551(), (String)ExceptionUtils.getStackTrace((Throwable)this.guiInitException));
                ((TimedMessageButton)button).setTimedMessage((class_2561)class_2561.method_43471((String)"modernwarpmenu.gui.buttons.copyToClipboard.copied"), 1500);
            }, Supplier::get));
            LOGGER.error("Errored!", (Throwable)e);
        }
    }

    @Override
    protected void updateButtonStates() {
        for (class_364 listener : this.method_25396()) {
            Island island;
            if (!(listener instanceof CustomContainerButton)) continue;
            CustomContainerButton button = (CustomContainerButton)listener;
            if (listener instanceof ConfigButton) continue;
            button.setActive(this.customUIInteractionEnabled);
            button.setVisible(this.renderCustomUI);
            if (!this.renderCustomUI) continue;
            if (button instanceof IslandButton) {
                IslandButton islandButton = (IslandButton)button;
                island = islandButton.island;
                if (island.warpList.size() != 1) continue;
                boolean showIsland = WarpVisibilityCheckUtils.shouldShowSingleWarpIsland(island);
                button.setVisible(showIsland);
                continue;
            }
            if (!(button instanceof WarpButton)) continue;
            WarpButton warpButton = (WarpButton)button;
            island = warpButton.getIsland();
            Warp warp = warpButton.getWarp();
            boolean shouldShowWarp = WarpVisibilityCheckUtils.shouldShowWarp(warp);
            if (island.warpList.size() == 1) {
                warpButton.setDrawWarpLabel(!SettingsManager.get().general.hideWarpLabelForIslandsWithOneWarp);
            }
            warpButton.setVisible(shouldShowWarp);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.customUIInteractionEnabled) {
            return this.customUIMouseClicked(mouseX, mouseY, button);
        }
        if (button == 0 && this.configButton != null && this.configButton.method_25367()) {
            return this.configButton.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected void renderButtons(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (class_4068 renderable : ((ScreenAccessor)((Object)this)).getRenderables()) {
            if (!(renderable instanceof ConfigButton) && !SettingsManager.get().general.warpMenuEnabled) continue;
            renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected void renderCustomUI(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.guiInitException != null) {
            this.drawExceptionScreen(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.method_2389(guiGraphics, partialTick, mouseX, mouseY);
        ArrayList<IslandButton> hoveredButtons = new ArrayList<IslandButton>();
        for (class_364 listener : this.method_25396()) {
            if (!(listener instanceof IslandButton)) continue;
            IslandButton islandButton = (IslandButton)listener;
            islandButton.calculateHoverState(mouseX, mouseY);
            if (!islandButton.method_25367()) continue;
            hoveredButtons.add(islandButton);
        }
        for (int i = 0; i < hoveredButtons.size() - 1; ++i) {
            ((CustomContainerButton)((Object)hoveredButtons.get(i))).setHovered(false);
        }
        this.renderButtons(guiGraphics, mouseX, mouseY, partialTick);
        if (class_156.method_658() <= this.warpFailTooltipExpiryTime && this.warpFailMessage != null) {
            guiGraphics.method_51438(class_310.method_1551().field_1772, this.warpFailMessage, mouseX, mouseY);
        }
        if (SettingsManager.get().debug.debugModeEnabled && SettingsManager.get().debug.showDebugOverlay) {
            int nearestY;
            int nearestX;
            ArrayList<class_2561> debugMessages = new ArrayList<class_2561>();
            boolean tooltipDrawn = false;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 20.0f);
            guiGraphics.method_25300(class_310.method_1551().field_1772, String.format("%d x %d (%d)", this.window.method_4486(), this.window.method_4502(), this.window.method_4476(((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).intValue(), class_310.method_1551().method_1573())), this.field_22789 / 2, this.field_22790 - 20, 0xE0E0E0);
            FabricLoader.getInstance().getModContainer("modernwarpmenu").ifPresent(modContainer -> {
                String name = modContainer.getMetadata().getName();
                String version = modContainer.getMetadata().getVersion().getFriendlyString();
                guiGraphics.method_25300(class_310.method_1551().field_1772, name + " " + version, this.field_22789 / 2, this.field_22790 - 10, 0xE0E0E0);
            });
            if (!ModernWarpScreen.method_25442()) {
                for (class_364 button : this.method_25396()) {
                    IslandButton islandBtn;
                    if (!(button instanceof IslandButton) || !(islandBtn = (IslandButton)button).method_25367()) continue;
                    debugMessages.add((class_2561)islandBtn.method_25369().method_27661().method_27692(class_124.field_1060));
                    nearestX = islandBtn.scaledGrid.findNearestGridX(mouseX);
                    nearestY = islandBtn.scaledGrid.findNearestGridY(mouseY);
                    int drawX = (int)islandBtn.scaledGrid.getActualX(nearestX);
                    int drawY = (int)islandBtn.scaledGrid.getActualY(nearestY);
                    this.renderDebugStrings(guiGraphics, debugMessages, drawX, drawY, nearestX, nearestY, islandBtn.getZLevel());
                    tooltipDrawn = true;
                    break;
                }
            }
            if (!tooltipDrawn) {
                nearestX = this.grid.findNearestGridX(mouseX);
                nearestY = this.grid.findNearestGridY(mouseY);
                int drawX = (int)this.grid.getActualX(nearestX);
                int drawY = (int)this.grid.getActualY(nearestY);
                this.renderDebugStrings(guiGraphics, debugMessages, drawX, drawY, nearestX, nearestY, -1);
            }
            guiGraphics.method_51448().method_22909();
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.originalTitle, this.field_25267, this.field_25268, 0x404040, false);
        super.method_2388(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected boolean customUIKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.guiInitException != null) {
            return false;
        }
        if (SettingsManager.get().debug.debugModeEnabled) {
            if (keyCode == 82) {
                if (ModernWarpScreen.method_25442()) {
                    class_310.method_1551().method_1521().thenAcceptAsync(v -> {
                        this.layout = ModernWarpMenuState.getLayoutForMenu(this.warpMenu);
                        this.method_25426();
                    }, this.field_44944);
                    return true;
                }
            } else {
                if (keyCode == 258) {
                    SettingsManager.get().debug.showDebugOverlay = !SettingsManager.get().debug.showDebugOverlay;
                    SettingsManager.save();
                    return true;
                }
                if (keyCode == 66) {
                    SettingsManager.get().debug.drawBorders = !SettingsManager.get().debug.drawBorders;
                    SettingsManager.save();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean customUIMouseClicked(double mouseX, double mouseY, int button) {
        block1: {
            class_364 listener;
            if (button != 0) break block1;
            Iterator iterator = this.method_25396().reversed().iterator();
            while (!(!iterator.hasNext() || (listener = (class_364)iterator.next()) instanceof CustomContainerButton && listener.method_25402(mouseX, mouseY, button))) {
            }
        }
        return true;
    }

    private static class ChestItemChangeCallback
    implements Consumer<class_1263> {
        private final ModernWarpScreen modernWarpScreen;
        private int triggerCount;

        ChestItemChangeCallback(ModernWarpScreen modernWarpScreen) {
            this.modernWarpScreen = modernWarpScreen;
            this.triggerCount = 0;
        }

        @Override
        public void accept(class_1263 chestInventory) {
            ++this.triggerCount;
            this.modernWarpScreen.onChestItemChange(this.triggerCount);
        }
    }
}

