/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.client.resources;

import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.SkyBlockConstants;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.WarpMessages;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import org.slf4j.Logger;

public class SkyBlockConstantsManager
implements IdentifiableResourceReloadListener {
    private static final class_2960 SKY_BLOCK_CONSTANTS_LOCATION = class_2960.method_60655((String)"modernwarpmenu", (String)"constants/skyblock_constants.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private SkyBlockConstants skyBlockConstants;

    public SkyBlockConstants getSkyBlockConstants() {
        return this.skyBlockConstants;
    }

    private static void handleLoadException(class_3298 resource, class_2960 location, Exception e) {
        class_128 crashReport = new class_128("Your Modern Warp Menu resource pack may be outdated, or something wrong with json", (Throwable)e);
        class_129 resourceCategory = crashReport.method_562("Resource");
        class_129 resourcePackCategory = crashReport.method_562("Resource Pack");
        resourceCategory.method_578("Path", (Object)location.toString());
        resourcePackCategory.method_578("Name", (Object)resource.method_45304().method_56926().comp_2330().getString());
        throw new class_148(crashReport);
    }

    private static SkyBlockConstants loadSkyBlockConstants(class_3298 resource) {
        SkyBlockConstants skyBlockConstants;
        block8: {
            BufferedReader reader = resource.method_43039();
            try {
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                skyBlockConstants = (SkyBlockConstants)SkyBlockConstants.CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonParseException::new);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SkyBlockConstantsManager.handleLoadException(resource, SKY_BLOCK_CONSTANTS_LOCATION, e);
                    return new SkyBlockConstants(Maps.newHashMap(), new WarpMessages(Lists.newArrayList(), Maps.newHashMap()), Lists.newArrayList(), "");
                }
            }
            ((Reader)reader).close();
        }
        return skyBlockConstants;
    }

    protected CompletableFuture<SkyBlockConstants> prepare(class_3300 resourceManager, Executor io) {
        try {
            class_3298 resource = resourceManager.getResourceOrThrow(SKY_BLOCK_CONSTANTS_LOCATION);
            return CompletableFuture.supplyAsync(() -> SkyBlockConstantsManager.loadSkyBlockConstants(resource), io);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load SkyBlockConstants", (Throwable)e);
            return CompletableFuture.supplyAsync(() -> new SkyBlockConstants(Maps.newHashMap(), new WarpMessages(Lists.newArrayList(), Maps.newHashMap()), Lists.newArrayList(), ""));
        }
    }

    protected void apply(SkyBlockConstants object) {
        this.skyBlockConstants = object;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, Executor io, Executor game) {
        return ((CompletableFuture)this.prepare(resourceManager, io).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(this::apply, game);
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"modernwarpmenu", (String)"skyblock_constants");
    }
}

