/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.data.layout;

import com.github.yukkuritaku.modernwarpmenu.data.layout.texture.LayoutTexture;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public class Button {
    public static final MapCodec<Button> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LayoutTexture.CODEC.fieldOf("texture").forGetter(button -> button.texture), (App)class_5699.field_33441.fieldOf("grid_x").forGetter(button -> button.gridX), (App)class_5699.field_33441.fieldOf("grid_y").forGetter(button -> button.gridY), (App)class_5699.field_53754.fieldOf("width_percentage").forGetter(button -> Float.valueOf(button.widthPercentage))).apply((Applicative)instance, Button::new)).validate(Button::validate);
    public static final class_2960 NOTIFICATION = class_2960.method_60655((String)"modernwarpmenu", (String)"textures/gui/notification.png");
    public final LayoutTexture texture;
    public final int gridX;
    public final int gridY;
    public final float widthPercentage;
    private transient int width;
    private transient int height;

    Button(LayoutTexture texture, int gridX, int gridY, float widthPercentage) {
        this.texture = texture;
        this.gridX = gridX;
        this.gridY = gridY;
        this.widthPercentage = widthPercentage;
    }

    private static DataResult<Button> validate(Button button) {
        if (button.gridX < 0 || button.gridX > 64) {
            return DataResult.error(() -> "Button grid_x must be between 0 and 64 inclusive");
        }
        if (button.gridY < 0 || button.gridY > 36) {
            return DataResult.error(() -> "Button grid_y must be between 0 and 36 inclusive");
        }
        if (button.widthPercentage <= 0.0f || button.widthPercentage > 1.0f) {
            return DataResult.error(() -> "Button icon width_percentage must be within the interval (0,1]");
        }
        return DataResult.success((Object)button);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void init(class_1041 window) {
        this.width = (int)((float)window.method_4486() * this.widthPercentage);
        float scaleFactor = (float)this.width / (float)this.texture.width();
        this.height = (int)((float)this.texture.height() * scaleFactor);
    }
}

