/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.data.layout;

import com.github.yukkuritaku.modernwarpmenu.data.layout.texture.LayoutTexture;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record WarpIcon(LayoutTexture texture, LayoutTexture hoverEffectTexture, float widthPercentage) {
    public static final MapCodec<WarpIcon> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LayoutTexture.CODEC.fieldOf("texture").forGetter(warpIcon -> warpIcon.texture), (App)LayoutTexture.CODEC.codec().fieldOf("hover_effect_texture").forGetter(warpIcon -> warpIcon.hoverEffectTexture), (App)Codec.FLOAT.fieldOf("width_percentage").forGetter(warpIcon -> Float.valueOf(warpIcon.widthPercentage))).apply((Applicative)instance, WarpIcon::new)).validate(WarpIcon::validate);

    public WarpIcon(LayoutTexture texture, float widthPercentage) {
        this(texture, texture, widthPercentage);
    }

    private static DataResult<WarpIcon> validate(WarpIcon warpIcon) {
        return warpIcon.widthPercentage < 0.0f || warpIcon.widthPercentage > 1.0f ? DataResult.error(() -> "Warp icon width_percentage must be between 0 and 1, but got " + warpIcon.widthPercentage) : DataResult.success((Object)warpIcon);
    }
}

