/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants;

import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.SkyBlockConstants;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.WarpCommandVariant;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.WarpMessages;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.menu.ItemMatchCondition;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.menu.Menu;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public class SkyBlockConstantsProvider
implements class_2405 {
    private final List<SkyBlockConstantsFile> skyBlockConstantsFiles = Collections.synchronizedList(new LinkedList());
    private final class_7784.class_7489 pathProvider;
    private final String modid;

    public SkyBlockConstantsProvider(class_7784 output, String modid) {
        this.pathProvider = output.method_45973(class_7784.class_7490.field_39368, "constants");
        this.modid = modid;
    }

    protected Path getPath(class_2960 id) {
        return this.pathProvider.method_44107(id);
    }

    private CompletableFuture<?> generateFeatures(class_7403 cache) {
        CompletableFuture[] completableFutures = new CompletableFuture[this.skyBlockConstantsFiles.size()];
        int size = 0;
        for (SkyBlockConstantsFile constant : this.skyBlockConstantsFiles) {
            Path target = this.getPath(class_2960.method_60655((String)this.modid, (String)constant.fileName));
            completableFutures[size++] = class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)SkyBlockConstants.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)constant.constants).getOrThrow(IllegalStateException::new)), (Path)target);
        }
        return CompletableFuture.allOf(completableFutures);
    }

    private void addConstants() {
        this.skyBlockConstantsFiles.add(new SkyBlockConstantsFile(new SkyBlockConstants(Map.of(Menu.FAST_TRAVEL, List.of(new ItemMatchCondition(45, "Island Browser", List.of(), "minecraft:blaze_powder", List.of(), "", List.of(), ItemMatchCondition.EMPTY_PATTERN), new ItemMatchCondition(49, "Close", List.of(), "minecraft:barrier", List.of(), "", List.of(), ItemMatchCondition.EMPTY_PATTERN), new ItemMatchCondition(53, "Paper Icons", List.of(), "", List.of("minecraft:map", "minecraft:filled_map"), "", List.of(), ItemMatchCondition.EMPTY_PATTERN)), Menu.PORHTAL, List.of(new ItemMatchCondition(31, "Close", List.of(), "minecraft:barrier", List.of(), "", List.of(), ItemMatchCondition.EMPTY_PATTERN))), new WarpMessages(Collections.singletonList("Warping..."), Map.of("Unknown destination! Check the Fast Travel menu to view options!", "modernwarpmenu.errors.unknownDestination", "You haven't unlocked this fast travel destination!", "modernwarpmenu.errors.notUnlocked", "Couldn't warp you! Try again later. (NO_DESTINATION_FOUND)", "modernwarpmenu.errors.noDestination", "You need to have visited this island at least once before fast traveling to it!", "modernwarpmenu.errors.notVisited", "Jerry's Workshop is only available during the Winter!", "modernwarpmenu.errors.notOpenYet")), List.of(new WarpCommandVariant("warp", WarpCommandVariant.WarpCommandType.ALIAS), new WarpCommandVariant("travel", WarpCommandVariant.WarpCommandType.ALIAS), new WarpCommandVariant("is", WarpCommandVariant.WarpCommandType.WARP), new WarpCommandVariant("hub", WarpCommandVariant.WarpCommandType.WARP), new WarpCommandVariant("warpforge", WarpCommandVariant.WarpCommandType.WARP), new WarpCommandVariant("savethejerrys", WarpCommandVariant.WarpCommandType.WARP), new WarpCommandVariant("garry", WarpCommandVariant.WarpCommandType.WARP)), ""), "skyblock_constants"));
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        this.addConstants();
        return CompletableFuture.allOf(this.generateFeatures(output));
    }

    public String method_10321() {
        return "constants";
    }

    public record SkyBlockConstantsFile(SkyBlockConstants constants, String fileName) {
    }
}

