/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.client.gui.screens;

import com.github.yukkuritaku.modernwarpmenu.client.gui.components.CustomContainerButton;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.grid.ScaledGrid;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Layout;
import net.minecraft.class_1041;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_476;

public abstract class CustomContainerScreen
extends class_476 {
    protected class_1041 window;
    protected ScaledGrid grid;
    protected class_2960 backgroundTextureLocation;
    protected boolean renderCustomUI;
    protected boolean customUIInteractionEnabled;
    protected class_4185 selectedButton;

    public CustomContainerScreen(class_1707 menu, class_1661 playerInventory, class_2960 backgroundTextureLocation, class_2561 title) {
        this(menu, playerInventory, backgroundTextureLocation, false, false, title);
    }

    public CustomContainerScreen(class_1707 menu, class_1661 playerInventory, class_2960 backgroundTextureLocation, boolean renderCustomUI, boolean customUIInteractionEnabled, class_2561 title) {
        super(menu, playerInventory, title);
        this.backgroundTextureLocation = backgroundTextureLocation;
        this.renderCustomUI = renderCustomUI;
        this.customUIInteractionEnabled = customUIInteractionEnabled;
    }

    protected abstract void renderButtons(class_332 var1, int var2, int var3, float var4);

    protected abstract void renderCustomUI(class_332 var1, int var2, int var3, float var4);

    protected abstract boolean customUIKeyPressed(int var1, int var2, int var3);

    protected abstract boolean customUIMouseClicked(double var1, double var3, int var5);

    protected void setCustomUIState(boolean renderCustomUI, boolean customUIInteractionEnabled) {
        this.renderCustomUI = renderCustomUI;
        this.customUIInteractionEnabled = customUIInteractionEnabled;
        this.updateButtonStates();
    }

    protected void updateButtonStates() {
        for (class_364 listener : this.method_25396()) {
            if (!(listener instanceof CustomContainerButton)) continue;
            CustomContainerButton containerButton = (CustomContainerButton)listener;
            containerButton.setActive(this.customUIInteractionEnabled);
            containerButton.setVisible(this.renderCustomUI);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.renderCustomUI) {
            this.renderCustomUI(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.renderCustomUI) {
            this.method_2389(guiGraphics, partialTick, mouseX, mouseY);
        } else {
            super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        if (this.renderCustomUI) {
            if (this.backgroundTextureLocation != Layout.EMPTY) {
                CustomContainerScreen.method_57737((class_332)guiGraphics, (class_2960)this.backgroundTextureLocation, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)guiGraphics.method_51421(), (int)guiGraphics.method_51443());
            } else {
                this.method_52752(guiGraphics);
            }
        } else {
            super.method_2389(guiGraphics, partialTick, mouseX, mouseY);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.customUIInteractionEnabled) {
            if (keyCode == 256 || class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            return this.customUIKeyPressed(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.customUIInteractionEnabled) {
            return this.customUIMouseClicked(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.customUIInteractionEnabled) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.customUIInteractionEnabled && this.selectedButton != null && button == 0) {
            boolean result = this.selectedButton.method_25406(mouseX, mouseY, button);
            this.selectedButton = null;
            return result;
        }
        return super.method_25406(mouseX, mouseY, button);
    }
}

