/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.data.layout;

import com.github.yukkuritaku.modernwarpmenu.data.layout.Warp;
import com.github.yukkuritaku.modernwarpmenu.data.layout.texture.LayoutTexture;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_5699;

public class Island {
    public static final MapCodec<Island> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_41759.fieldOf("name").forGetter(island -> island.name), (App)LayoutTexture.CODEC.fieldOf("texture").forGetter(island -> island.texture), (App)LayoutTexture.CODEC.fieldOf("hover_effect_texture").forGetter(island -> island.hoverEffectTexture), (App)class_5699.field_33441.fieldOf("grid_x").forGetter(island -> island.gridX), (App)class_5699.field_33441.fieldOf("grid_y").forGetter(island -> island.gridY), (App)class_5699.field_33441.fieldOf("z_level").forGetter(island -> island.zLevel), (App)class_5699.field_53754.fieldOf("width_percentage").forGetter(island -> Float.valueOf(island.widthPercentage)), (App)Warp.CODEC.codec().listOf().fieldOf("warp_list").forGetter(island -> island.warpList)).apply((Applicative)instance, Island::new)).validate(Island::validate);
    public static final int GRID_UNIT_WIDTH_FACTOR = 64;
    public static final int GRID_UNIT_HEIGHT_FACTOR = 36;
    public final String name;
    public final LayoutTexture texture;
    public final LayoutTexture hoverEffectTexture;
    public final int gridX;
    public final int gridY;
    public final int zLevel;
    public final float widthPercentage;
    public final List<Warp> warpList;
    private transient int width;
    private transient int height;

    Island(String name, LayoutTexture texture, int gridX, int gridY, int zLevel, float widthPercentage, List<Warp> warpList) {
        this(name, texture, texture, gridX, gridY, zLevel, widthPercentage, warpList);
    }

    Island(String name, LayoutTexture texture, LayoutTexture hoverEffectTexture, int gridX, int gridY, int zLevel, float widthPercentage, List<Warp> warpList) {
        this.name = name;
        this.texture = texture;
        this.hoverEffectTexture = hoverEffectTexture;
        this.gridX = gridX;
        this.gridY = gridY;
        this.zLevel = zLevel;
        this.widthPercentage = widthPercentage;
        this.warpList = warpList;
    }

    private static DataResult<Island> validate(Island island) {
        if (island.gridX < 0 || island.gridX > 64) {
            return DataResult.error(() -> "Island " + island.name + " grid_x is outside screen");
        }
        if (island.gridY < 0 || island.gridY > 36) {
            return DataResult.error(() -> "Island " + island.name + " grid_y is outside screen");
        }
        if (island.zLevel < 0) {
            return DataResult.error(() -> "Island " + island.name + " z_level is outside screen");
        }
        if (island.zLevel >= 10) {
            return DataResult.error(() -> "Island " + island.name + " z_level is too high. Z levels 10+ are reserved for warp buttons.");
        }
        if (island.widthPercentage < 0.0f || island.widthPercentage > 1.0f) {
            return DataResult.error(() -> "Island " + island.name + " width_percentage must be between 0 and 1");
        }
        if (island.warpList == null || island.warpList.isEmpty()) {
            return DataResult.error(() -> "Island " + island.name + " has no warps");
        }
        return DataResult.success((Object)island);
    }

    public void init(class_1041 res) {
        this.width = (int)((float)res.method_4486() * this.widthPercentage);
        float scaleFactor = (float)this.width / (float)this.texture.width();
        this.height = (int)((float)this.texture.height() * scaleFactor);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

