/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants;

import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.WarpCommandVariant;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.WarpMessages;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.menu.ItemMatchCondition;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.menu.Menu;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;

public record SkyBlockConstants(Map<Menu, List<ItemMatchCondition>> menuMatchingMap, WarpMessages warpMessages, List<WarpCommandVariant> warpCommandVariants, String skyBlockJoinMessage) {
    private static final Codec<Map<Menu, List<ItemMatchCondition>>> MENU_MATCHING_MAP_CODEC = Codec.unboundedMap(Menu.CODEC, (Codec)ItemMatchCondition.CODEC.codec().listOf());
    public static final MapCodec<SkyBlockConstants> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MENU_MATCHING_MAP_CODEC.fieldOf("menu_matching").forGetter(SkyBlockConstants::menuMatchingMap), (App)WarpMessages.CODEC.fieldOf("warp_messages").forGetter(SkyBlockConstants::warpMessages), (App)WarpCommandVariant.CODEC.codec().listOf().fieldOf("warp_command_variants").forGetter(SkyBlockConstants::warpCommandVariants), (App)Codec.STRING.optionalFieldOf("skyblock_join_message", null).forGetter(SkyBlockConstants::skyBlockJoinMessage)).apply((Applicative)instance, SkyBlockConstants::new)).validate(SkyBlockConstants::validate);
    public static final String WARP_COMMAND_BASE = "/warp";

    private static DataResult<SkyBlockConstants> validate(SkyBlockConstants constants) {
        if (constants.warpCommandVariants == null || constants.warpCommandVariants.isEmpty()) {
            return DataResult.error(() -> "Warp command variant list cannot be empty");
        }
        return DataResult.success((Object)constants);
    }

    public int getLastMatchConditionInventorySlotIndex(Menu menu) {
        List<ItemMatchCondition> matchConditions = this.menuMatchingMap.get((Object)menu);
        return matchConditions.getLast().inventorySlot();
    }
}

