/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.listeners;

import com.github.yukkuritaku.modernwarpmenu.ModernWarpMenu;
import com.github.yukkuritaku.modernwarpmenu.client.gui.screens.ModernWarpScreen;
import com.github.yukkuritaku.modernwarpmenu.data.settings.SettingsManager;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.WarpCommandVariant;
import com.github.yukkuritaku.modernwarpmenu.state.ModernWarpMenuState;
import com.github.yukkuritaku.modernwarpmenu.utils.ChatUtils;
import java.util.Locale;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_8623;

public class ChatListener {
    private final class_310 mc = class_310.method_1551();
    private boolean chatMessageSendDetected;

    public void registerEvents() {
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            if (ModernWarpMenuState.isModernWarpMenuOpen()) {
                String text = message.getString();
                if (ModernWarpMenu.getInstance().getSkyBlockConstantsManager().getSkyBlockConstants().warpMessages().warpFailMessages().containsKey(text)) {
                    String failMessageKey = ModernWarpMenu.getInstance().getSkyBlockConstantsManager().getSkyBlockConstants().warpMessages().warpFailMessages().get(text);
                    if (this.mc.field_1755 != null && this.mc.field_1755 instanceof ModernWarpScreen) {
                        ((ModernWarpScreen)this.mc.field_1755).onWarpFail(failMessageKey, new Object[0]);
                    }
                }
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (this.chatMessageSendDetected && client.field_1755 instanceof class_408 && screen == null) {
                this.chatMessageSendDetected = false;
                class_8623 sentMessages = this.mc.field_1705.method_1743().method_1809();
                if (!sentMessages.isEmpty()) {
                    this.checkChatMessageForReminder((String)sentMessages.getLast());
                }
            }
        });
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_408) {
                ScreenKeyboardEvents.allowKeyPress((class_437)screen).register((chatScreen, key, scancode, modifiers) -> {
                    if (key == 257 || key == 335) {
                        this.chatMessageSendDetected = true;
                        return true;
                    }
                    return true;
                });
            }
        });
    }

    private void checkChatMessageForReminder(String sentChatMessage) {
        if (SettingsManager.get().general.suggestWarpMenuOnWarpCommand && this.getWarpCommandVariant(sentChatMessage) != null) {
            this.sendReminderToUseModernMenu();
        }
    }

    private WarpCommandVariant getWarpCommandVariant(String command) {
        String baseCommand = command.toLowerCase(Locale.US).substring(1).split(" ")[0];
        for (WarpCommandVariant commandVariant : ModernWarpMenu.getInstance().getSkyBlockConstantsManager().getSkyBlockConstants().warpCommandVariants()) {
            if (!commandVariant.command().equals(baseCommand)) continue;
            return commandVariant;
        }
        return null;
    }

    private void sendReminderToUseModernMenu() {
        ChatUtils.sendMessageWithModNamePrefix((class_2561)class_2561.method_43471((String)ModernWarpMenu.getFullLanguageKey("messages.useWarpMenuInsteadOfCommand")).method_27696(class_2583.field_24360.method_10977(class_124.field_1061)));
    }
}

