/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.utils;

import com.github.yukkuritaku.modernwarpmenu.ModernWarpMenu;
import com.github.yukkuritaku.modernwarpmenu.data.settings.SettingsManager;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.menu.ItemMatchCondition;
import com.github.yukkuritaku.modernwarpmenu.data.skyblockconstants.menu.Menu;
import com.github.yukkuritaku.modernwarpmenu.state.GameState;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1263;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_9015;
import org.slf4j.Logger;

public class GameCheckUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Matcher seasonMatcher = Pattern.compile("(?<seasonStage>Late|Early)? ?(?<season>[a-zA-Z]+) \\d{1,2}.*").matcher("");

    public static void checkSeason() {
        if (!SettingsManager.get().debug.skipSkyBlockCheck) {
            try {
                if (class_310.method_1551().field_1687 != null) {
                    class_269 sb = class_310.method_1551().field_1687.method_8428();
                    for (class_9015 holder : sb.method_1178()) {
                        class_268 team = sb.method_1164(holder.method_5820());
                        if (team == null) continue;
                        String scoreboardLine = team.method_1144().getString().trim();
                        seasonMatcher.reset(scoreboardLine);
                        if (!seasonMatcher.matches()) continue;
                        String seasonStage = seasonMatcher.group("seasonStage");
                        String season = seasonMatcher.group("season");
                        if (SettingsManager.get().debug.debugModeEnabled) {
                            LOGGER.info("Season: {}, SeasonStage: {}", (Object)season, (Object)seasonStage);
                        }
                        GameState.setSeasonStage(seasonStage);
                        if (season == null) continue;
                        GameState.setSeason(season);
                        return;
                    }
                }
                GameState.setSeasonStage(null);
                GameState.setSeason(null);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Failed to check scoreboard season", (Throwable)e);
            }
        }
    }

    public static Menu determineOpenMenu(class_2561 component) {
        String chestTitle = component.getString();
        for (Menu menu : ModernWarpMenu.getInstance().getSkyBlockConstantsManager().getSkyBlockConstants().menuMatchingMap().keySet()) {
            if (!chestTitle.equals(menu.getDisplayName())) continue;
            return menu;
        }
        return Menu.NONE;
    }

    public static boolean menuItemsMatch(Menu menu, class_1263 chestContainer) {
        List<ItemMatchCondition> matchConditions = ModernWarpMenu.getInstance().getSkyBlockConstantsManager().getSkyBlockConstants().menuMatchingMap().get((Object)menu);
        for (ItemMatchCondition matchCondition : matchConditions) {
            LOGGER.debug("Starting item match on slot {} for menu {}.", (Object)matchCondition.inventorySlot(), (Object)menu);
            if (!matchCondition.inventoryContainsMatchingItem(chestContainer)) {
                LOGGER.warn("Item match on slot {} failed.", (Object)matchCondition.inventorySlot());
                GameState.setCurrentMenu(Menu.NONE);
                return false;
            }
            LOGGER.debug("Finished item match on slot {} for menu {}.", (Object)matchCondition.inventorySlot(), (Object)menu);
        }
        GameState.setCurrentMenu(menu);
        return true;
    }
}

