/*
 * Decompiled with CFR 0.152.
 */
package com.github.yukkuritaku.modernwarpmenu.utils;

import com.github.yukkuritaku.modernwarpmenu.data.layout.Island;
import com.github.yukkuritaku.modernwarpmenu.data.layout.Warp;
import com.github.yukkuritaku.modernwarpmenu.data.settings.SettingsManager;
import com.github.yukkuritaku.modernwarpmenu.state.GameState;
import java.util.List;

public class WarpVisibilityCheckUtils {
    public static boolean shouldShowSingleWarpIsland(Island island) {
        if (island.warpList.size() > 1) {
            throw new IllegalArgumentException("Island has more than one warp");
        }
        return WarpVisibilityCheckUtils.shouldShowWarp(island.warpList.getFirst());
    }

    public static boolean shouldShowWarp(Warp warp) {
        List<String> warpTags = warp.tags();
        if (warpTags != null && !warpTags.isEmpty()) {
            for (String tag : warpTags) {
                if (WarpVisibilityCheckUtils.shouldShowWarpWithTag(tag)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean shouldShowWarpWithTag(String tag) {
        switch (tag) {
            case "bingo": {
                return !SettingsManager.get().general.hideUnobtainableWarps;
            }
            case "jerry": {
                if (SettingsManager.get().debug.debugModeEnabled && SettingsManager.get().debug.alwaysShowJerryIsland) {
                    return true;
                }
                if (!SettingsManager.get().general.showJerryIsland) {
                    return false;
                }
                String season = GameState.getSeason();
                String seasonStage = GameState.getSeasonStage();
                return season != null && seasonStage != null && season.equals("Winter") && seasonStage.equals("Late");
            }
        }
        return true;
    }
}

