/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.util.ComponentBuilder;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.moddingx.libx.render.RenderHelper;

public abstract class BaseScreen
extends Screen {
    protected static final ResourceLocation GENERIC = ResourceLocation.fromNamespaceAndPath((String)SkyGUIs.getInstance().modid, (String)"textures/gui/generic.png");
    protected static final MutableComponent PREV_SCREEN_COMPONENT = ComponentBuilder.text("previous_screen", new Object[0]);
    public static final OnAbort DEFAULT_ABORT = () -> Minecraft.getInstance().popGuiLayer();
    public static final MutableComponent OPEN_NEW_SCREEN = ComponentBuilder.text("new_screen", new Object[0]).withStyle(ChatFormatting.ITALIC);
    @Nonnull
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected final int xSize;
    protected final int ySize;
    protected int relX;
    protected int relY;

    public BaseScreen(Component component, int xSize, int ySize) {
        super(component);
        this.xSize = xSize;
        this.ySize = ySize;
        NeoForge.EVENT_BUS.addListener(this::guiInitPre);
    }

    private void guiInitPre(ScreenEvent.Init.Pre event) {
        this.relX = (event.getScreen().width - this.xSize) / 2;
        this.relY = (event.getScreen().height - this.ySize) / 2;
    }

    public final void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderForeground(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderHelper.renderGuiBackground((GuiGraphics)guiGraphics, (int)this.relX, (int)this.relY, (int)this.xSize, (int)this.ySize, (ResourceLocation)GENERIC, (int)128, (int)64, (int)4, (int)125, (int)4, (int)60);
    }

    public void renderForeground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void renderTitle(@Nonnull GuiGraphics guiGraphics) {
        guiGraphics.drawString(this.font, this.title, this.centeredX(this.font.width(this.title.getVisualOrderText())), this.y(10), Color.DARK_GRAY.getRGB(), false);
    }

    public float centeredX(float width) {
        return this.x((float)this.xSize / 2.0f - width);
    }

    public float centeredY(float height) {
        return this.x((float)this.xSize / 2.0f - height);
    }

    public int centeredX(int width) {
        return (int)this.x((float)this.xSize / 2.0f - (float)width / 2.0f);
    }

    public int centeredY(int height) {
        return (int)this.y((float)this.ySize / 2.0f - (float)height / 2.0f);
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public int getRelX() {
        return this.relX;
    }

    public int getRelY() {
        return this.relY;
    }

    public int x(int x) {
        return this.relX + x;
    }

    public int y(int y) {
        return this.relY + y;
    }

    public float x(float x) {
        return (float)this.relX + x;
    }

    public float y(float y) {
        return (float)this.relY + y;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mapping = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mapping) && !(this.getFocused() instanceof EditBox)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static interface OnAbort {
        public void onAbort();
    }

    public static interface OnConfirm {
        public void onConfirm();
    }
}

