/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.base.list;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.widget.RenderArea;
import de.melanx.skyguis.client.widget.ScrollbarWidget;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.TextHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.moddingx.libx.impl.config.gui.screen.widget.TextWidget;
import org.moddingx.libx.render.FilterGuiGraphics;
import org.moddingx.libx.screen.Panel;

public abstract class ListScreen<T>
extends BaseScreen {
    protected static final Component SELECT_ALL = ComponentBuilder.text("select_all", new Object[0]);
    protected static final Component UNSELECT_ALL = ComponentBuilder.text("unselect_all", new Object[0]);
    protected static final int ENTRY_HEIGHT = 14;
    private final ScrollbarInfo scrollbarInfo;
    private final RenderAreaInfo renderAreaInfo;
    private final Set<CheckboxTextWidget> widgets = new HashSet<CheckboxTextWidget>();
    protected final List<T> values;
    protected RenderArea renderArea;
    protected ScrollbarWidget scrollbar;
    private final List<Pair<Matrix4f, Consumer<GuiGraphics>>> capturedTooltips = new LinkedList<Pair<Matrix4f, Consumer<GuiGraphics>>>();
    private boolean isCapturingTooltips = false;

    public ListScreen(Component title, Set<T> values, int xSize, int ySize, ScrollbarInfo scrollbarInfo, RenderAreaInfo renderAreaInfo) {
        this(title, values.stream().toList(), xSize, ySize, scrollbarInfo, renderAreaInfo);
    }

    public ListScreen(Component title, List<T> values, int xSize, int ySize, ScrollbarInfo scrollbarInfo, RenderAreaInfo renderAreaInfo) {
        super(title, xSize, ySize);
        this.values = values;
        this.scrollbarInfo = scrollbarInfo;
        this.renderAreaInfo = renderAreaInfo;
    }

    protected void init() {
        this.widgets.clear();
        this.scrollbar = new ScrollbarWidget(this, this.scrollbarInfo.x, this.scrollbarInfo.y, 12, this.scrollbarInfo.height);
        this.renderArea = (RenderArea)this.addWidget((GuiEventListener)new RenderArea(this.x(this.renderAreaInfo.x), this.y(this.renderAreaInfo.y), this.renderAreaInfo.width, this.entriesPerPage() * 14, this.xSize - 20, this.values.size() * 14, 14){

            @Override
            public void renderWidgetContent(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                ListScreen.this.isCapturingTooltips = true;
                guiGraphics.pose().pushPose();
                super.renderWidgetContent((GuiGraphics)new TooltipCapturingGuiGraphics(guiGraphics), mouseX, mouseY, partialTick);
                guiGraphics.pose().popPose();
                ListScreen.this.isCapturingTooltips = false;
                ListScreen.this.capturedTooltips.forEach(pair -> {
                    int x = mouseX - this.getInitX();
                    int y = mouseY - this.getInitY();
                    if (x > 0 && x < this.getRenderWidth() && y > 0 && y < this.getRenderHeight()) {
                        guiGraphics.pose().pushPose();
                        guiGraphics.pose().setIdentity();
                        guiGraphics.pose().mulPose((Matrix4f)pair.getLeft());
                        ((Consumer)pair.getRight()).accept(guiGraphics);
                        guiGraphics.pose().popPose();
                    }
                });
                ListScreen.this.capturedTooltips.clear();
            }
        });
        this.fillWidgets();
        this.scrollbar.addListener(this.renderArea);
        this.updateScrollbar();
    }

    protected CheckboxTextWidget addCheckboxWidget(CheckboxTextWidget widget) {
        this.widgets.add(widget);
        return widget;
    }

    protected abstract int entriesPerPage();

    protected abstract void fillWidgets();

    public boolean allSelected() {
        for (CheckboxTextWidget widget : this.widgets) {
            if (widget.selected()) continue;
            return false;
        }
        return true;
    }

    public void selectAll(boolean select) {
        for (CheckboxTextWidget widget : this.widgets) {
            widget.checkbox.selected = select;
        }
    }

    public Set<T> getSelectedValues() {
        HashSet ids = new HashSet();
        for (CheckboxTextWidget widget : this.widgets) {
            if (!widget.selected()) continue;
            ids.add(widget.getValue());
        }
        return ids;
    }

    @Override
    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
        this.scrollbar.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderArea.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.scrollbar.mouseClicked(mouseX, mouseY, button) || super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.scrollbar.mouseMoved(mouseX, mouseY);
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.scrollbar.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.scrollbar.mouseScrolled(mouseX, mouseY, scrollX, scrollY) || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.values.size() > this.entriesPerPage());
        this.scrollbar.setMaxOffset(this.values.size() - this.entriesPerPage());
    }

    public List<T> getValues() {
        return ImmutableList.copyOf(this.values);
    }

    private void captureTooltip(PoseStack.Pose pose, Consumer<GuiGraphics> action) {
        this.capturedTooltips.add((Pair<Matrix4f, Consumer<GuiGraphics>>)Pair.of((Object)pose.pose(), action));
    }

    public record ScrollbarInfo(int x, int y, int height) {
    }

    public record RenderAreaInfo(int x, int y, int width, int height) {
        public RenderAreaInfo(int x, int y, int width) {
            this(x, y, width, 0);
        }
    }

    protected class CheckboxTextWidget
    extends Panel {
        protected final T value;
        protected final Checkbox checkbox;

        public CheckboxTextWidget(ListScreen this$0, T value, Screen screen, int x, int y, int width, int height, Component text) {
            this(this$0, value, screen, x, y, width, height, Lists.newArrayList(), text);
        }

        public CheckboxTextWidget(ListScreen this$0, T value, Screen screen, int x, int y, int width, int height, List<Component> tooltip, Component text) {
            super(x, y, width, height);
            this.value = value;
            this.checkbox = new SizeableCheckbox(0, 0, height, false);
            this.addRenderableWidget((GuiEventListener)this.checkbox);
            TextWidget textWidget = new TextWidget(height + 5, 0, Math.min(width, TextHelper.stringLength((FormattedText)text)), height, text, tooltip);
            this.addRenderableWidget((GuiEventListener)textWidget);
        }

        public T getValue() {
            return this.value;
        }

        public boolean selected() {
            return this.checkbox.selected();
        }
    }

    private class TooltipCapturingGuiGraphics
    extends FilterGuiGraphics {
        public TooltipCapturingGuiGraphics(GuiGraphics parent) {
            super(parent);
        }

        public void renderTooltip(@Nonnull Font font, @Nonnull ItemStack stack, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.pose().last(), guiGraphics -> guiGraphics.renderTooltip(font, stack, x, y));
            } else {
                super.renderTooltip(font, stack, x, y);
            }
        }

        public void renderTooltip(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, @Nonnull ItemStack stack, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.pose().last(), guiGraphics -> guiGraphics.renderTooltip(font, text, component, stack, x, y));
            } else {
                super.renderTooltip(font, text, component, stack, x, y);
            }
        }

        public void renderTooltip(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.pose().last(), guiGraphics -> guiGraphics.renderTooltip(font, text, component, x, y));
            } else {
                super.renderTooltip(font, text, component, x, y);
            }
        }

        public void renderTooltip(@Nonnull Font font, @Nonnull Component text, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.pose().last(), guiGraphics -> guiGraphics.renderTooltip(font, text, x, y));
            } else {
                super.renderTooltip(font, text, x, y);
            }
        }

        public void renderComponentTooltip(@Nonnull Font font, @Nonnull List<Component> text, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.pose().last(), guiGraphics -> guiGraphics.renderComponentTooltip(font, text, x, y));
            } else {
                super.renderComponentTooltip(font, text, x, y);
            }
        }

        public void renderComponentTooltip(@Nonnull Font font, @Nonnull List<? extends FormattedText> text, int x, int y, @Nonnull ItemStack stack) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.pose().last(), guiGraphics -> guiGraphics.renderComponentTooltip(font, text, x, y, stack));
            } else {
                super.renderComponentTooltip(font, text, x, y, stack);
            }
        }

        public void renderTooltip(@Nonnull Font font, @Nonnull List<? extends FormattedCharSequence> text, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.pose().last(), guiGraphics -> guiGraphics.renderTooltip(font, text, x, y));
            } else {
                super.renderTooltip(font, text, x, y);
            }
        }

        public void renderTooltip(@Nonnull Font font, @Nonnull List<FormattedCharSequence> text, @Nonnull ClientTooltipPositioner positioner, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.pose().last(), guiGraphics -> guiGraphics.renderTooltip(font, text, positioner, x, y));
            } else {
                super.renderTooltip(font, text, positioner, x, y);
            }
        }
    }
}

