/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.edit;

import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class EditSpawnsScreen
extends ListScreen<BlockPos> {
    private final BaseScreen prev;
    private Button removeButton;
    private Checkbox selectAll;
    private int selectedAmount = 0;

    public EditSpawnsScreen(Team team, BaseScreen prev) {
        super((Component)ComponentBuilder.text("remove_spawns", new Object[0]), team.getPossibleSpawns().stream().map(TemplatesConfig.Spawn::pos).toList(), 200, 230, new ListScreen.ScrollbarInfo(180, 10, 210), new ListScreen.RenderAreaInfo(10, 50, 160));
        this.prev = prev;
    }

    @Override
    protected void init() {
        this.removeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentBuilder.text("remove", new Object[0]), button -> {
            List positions = this.getSelectedValues().stream().toList();
            Minecraft.getInstance().pushGuiLayer((Screen)new YouSureScreen((BaseScreen)this, (Component)ComponentBuilder.text("you_sure_remove_spawns", positions.size()), () -> {
                SkyGUIs.getNetwork().handleRemoveSpawns(new HashSet<BlockPos>(positions));
                Minecraft.getInstance().popGuiLayer();
            }));
        }).bounds(this.x(10), this.y(200), 60, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)PREV_SCREEN_COMPONENT, button -> Minecraft.getInstance().setScreen((Screen)this.prev)).bounds(this.x(77), this.y(200), 95, 20).build());
        this.selectAll = (Checkbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(9), this.y(32), 14, false, this.allSelected() ? UNSELECT_ALL : SELECT_ALL, (checkbox, value) -> {
            this.selectAll(value);
            this.updateButtons();
        }));
        super.init();
        this.updateButtons();
    }

    @Override
    protected int entriesPerPage() {
        return 10;
    }

    @Override
    protected void fillWidgets() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.addCheckboxWidget(this.renderArea.addRenderableWidget2(new SpawnWidget(this, (BlockPos)this.values.get(i), this, 0, 14 * i, 100, 12)));
        }
    }

    @Override
    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, (Component)ComponentBuilder.text("selected_amount", this.selectedAmount), this.x(28), this.y(35), Color.DARK_GRAY.getRGB(), false);
    }

    public void updateButtons() {
        List selectedIds = this.getSelectedValues().stream().sorted().toList();
        this.removeButton.active = this.getSelectedValues().size() < this.getValues().size();
        this.selectAll.selected = this.allSelected();
        this.selectedAmount = selectedIds.size();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean ret = super.mouseClicked(mouseX, mouseY, button);
        this.updateButtons();
        return ret;
    }

    protected class SpawnWidget
    extends ListScreen.CheckboxTextWidget {
        public SpawnWidget(EditSpawnsScreen this$0, BlockPos value, Screen screen, int x, int y, int width, int height) {
            super(this$0, value, screen, x, y, width, height, (Component)Component.literal((String)(value.getX() + " " + value.getY() + " " + value.getZ())));
        }
    }
}

