/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import com.google.common.collect.Lists;
import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.CreateTeamScreen;
import de.melanx.skyguis.client.screen.edit.HandleInvitationsScreen;
import de.melanx.skyguis.client.screen.info.TeamEditScreen;
import de.melanx.skyguis.client.screen.info.TeamInfoScreen;
import de.melanx.skyguis.client.widget.ClickableText;
import de.melanx.skyguis.client.widget.ScrollbarWidget;
import de.melanx.skyguis.config.ClientConfig;
import de.melanx.skyguis.tooltip.SmallTextTooltip;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.Math2;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.moddingx.libx.render.RenderHelper;

public class AllTeamsScreen
extends BaseScreen {
    public static final int ENTRIES = 13;
    private static final Component TEAMS_COMPONENT = ComponentBuilder.text("teams", new Object[0]).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final Component MEMBERS_COMPONENT = ComponentBuilder.text("members", new Object[0]).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final Component YOUR_TEAM = ComponentBuilder.text("your_team", new Object[0]);
    private static final Component CLICK_ME = ComponentBuilder.text("click_me", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
    private static final Component FILTER = ComponentBuilder.text("filter", new Object[0]);
    private static final Component VISIT_FILTER = ComponentBuilder.text("filter.visits", new Object[0]);
    private static final Component JOIN_REQUEST_FILTER = ComponentBuilder.text("filter.join_requests", new Object[0]);
    private static final Component EMPTY_TEAMS_FILTER = ComponentBuilder.text("filter.empty_teams", new Object[0]);
    private static final int LONGEST_FILTER_TITLE_LENGTH = Math.max(TextHelper.stringLength((FormattedText)VISIT_FILTER), Math.max(TextHelper.stringLength((FormattedText)JOIN_REQUEST_FILTER), TextHelper.stringLength((FormattedText)EMPTY_TEAMS_FILTER)));
    private static final ResourceLocation[] NOTIFICATION_ICONS = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"notification/1"), ResourceLocation.withDefaultNamespace((String)"notification/2"), ResourceLocation.withDefaultNamespace((String)"notification/3"), ResourceLocation.withDefaultNamespace((String)"notification/4"), ResourceLocation.withDefaultNamespace((String)"notification/5"), ResourceLocation.withDefaultNamespace((String)"notification/more")};
    private final SkyblockSavedData data;
    private final List<Team> teams = new ArrayList<Team>();
    private final Team playerTeam;
    private final boolean hasInvites;
    private ScrollbarWidget scrollbar;
    private Button yourTeamButton;
    private Button teleportHome;
    private Button teleportSpawn;
    private FilteredCheckbox visitAllowedTeams;
    private FilteredCheckbox joinRequestsAllowedTeams;
    private FilteredCheckbox hideEmptyTeams;
    private CollapsableText filterText;
    private CycleButton<SortOrder> sortOrderButton;
    private SizeableCheckbox invertSort;

    public AllTeamsScreen() {
        super(TEAMS_COMPONENT, 200, 230);
        this.data = SkyblockSavedData.get((Level)Minecraft.getInstance().level);
        this.playerTeam = this.data.getTeamFromPlayer((Player)Minecraft.getInstance().player);
        this.hasInvites = this.data.hasInvites((Player)Minecraft.getInstance().player);
    }

    public static void open() {
        SkyGUIs.getNetwork().updateSkyblockSavedData();
        Minecraft.getInstance().setScreen((Screen)new AllTeamsScreen());
    }

    protected void init() {
        Button.OnPress onSpawnButtonPress = button -> SkyGUIs.getNetwork().teleportToSpawn();
        if (this.playerTeam == null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentBuilder.title("create_team", new Object[0]), button -> CreateTeamScreen.open()).tooltip(Tooltip.create((Component)BaseScreen.OPEN_NEW_SCREEN)).bounds(this.x(10), this.y(199), this.hasInvites ? 78 : 160, 20).build());
            if (this.hasInvites) {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentBuilder.button("review_invites", new Object[0]), button -> HandleInvitationsScreen.open()).tooltip(Tooltip.create((Component)BaseScreen.OPEN_NEW_SCREEN)).bounds(this.x(93), this.y(199), 77, 20).build());
            }
            this.yourTeamButton = null;
            this.teleportSpawn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentBuilder.button("teleport_spawn_long", new Object[0]), (Button.OnPress)onSpawnButtonPress).bounds(this.x(10), this.y(this.ySize + 5), this.xSize - 20, 20).build());
        } else {
            MutableComponent component = Component.literal((String)TextHelper.shorten(this.font, this.playerTeam.getName(), this.xSize - TextHelper.stringLength((FormattedText)YOUR_TEAM) - 40));
            this.yourTeamButton = (Button)this.addRenderableWidget((GuiEventListener)new ClickableText(this.x(15) + TextHelper.stringLength((FormattedText)YOUR_TEAM), this.y(207), TextHelper.DARK_GREEN.getRGB(), (Component)component, button -> this.minecraft.setScreen((Screen)new TeamEditScreen(this.playerTeam, this))));
            this.teleportHome = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentBuilder.button("teleport_home", new Object[0]), button -> SkyGUIs.getNetwork().teleportToTeam(this.playerTeam, SkyMeta.TeleportType.HOME)).bounds(this.x(10), this.y(this.ySize + 5), this.xSize / 2 - 15, 20).build());
            this.teleportHome.active = PermissionManager.INSTANCE.hasPermission((Player)Minecraft.getInstance().player, PermissionManager.Permission.TELEPORT_HOME);
            this.teleportSpawn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ComponentBuilder.button("teleport_spawn", new Object[0]), (Button.OnPress)onSpawnButtonPress).bounds(this.x(5 + this.xSize / 2), this.y(this.ySize + 5), this.xSize / 2 - 15, 20).build());
        }
        this.teleportSpawn.active = PermissionManager.INSTANCE.hasPermission((Player)Minecraft.getInstance().player, PermissionManager.Permission.TELEPORT_TO_SPAWN);
        int filterSectionStart = this.xSize + 7;
        this.filterText = (CollapsableText)this.addRenderableWidget((GuiEventListener)new CollapsableText(false, this.x(filterSectionStart), this.y(2), 18, FILTER));
        this.visitAllowedTeams = (FilteredCheckbox)this.addRenderableWidget((GuiEventListener)new FilteredCheckbox(this.x(filterSectionStart), this.y(22), 10, this.visitAllowedTeams != null && this.visitAllowedTeams.selected));
        this.joinRequestsAllowedTeams = (FilteredCheckbox)this.addRenderableWidget((GuiEventListener)new FilteredCheckbox(this.x(filterSectionStart), this.y(36), 10, this.joinRequestsAllowedTeams != null && this.joinRequestsAllowedTeams.selected));
        this.hideEmptyTeams = (FilteredCheckbox)this.addRenderableWidget((GuiEventListener)new FilteredCheckbox(this.x(filterSectionStart), this.y(50), 10, this.hideEmptyTeams == null || this.hideEmptyTeams.selected));
        this.sortOrderButton = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(SortOrder::getName).withValues((Object[])SortOrder.values()).withInitialValue((Object)SortOrder.ALPHABETICAL).create(this.x(filterSectionStart + 15), this.y(65), 120, 20, (Component)ComponentBuilder.button("filter.sort_by", new Object[0]), (button, value) -> this.updateTeams()));
        this.invertSort = (SizeableCheckbox)this.addRenderableWidget((GuiEventListener)new FilteredCheckbox(this.x(filterSectionStart), this.y(70), 10, false, (Component)ComponentBuilder.button("filter.invert", new Object[0])));
        this.scrollbar = new ScrollbarWidget(this, this.xSize - 20, 33, 12, this.ySize - 45);
        this.updateTeams();
        this.updateScrollbar();
    }

    @Override
    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderHelper.renderGuiBackground((GuiGraphics)guiGraphics, (int)this.x(this.xSize), (int)this.y(0), (int)((this.filterText.isOpen() ? LONGEST_FILTER_TITLE_LENGTH + 15 : TextHelper.stringLength((FormattedText)this.filterText.getMessage())) + 14), (int)(this.filterText.isOpen() ? 95 : 22), (ResourceLocation)BaseScreen.GENERIC, (int)128, (int)64, (int)4, (int)125, (int)4, (int)60);
        this.scrollbar.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, (Component)Component.empty().append(TEAMS_COMPONENT).append(" (" + this.teams.size() + "/" + (this.data.getSpawnOption().isPresent() ? this.data.getTeams().size() - 1 : this.data.getTeams().size()) + ")"), this.x(10), this.y(13), Color.DARK_GRAY.getRGB(), false);
        int memberLength = this.font.width(MEMBERS_COMPONENT.getVisualOrderText());
        guiGraphics.drawString(this.font, MEMBERS_COMPONENT, this.x(179) - memberLength, this.y(13), Color.DARK_GRAY.getRGB(), false);
        if (this.filterText.isOpen()) {
            int filterSectionStart = this.x(this.xSize + 20);
            guiGraphics.drawString(this.font, VISIT_FILTER, filterSectionStart, this.y(23), Color.DARK_GRAY.getRGB(), false);
            guiGraphics.drawString(this.font, JOIN_REQUEST_FILTER, filterSectionStart, this.y(37), Color.DARK_GRAY.getRGB(), false);
            guiGraphics.drawString(this.font, EMPTY_TEAMS_FILTER, filterSectionStart, this.y(51), Color.DARK_GRAY.getRGB(), false);
        }
        if (this.playerTeam != null) {
            guiGraphics.hLine(this.x(8), this.x(this.xSize - 26), this.y(197), Color.GRAY.getRGB());
            guiGraphics.drawString(this.font, YOUR_TEAM, this.x(10), this.y(207), Color.DARK_GRAY.getRGB(), false);
            if (this.yourTeamButton.isHovered) {
                this.renderTeamTooltip(guiGraphics, mouseX, mouseY, this.playerTeam);
            }
        }
        int j = 0;
        for (int i = this.scrollbar.getOffset(); i < this.teams.size() && j < 13; ++j, ++i) {
            Team team = this.teams.get(i);
            String name = team.getName();
            String s = TextHelper.shorten(this.font, name, 175 - memberLength);
            String playerSizeComponent = String.valueOf(team.getPlayers().size());
            MutableComponent teamNameComponent = Component.literal((String)s);
            float x = this.x(179.0f - (float)memberLength / 2.0f - (float)this.font.width(playerSizeComponent) / 2.0f);
            int y = this.y(37 + j * 12);
            guiGraphics.drawString(this.font, (Component)teamNameComponent, this.x(10), y, team.isEmpty() ? TextHelper.LIGHT_RED.getRGB() : TextHelper.DARK_GREEN.getRGB(), false);
            guiGraphics.drawString(this.font, playerSizeComponent, x, (float)y, Color.DARK_GRAY.getRGB(), false);
            boolean inBounds = Math2.isInBounds(this.x(10), y, this.font.width(teamNameComponent.getVisualOrderText()), 11.0, mouseX, mouseY);
            if (!inBounds) continue;
            this.renderTeamTooltip(guiGraphics, mouseX, mouseY, team);
        }
    }

    @Override
    public void renderForeground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.hasInvites) {
            return;
        }
        int inviteCount = this.data.getInvites((Player)this.minecraft.player).size();
        guiGraphics.blitSprite(NOTIFICATION_ICONS[Math.min(inviteCount, 6) - 1], this.x(165), this.y(196), 8, 8);
    }

    private void renderTeamTooltip(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, @Nonnull Team team) {
        ArrayList textLines = Lists.newArrayList((Object[])new Component[]{Component.literal((String)team.getName()), CLICK_ME});
        ArrayList smallTextLines = Lists.newArrayList();
        if (this.minecraft.options.advancedItemTooltips) {
            smallTextLines.add(ComponentBuilder.text("team_id", new Object[0]).append(": " + team.getId().toString()));
        }
        smallTextLines.add(ComponentBuilder.text("members", new Object[0]).append(": " + team.getPlayers().size()));
        smallTextLines.add(ComponentBuilder.text("created_at", new Object[0]).append(": " + ClientConfig.date.format(new Date(team.getCreatedAt()))));
        smallTextLines.add(ComponentBuilder.text("last_changed", new Object[0]).append(": " + ClientConfig.date.format(new Date(team.getLastChanged()))));
        guiGraphics.renderTooltip(this.minecraft.font, (List)textLines, Optional.of(new SmallTextTooltip(smallTextLines, Color.GRAY)), mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrollbar.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        int entries = Math.min(13, this.teams.size());
        if (Math2.isInBounds(10.0, 37.0, 175.0, entries * 12, mouseX -= (double)this.relX, mouseY -= (double)this.relY)) {
            int index = (int)((mouseY - 37.0) / 12.0) + this.scrollbar.getOffset();
            Team team = this.teams.get(index);
            if (Math2.isInBounds(10.0, 37.0, this.font.width(team.getName()), entries * 12, mouseX, mouseY)) {
                if (team.hasPlayer((Player)this.minecraft.player)) {
                    this.minecraft.setScreen((Screen)new TeamEditScreen(team, this));
                } else {
                    this.minecraft.setScreen((Screen)new TeamInfoScreen(team, this));
                }
            }
            return true;
        }
        return super.mouseClicked(mouseX + (double)this.relX, mouseY + (double)this.relY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.scrollbar.mouseMoved(mouseX, mouseY);
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.scrollbar.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.scrollbar.mouseScrolled(mouseX, mouseY, scrollX, scrollY) || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.teams.size() > 13);
        this.scrollbar.setMaxOffset(this.teams.size() - 13);
    }

    public void tick() {
        super.tick();
        if (this.visitAllowedTeams != null && this.joinRequestsAllowedTeams != null && this.hideEmptyTeams != null && this.sortOrderButton != null && this.invertSort != null) {
            boolean showFilter;
            this.visitAllowedTeams.visible = showFilter = this.filterText.isOpen();
            this.joinRequestsAllowedTeams.visible = showFilter;
            this.hideEmptyTeams.visible = showFilter;
            this.sortOrderButton.visible = showFilter;
            this.invertSort.visible = showFilter;
        }
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        LocalPlayer player = Minecraft.getInstance().player;
        if (PermissionManager.INSTANCE.mayBypassLimitation((Player)player)) {
            return;
        }
        SkyMeta metaInfo = this.data.getOrCreateMetaInfo((Player)player);
        if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_HOME) && this.playerTeam != null) {
            if (metaInfo.canTeleport(SkyMeta.TeleportType.HOME, level.getGameTime())) {
                this.teleportHome.setTooltip(null);
                this.teleportHome.active = true;
            } else {
                this.teleportHome.setTooltip(Tooltip.create((Component)((Component)SkyComponents.ERROR_COOLDOWN.apply(RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.Cooldowns.homeCooldown - (level.getGameTime() - metaInfo.getLastTeleport(SkyMeta.TeleportType.HOME))))))));
                this.teleportHome.active = false;
            }
        }
        if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_SPAWN)) {
            if (metaInfo.canTeleport(SkyMeta.TeleportType.SPAWN, level.getGameTime())) {
                this.teleportSpawn.setTooltip(null);
                this.teleportSpawn.active = true;
            } else {
                this.teleportSpawn.setTooltip(Tooltip.create((Component)((Component)SkyComponents.ERROR_COOLDOWN.apply(RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.Cooldowns.spawnCooldown - (level.getGameTime() - metaInfo.getLastTeleport(SkyMeta.TeleportType.SPAWN))))))));
                this.teleportSpawn.active = false;
            }
        }
    }

    private void updateTeams() {
        this.teams.clear();
        Predicate<Team> visitsAllowed = team -> {
            if (this.visitAllowedTeams == null) {
                return true;
            }
            return !this.visitAllowedTeams.selected || team.allowsVisits();
        };
        Predicate<Team> joinRequestsAllowed = team -> {
            if (this.joinRequestsAllowedTeams == null) {
                return true;
            }
            return !this.joinRequestsAllowedTeams.selected || team.allowsJoinRequests();
        };
        Predicate<Team> hideEmptyTeams = team -> {
            if (this.hideEmptyTeams == null) {
                return true;
            }
            return !this.hideEmptyTeams.selected || !team.isEmpty();
        };
        this.teams.addAll(this.data.getTeams().stream().filter(team -> !team.getName().isEmpty()).filter(team -> !team.isSpawn()).filter(visitsAllowed).filter(joinRequestsAllowed).filter(hideEmptyTeams).sorted(((SortOrder)((Object)this.sortOrderButton.getValue())).comparator(this.invertSort.selected)).toList());
        this.updateScrollbar();
        this.filterText.setAppendix("(" + this.countEnabledFilters() + ")");
    }

    public int countEnabledFilters() {
        int i = 0;
        if (this.visitAllowedTeams != null && this.visitAllowedTeams.selected) {
            ++i;
        }
        if (this.joinRequestsAllowedTeams != null && this.joinRequestsAllowedTeams.selected) {
            ++i;
        }
        if (this.hideEmptyTeams != null && this.hideEmptyTeams.selected) {
            ++i;
        }
        return i;
    }

    private static class CollapsableText
    extends AbstractWidget {
        private boolean enabled;
        private Component appendix = Component.empty();

        public CollapsableText(boolean open, int x, int y, int height, Component message) {
            super(x, y, 0, height, message);
            this.enabled = open;
            this.width = TextHelper.stringLength((FormattedText)this.getMessage());
        }

        public void onClick(double mouseX, double mouseY) {
            this.enabled = !this.enabled;
        }

        protected void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            RenderHelper.resetColor();
            guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX(), this.getY() + (this.height - 8) / 2, Color.DARK_GRAY.getRGB(), false);
        }

        protected void updateWidgetNarration(@Nonnull NarrationElementOutput output) {
            this.defaultButtonNarrationText(output);
        }

        @Nonnull
        public Component getMessage() {
            return (this.enabled ? Component.literal((String)"\u2b07  ") : Component.literal((String)"\u27a1 ")).append(super.getMessage()).append(this.appendix);
        }

        public boolean isOpen() {
            return this.enabled;
        }

        public void setAppendix(String appendix) {
            this.appendix = Component.literal((String)(" " + appendix));
            this.width = TextHelper.stringLength((FormattedText)this.getMessage());
        }
    }

    private class FilteredCheckbox
    extends SizeableCheckbox {
        public FilteredCheckbox(int x, int y, int size, boolean selected) {
            this(x, y, size, selected, (Component)Component.empty(), (checkbox, value) -> {});
        }

        public FilteredCheckbox(int x, int y, int size, boolean selected, Checkbox.OnValueChange onValueChange) {
            this(x, y, size, selected, (Component)Component.empty(), onValueChange);
        }

        public FilteredCheckbox(int x, int y, int size, boolean selected, Component component) {
            this(x, y, size, selected, component, (checkbox, value) -> {});
        }

        public FilteredCheckbox(int x, int y, int size, boolean selected, Component component, Checkbox.OnValueChange onValueChange) {
            super(x, y, size, selected, component, onValueChange);
        }

        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.visible) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public void onPress() {
            super.onPress();
            AllTeamsScreen.this.updateTeams();
        }
    }

    public static enum SortOrder {
        ALPHABETICAL((Component)ComponentBuilder.button("filter.alphabetical", new Object[0]), Comparator.comparing(team -> team.getName().toLowerCase(Locale.ROOT))),
        CREATION_DATE((Component)ComponentBuilder.button("filter.creation_date", new Object[0]), Comparator.comparing(Team::getCreatedAt)),
        LAST_MODIFIED((Component)ComponentBuilder.button("filter.last_modified", new Object[0]), Comparator.comparing(Team::getLastChanged)),
        MEMBER_COUNT((Component)ComponentBuilder.button("filter.member_count", new Object[0]), Comparator.comparing(team -> team.getPlayers().size()));

        private final Component name;
        private final Comparator<Team> comparator;

        private SortOrder(Component name, Comparator<Team> comparator) {
            this.name = name;
            this.comparator = comparator;
        }

        public Component getName() {
            return this.name;
        }

        public Comparator<Team> comparator() {
            return this.comparator(false);
        }

        public Comparator<Team> comparator(boolean invert) {
            return invert ? this.comparator.reversed() : this.comparator;
        }
    }
}

