/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network;

import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.network.handler.AnswerInvitation;
import de.melanx.skyguis.network.handler.CreateTeamScreenClick;
import de.melanx.skyguis.network.handler.EditSpawns;
import de.melanx.skyguis.network.handler.InvitePlayers;
import de.melanx.skyguis.network.handler.LeaveTeam;
import de.melanx.skyguis.network.handler.OpenGui;
import de.melanx.skyguis.network.handler.RemoveSpawns;
import de.melanx.skyguis.network.handler.RequestTemplateFromServer;
import de.melanx.skyguis.network.handler.RequestToJoinTeam;
import de.melanx.skyguis.network.handler.SendLoadingResult;
import de.melanx.skyguis.network.handler.SendTemplateToClient;
import de.melanx.skyguis.network.handler.TeleportToTeam;
import de.melanx.skyguis.network.handler.ToggleStateButtonClick;
import de.melanx.skyguis.network.handler.UpdateSkyblockSavedData;
import de.melanx.skyguis.network.handler.UpdateTeam;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.ToggleButtons;
import java.util.Set;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.NetworkX;

@ParametersAreNonnullByDefault
public class EasyNetwork
extends NetworkX {
    public EasyNetwork(ModX mod) {
        super(mod);
        this.register(new AnswerInvitation());
        this.register(new CreateTeamScreenClick());
        this.register(new EditSpawns());
        this.register(new InvitePlayers());
        this.register(new LeaveTeam());
        this.register(new RemoveSpawns());
        this.register(new RequestTemplateFromServer());
        this.register(new RequestToJoinTeam());
        this.register(new TeleportToTeam());
        this.register(new ToggleStateButtonClick());
        this.register(new UpdateSkyblockSavedData());
        this.register(new UpdateTeam());
        this.register(new OpenGui());
        this.register(new SendLoadingResult());
        this.register(new SendTemplateToClient());
    }

    protected String getVersion() {
        return "10";
    }

    public void handleCreateTeam(String name, String shape, boolean allowVisits, boolean allowJoinRequests) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CreateTeamScreenClick.Message(name, shape, allowVisits, allowJoinRequests), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void handleKickPlayers(String teamName, Set<UUID> players) {
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateTeam.Message(teamName, players), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void handleInvitePlayers(String teamName, Set<UUID> players) {
        PacketDistributor.sendToServer((CustomPacketPayload)new InvitePlayers.Message(teamName, players), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void handleInvitationAnswer(String teamName, AnswerInvitation.Type type) {
        PacketDistributor.sendToServer((CustomPacketPayload)new AnswerInvitation.Message(teamName, type), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void handleEditSpawns(EditSpawns.Type type, BlockPos pos, WorldUtil.SpawnDirection direction) {
        PacketDistributor.sendToServer((CustomPacketPayload)new EditSpawns.Message(type, pos, direction), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void handleRemoveSpawns(Set<BlockPos> positions) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RemoveSpawns.Message(positions), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void leaveTeam(Player player) {
        this.leaveTeam(player.getGameProfile().getId());
    }

    public void leaveTeam(UUID player) {
        PacketDistributor.sendToServer((CustomPacketPayload)new LeaveTeam.Message(player), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void handleLoadingResult(IPayloadContext ctx, LoadingResult.Status result, Component reason) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)ctx.player()), (CustomPacketPayload)new SendLoadingResult.Message(result, reason), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void requestTemplateFromServer(String name) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestTemplateFromServer.Message(name), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendTemplateToClient(IPayloadContext ctx, String name) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)ctx.player()), (CustomPacketPayload)new SendTemplateToClient.Message(name, TemplateLoader.getConfiguredTemplate((String)name)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void teleportToSpawn() {
        this.teleportToTeam(SkyblockSavedData.SPAWN_ID, SkyMeta.TeleportType.SPAWN);
    }

    public void teleportToTeam(Team team, SkyMeta.TeleportType teleportType) {
        this.teleportToTeam(team.getId(), teleportType);
    }

    public void teleportToTeam(UUID team, SkyMeta.TeleportType teleportType) {
        PacketDistributor.sendToServer((CustomPacketPayload)new TeleportToTeam.Message(team, teleportType), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void requestToJoinTeam(Team team) {
        this.requestToJoinTeam(team.getId());
    }

    public void requestToJoinTeam(UUID team) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestToJoinTeam.Message(team), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void toggleState(Team team, ToggleButtons.Type type) {
        this.toggleState(team.getId(), type);
    }

    public void toggleState(UUID team, ToggleButtons.Type type) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ToggleStateButtonClick.Message(team, type), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void updateSkyblockSavedData() {
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSkyblockSavedData.Message(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

