/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class CreateTeamScreenClick
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("create_team_screen_click"));

    public CreateTeamScreenClick() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        EasyNetwork network = SkyGUIs.getNetwork();
        if (SkyblockHooks.onCreateTeam((String)msg.name)) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_CREATE_TEAM);
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        ConfiguredTemplate template = TemplateLoader.getConfiguredTemplate((String)msg.shape);
        if (template == null) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("shape_does_not_exist", new Object[0]).withStyle(ChatFormatting.RED));
            return;
        }
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (data.hasPlayerTeam((Player)player)) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_USER_HAS_TEAM);
            return;
        }
        Team team = data.createTeam(msg.name, template);
        if (team == null) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_TEAM_ALREADY_EXIST.apply(msg.name));
            return;
        }
        data.addPlayerToTeam(team, (Player)player);
        WorldUtil.teleportToIsland((ServerPlayer)player, (Team)team);
        team.setAllowVisit(msg.allowVisits);
        team.setAllowJoinRequest(msg.allowJoinRequests);
        network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)((MutableComponent)SkyComponents.SUCCESS_CREATE_TEAM.apply(team.getName())).withStyle(ChatFormatting.GREEN));
    }

    public record Message(String name, String shape, boolean allowVisits, boolean allowJoinRequests) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeUtf(msg.name);
            buffer.writeUtf(msg.shape);
            buffer.writeBoolean(msg.allowVisits);
            buffer.writeBoolean(msg.allowJoinRequests);
        }, buffer -> new Message(buffer.readUtf(), buffer.readUtf(), buffer.readBoolean(), buffer.readBoolean()));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

