/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class LeaveTeam
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("leave_team"));

    public LeaveTeam() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        EasyNetwork network = SkyGUIs.getNetwork();
        SkyblockSavedData data = SkyblockSavedData.get((Level)player.level());
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
            return;
        }
        switch (SkyblockHooks.onLeave((ServerPlayer)player, (Team)team)) {
            case DENY: {
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_LEAVE_TEAM);
                return;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_LEAVE)) break;
                network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_MANAGE_TEAMS);
                return;
            }
        }
        if (InventoryConfig.dropItems) {
            RandomUtility.dropInventories((Player)player);
        }
        data.removePlayerFromTeam(msg.player());
        network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)SkyComponents.SUCCESS_LEFT_TEAM);
        RandomUtility.deleteTeamIfEmpty((SkyblockSavedData)data, (Team)team);
        WorldUtil.teleportToIsland((ServerPlayer)player, (Team)data.getSpawn());
    }

    public record Message(UUID player) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> buffer.writeUUID(msg.player), buffer -> new Message(buffer.readUUID()));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

