/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.tooltip;

import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyguis.tooltip.SmallTextTooltip;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;

public class ClientSmallTextTooltip
implements ClientTooltipComponent {
    private final List<Component> tooltips;
    private final int color;

    public ClientSmallTextTooltip(SmallTextTooltip tooltip) {
        this.tooltips = tooltip.getTooltips();
        this.color = tooltip.getColor();
    }

    public void renderText(@Nonnull Font font, int x, int y, @Nonnull Matrix4f matrix, @Nonnull MultiBufferSource.BufferSource bufferSource) {
        float textScale = Minecraft.getInstance().isEnforceUnicode() ? 1.0f : 0.7f;
        int i = 0;
        for (Component tooltip : this.tooltips) {
            PoseStack poseStack = new PoseStack();
            poseStack.translate(0.0f, 0.0f, 400.0f);
            poseStack.scale(textScale, textScale, 1.0f);
            font.drawInBatch(tooltip, (float)x / textScale, (float)(y - (Minecraft.getInstance().isEnforceUnicode() ? 2 : 0) + i * 8) / textScale, this.color, true, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            ++i;
        }
    }

    public int getHeight() {
        return this.tooltips.size() * 8;
    }

    public int getWidth(@Nonnull Font font) {
        int w = -1;
        float textScale = Minecraft.getInstance().isEnforceUnicode() ? 1.0f : 0.7f;
        for (Component tooltip : this.tooltips) {
            int width = (int)((float)font.width((FormattedText)tooltip) * textScale);
            if (width <= w) continue;
            w = width;
        }
        return w;
    }
}

