/*
 * Decompiled with CFR 0.152.
 */
package com.zephbyte.scaleddragonfight;

import com.zephbyte.scaleddragonfight.ModConstantsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\nR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\nR\u0014\u0010\u0012\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\nR\"\u0010\u0017\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\n\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\"\u0010\u001f\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\n\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\"\u0010\"\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u000f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010'\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010\u000f\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\"\u0010*\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010\n\u001a\u0004\b+\u0010\u0019\"\u0004\b,\u0010\u001bR\"\u0010-\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010\n\u001a\u0004\b.\u0010\u0019\"\u0004\b/\u0010\u001bR\"\u00100\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010\u0015\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\"\u00105\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u0010\n\u001a\u0004\b6\u0010\u0019\"\u0004\b7\u0010\u001bR\u0014\u00109\u001a\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lcom/zephbyte/scaleddragonfight/ConfigManager;", "", "<init>", "()V", "", "loadConfig", "saveConfig", "resetToDefaultsAndSave", "", "DEFAULT_ENABLE_MOD", "Z", "DEFAULT_SCALE_WITH_ONE_PLAYER", "DEFAULT_COUNT_CREATIVE_MODE_PLAYERS", "", "DEFAULT_BASE_DRAGON_HEALTH", "F", "DEFAULT_ADDITIONAL_HEALTH_PER_PLAYER", "DEFAULT_ENABLE_BROADCAST", "DEFAULT_ENABLE_INITIAL_SPAWN_DELAY", "", "DEFAULT_INITIAL_SPAWN_DELAY_SECONDS", "I", "DEFAULT_SHOW_SPAWN_DELAY_COUNTDOWN", "enableMod", "getEnableMod", "()Z", "setEnableMod", "(Z)V", "scaleWithOnePlayer", "getScaleWithOnePlayer", "setScaleWithOnePlayer", "countCreativeModePlayers", "getCountCreativeModePlayers", "setCountCreativeModePlayers", "baseDragonHealth", "getBaseDragonHealth", "()F", "setBaseDragonHealth", "(F)V", "additionalHealthPerPlayer", "getAdditionalHealthPerPlayer", "setAdditionalHealthPerPlayer", "enableBroadcast", "getEnableBroadcast", "setEnableBroadcast", "enableInitialSpawnDelay", "getEnableInitialSpawnDelay", "setEnableInitialSpawnDelay", "initialSpawnDelaySeconds", "getInitialSpawnDelaySeconds", "()I", "setInitialSpawnDelaySeconds", "(I)V", "showSpawnDelayCountdown", "getShowSpawnDelayCountdown", "setShowSpawnDelayCountdown", "Ljava/nio/file/Path;", "configFilePath", "Ljava/nio/file/Path;", "ScaledDragonFight"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    private static final boolean DEFAULT_ENABLE_MOD = true;
    private static final boolean DEFAULT_SCALE_WITH_ONE_PLAYER = false;
    private static final boolean DEFAULT_COUNT_CREATIVE_MODE_PLAYERS = false;
    private static final float DEFAULT_BASE_DRAGON_HEALTH = 200.0f;
    private static final float DEFAULT_ADDITIONAL_HEALTH_PER_PLAYER = 100.0f;
    private static final boolean DEFAULT_ENABLE_BROADCAST = true;
    private static final boolean DEFAULT_ENABLE_INITIAL_SPAWN_DELAY = true;
    private static final int DEFAULT_INITIAL_SPAWN_DELAY_SECONDS = 60;
    private static final boolean DEFAULT_SHOW_SPAWN_DELAY_COUNTDOWN = true;
    private static boolean enableMod = true;
    private static boolean scaleWithOnePlayer;
    private static boolean countCreativeModePlayers;
    private static float baseDragonHealth;
    private static float additionalHealthPerPlayer;
    private static boolean enableBroadcast;
    private static boolean enableInitialSpawnDelay;
    private static int initialSpawnDelaySeconds;
    private static boolean showSpawnDelayCountdown;
    @NotNull
    private static final Path configFilePath;

    private ConfigManager() {
    }

    public final boolean getEnableMod() {
        return enableMod;
    }

    public final void setEnableMod(boolean bl) {
        enableMod = bl;
    }

    public final boolean getScaleWithOnePlayer() {
        return scaleWithOnePlayer;
    }

    public final void setScaleWithOnePlayer(boolean bl) {
        scaleWithOnePlayer = bl;
    }

    public final boolean getCountCreativeModePlayers() {
        return countCreativeModePlayers;
    }

    public final void setCountCreativeModePlayers(boolean bl) {
        countCreativeModePlayers = bl;
    }

    public final float getBaseDragonHealth() {
        return baseDragonHealth;
    }

    public final void setBaseDragonHealth(float f) {
        baseDragonHealth = f;
    }

    public final float getAdditionalHealthPerPlayer() {
        return additionalHealthPerPlayer;
    }

    public final void setAdditionalHealthPerPlayer(float f) {
        additionalHealthPerPlayer = f;
    }

    public final boolean getEnableBroadcast() {
        return enableBroadcast;
    }

    public final void setEnableBroadcast(boolean bl) {
        enableBroadcast = bl;
    }

    public final boolean getEnableInitialSpawnDelay() {
        return enableInitialSpawnDelay;
    }

    public final void setEnableInitialSpawnDelay(boolean bl) {
        enableInitialSpawnDelay = bl;
    }

    public final int getInitialSpawnDelaySeconds() {
        return initialSpawnDelaySeconds;
    }

    public final void setInitialSpawnDelaySeconds(int n) {
        initialSpawnDelaySeconds = n;
    }

    public final boolean getShowSpawnDelayCountdown() {
        return showSpawnDelayCountdown;
    }

    public final void setShowSpawnDelayCountdown(boolean bl) {
        showSpawnDelayCountdown = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadConfig() {
        ModConstantsKt.getLOGGER().info("Loading Scaled Dragon Fight configuration...");
        Properties properties = new Properties();
        if (Files.exists(configFilePath, new LinkOption[0])) {
            try {
                Closeable closeable = Files.newInputStream(configFilePath, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl = false;
                    properties.load(inputStream);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                String string = properties.getProperty("enableMod", "true");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                Boolean bl = StringsKt.toBooleanStrictOrNull((String)string);
                enableMod = bl != null ? bl : true;
                String string2 = properties.getProperty("scaleWithOnePlayer", "false");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
                Boolean bl2 = StringsKt.toBooleanStrictOrNull((String)string2);
                scaleWithOnePlayer = bl2 != null ? bl2 : false;
                String string3 = properties.getProperty("countCreativeModePlayers", "false");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
                Boolean bl3 = StringsKt.toBooleanStrictOrNull((String)string3);
                countCreativeModePlayers = bl3 != null ? bl3 : false;
                String string4 = properties.getProperty("baseDragonHealth", "200.0");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
                Float f = StringsKt.toFloatOrNull((String)string4);
                baseDragonHealth = f != null ? f.floatValue() : 200.0f;
                String string5 = properties.getProperty("additionalHealthPerPlayer", "100.0");
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getProperty(...)");
                Float f2 = StringsKt.toFloatOrNull((String)string5);
                additionalHealthPerPlayer = f2 != null ? f2.floatValue() : 100.0f;
                String string6 = properties.getProperty("enableBroadcast", "true");
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getProperty(...)");
                Boolean bl4 = StringsKt.toBooleanStrictOrNull((String)string6);
                enableBroadcast = bl4 != null ? bl4 : true;
                String string7 = properties.getProperty("enableInitialSpawnDelay", "true");
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getProperty(...)");
                Boolean bl5 = StringsKt.toBooleanStrictOrNull((String)string7);
                enableInitialSpawnDelay = bl5 != null ? bl5 : true;
                String string8 = properties.getProperty("initialSpawnDelaySeconds", "60");
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getProperty(...)");
                Integer n = StringsKt.toIntOrNull((String)string8);
                initialSpawnDelaySeconds = n != null ? n : 60;
                String string9 = properties.getProperty("showSpawnDelayCountdown", "true");
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getProperty(...)");
                Boolean bl6 = StringsKt.toBooleanStrictOrNull((String)string9);
                showSpawnDelayCountdown = bl6 != null ? bl6 : true;
                ModConstantsKt.getLOGGER().info("Configuration loaded: Mod Enabled = " + enableMod + ", Scale w/ 1 Player = " + scaleWithOnePlayer + ", Count Creative = " + countCreativeModePlayers + ", Base Health = " + baseDragonHealth + ", Additional Health/Player = " + additionalHealthPerPlayer + ", Enable Broadcast = " + enableBroadcast);
                this.saveConfig();
            }
            catch (Exception e) {
                ModConstantsKt.getLOGGER().error("Failed to load configuration for scaleddragonfight. Using default values and attempting to save a new config file.", (Throwable)e);
                this.resetToDefaultsAndSave();
            }
        } else {
            ModConstantsKt.getLOGGER().info("No configuration file found for scaleddragonfight. Creating with default values.");
            this.resetToDefaultsAndSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveConfig() {
        ModConstantsKt.getLOGGER().info("Saving Scaled Dragon Fight configuration...");
        Properties properties = new Properties();
        properties.setProperty("enableMod", String.valueOf(enableMod));
        properties.setProperty("scaleWithOnePlayer", String.valueOf(scaleWithOnePlayer));
        properties.setProperty("countCreativeModePlayers", String.valueOf(countCreativeModePlayers));
        properties.setProperty("baseDragonHealth", String.valueOf(baseDragonHealth));
        properties.setProperty("additionalHealthPerPlayer", String.valueOf(additionalHealthPerPlayer));
        properties.setProperty("enableBroadcast", String.valueOf(enableBroadcast));
        properties.setProperty("enableInitialSpawnDelay", String.valueOf(enableInitialSpawnDelay));
        properties.setProperty("initialSpawnDelaySeconds", String.valueOf(initialSpawnDelaySeconds));
        properties.setProperty("showSpawnDelayCountdown", String.valueOf(showSpawnDelayCountdown));
        String comments = "Scaled Dragon Fight Configuration\n\nenableMod: If true, the mod will be active. (Default: true)\nbaseDragonHealth: Base health of the Ender Dragon. (Default: 200.0)\nadditionalHealthPerPlayer: Extra health added for each eligible player. (Default: 100.0)\nscaleWithOnePlayer: If true, the dragon's health will increase counting the first eligible player.\n                  If false, scaling only starts with the second eligible player.\n                  Example (assuming 100 additional health per player):\n                      True:\n                          1 Eligible Player = Base Health + 100\n                          2 Eligible Players = Base Health + 200\n                      False:\n                          1 Eligible Player = Base Health\n                          2 Eligible Players = Base Health + 100\n                  (Default: false)\ncountCreativeModePlayers: If true, players in creative mode will be counted when scaling health. (Default: false)\nenableBroadcast: If true, a message will be broadcast when the scaled dragon spawns. (Default: true)\n\n--- Initial Spawn Delay ---\nenableInitialSpawnDelay: If true, the very first Ender Dragon spawn in The End will be delayed. (Default: true)\ninitialSpawnDelaySeconds: How many seconds to delay the initial dragon spawn. (Default: 60)\nshowSpawnDelayCountdown: If true, a countdown will be shown on players' XP bars in The End during the delay. (Default: true)\n\\n";
        try {
            Closeable closeable = Files.newOutputStream(configFilePath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl = false;
                properties.store(outputStream, comments);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ModConstantsKt.getLOGGER().info("Configuration saved to " + configFilePath);
        }
        catch (Exception e) {
            ModConstantsKt.getLOGGER().error("Failed to save configuration for scaleddragonfight.", (Throwable)e);
        }
    }

    private final void resetToDefaultsAndSave() {
        enableMod = true;
        scaleWithOnePlayer = false;
        countCreativeModePlayers = false;
        baseDragonHealth = 200.0f;
        additionalHealthPerPlayer = 100.0f;
        enableBroadcast = true;
        enableInitialSpawnDelay = true;
        initialSpawnDelaySeconds = 60;
        showSpawnDelayCountdown = true;
        this.saveConfig();
    }

    static {
        baseDragonHealth = 200.0f;
        additionalHealthPerPlayer = 100.0f;
        enableBroadcast = true;
        enableInitialSpawnDelay = true;
        initialSpawnDelaySeconds = 60;
        showSpawnDelayCountdown = true;
        Path path = FabricLoader.getInstance().getConfigDir().resolve("scaleddragonfight.properties");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        configFilePath = path;
    }
}

