/*
 * Decompiled with CFR 0.152.
 */
package com.zephbyte.scaleddragonfight;

import com.zephbyte.scaleddragonfight.ConfigManager;
import com.zephbyte.scaleddragonfight.DragonScaler;
import com.zephbyte.scaleddragonfight.ModConstantsKt;
import com.zephbyte.scaleddragonfight.mixin.EnderDragonFightAccessor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2881;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/zephbyte/scaleddragonfight/DragonEventHandler;", "", "<init>", "()V", "", "register", "Lnet/minecraft/class_2881;", "fight", "Lnet/minecraft/class_3218;", "world", "", "onInitialDragonPreSpawn", "(Lnet/minecraft/class_2881;Lnet/minecraft/class_3218;)Z", "onWorldTick", "(Lnet/minecraft/class_3218;)V", "", "Lcom/zephbyte/scaleddragonfight/DragonEventHandler$DelayState;", "worldDelayStates", "Ljava/util/Map;", "DelayState", "ScaledDragonFight"})
@SourceDebugExtension(value={"SMAP\nDragonEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DragonEventHandler.kt\ncom/zephbyte/scaleddragonfight/DragonEventHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1869#2,2:148\n*S KotlinDebug\n*F\n+ 1 DragonEventHandler.kt\ncom/zephbyte/scaleddragonfight/DragonEventHandler\n*L\n113#1:148,2\n*E\n"})
public final class DragonEventHandler {
    @NotNull
    public static final DragonEventHandler INSTANCE = new DragonEventHandler();
    @NotNull
    private static final Map<class_3218, DelayState> worldDelayStates = new LinkedHashMap();

    private DragonEventHandler() {
    }

    public final void register() {
        ServerEntityEvents.ENTITY_LOAD.register(DragonEventHandler::register$lambda$0);
        ServerTickEvents.END_WORLD_TICK.register(this::onWorldTick);
        ModConstantsKt.getLOGGER().info("DragonEventHandler registered for spawn delay and scaling.");
    }

    public final boolean onInitialDragonPreSpawn(@NotNull class_2881 fight, @NotNull class_3218 world) {
        Intrinsics.checkNotNullParameter((Object)fight, (String)"fight");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (!Intrinsics.areEqual((Object)world.method_27983(), (Object)class_1937.field_25181)) {
            return false;
        }
        DelayState delayState = worldDelayStates.computeIfAbsent(world, arg_0 -> DragonEventHandler.onInitialDragonPreSpawn$lambda$2(DragonEventHandler::onInitialDragonPreSpawn$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)delayState, (String)"computeIfAbsent(...)");
        DelayState state = delayState;
        if (!ConfigManager.INSTANCE.getEnableInitialSpawnDelay()) {
            state.setInitialSpawnAttemptProcessed(true);
            if (state.getDelayActive()) {
                state.setDelayActive(false);
                state.setTicksRemaining(0);
                ModConstantsKt.getLOGGER().info("Initial spawn delay was active but config is now disabled. Dragon will attempt to spawn.");
            }
            return false;
        }
        if (state.getInitialSpawnAttemptProcessed() && !state.getDelayActive()) {
            ModConstantsKt.getLOGGER().debug("Permitting dragon spawn triggered by delay completion.");
            return false;
        }
        if (state.getDelayActive()) {
            ModConstantsKt.getLOGGER().debug("Dragon spawn attempt while delay is_active. Cancelling vanilla spawn.");
            return true;
        }
        ModConstantsKt.getLOGGER().info("Initial Ender Dragon spawn in " + world.method_27983().method_29177() + " will be delayed by " + ConfigManager.INSTANCE.getInitialSpawnDelaySeconds() + " seconds.");
        state.setDelayActive(true);
        state.setTicksRemaining(ConfigManager.INSTANCE.getInitialSpawnDelaySeconds() * 20);
        state.setInitialSpawnAttemptProcessed(true);
        state.setFightInstance(fight);
        return true;
    }

    private final void onWorldTick(class_3218 world) {
        if (!Intrinsics.areEqual((Object)world.method_27983(), (Object)class_1937.field_25181)) {
            return;
        }
        DelayState delayState = worldDelayStates.get(world);
        if (delayState == null) {
            return;
        }
        DelayState state = delayState;
        if (!ConfigManager.INSTANCE.getEnableInitialSpawnDelay() && state.getDelayActive()) {
            ModConstantsKt.getLOGGER().info("Initial spawn delay feature disabled mid-countdown for " + world.method_27983().method_29177() + ". Triggering dragon spawn now.");
            state.setDelayActive(false);
            state.setTicksRemaining(0);
        }
        if (state.getDelayActive() && state.getTicksRemaining() > 0) {
            int remainingSeconds;
            int n = state.getTicksRemaining();
            state.setTicksRemaining(n + -1);
            if (ConfigManager.INSTANCE.getShowSpawnDelayCountdown() && (remainingSeconds = (int)Math.ceil((double)state.getTicksRemaining() / 20.0)) > 0) {
                class_5250 message = class_2561.method_43470((String)("Dragon spawning in: " + remainingSeconds + "..."));
                List list = world.method_18456();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_3222 player = (class_3222)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)player.method_37908().method_27983(), (Object)class_1937.field_25181)) continue;
                    player.method_7353((class_2561)message, true);
                }
            }
            if (state.getTicksRemaining() <= 0) {
                ModConstantsKt.getLOGGER().info("Initial spawn delay finished for " + world.method_27983().method_29177() + ". Triggering Ender Dragon spawn.");
                state.setDelayActive(false);
                class_2881 class_28812 = state.getFightInstance();
                if (class_28812 != null) {
                    class_2881 fight = class_28812;
                    boolean bl = false;
                    if (fight instanceof EnderDragonFightAccessor) {
                        ((EnderDragonFightAccessor)fight).callRespawnDragon(CollectionsKt.emptyList());
                        ModConstantsKt.getLOGGER().info("Ender Dragon respawn initiated by the mod after delay via accessor.");
                    } else {
                        ModConstantsKt.getLOGGER().error("Could not cast EnderDragonFight to EnderDragonFightAccessor. Dragon not spawned post-delay.");
                    }
                } else {
                    ModConstantsKt.getLOGGER().error("EnderDragonFight instance was null when trying to spawn dragon post-delay for " + world.method_27983().method_29177());
                }
            }
        }
    }

    private static final void register$lambda$0(class_1297 entity, class_3218 world) {
        if (!ConfigManager.INSTANCE.getEnableMod()) {
            return;
        }
        if (world != null && entity instanceof class_1510 && Intrinsics.areEqual((Object)world.method_27983(), (Object)class_1937.field_25181)) {
            ModConstantsKt.getLOGGER().info("Ender Dragon detected loading in The End! Checking scaling conditions...");
            DragonScaler.INSTANCE.scaleDragon((class_1510)entity, world);
        }
    }

    private static final DelayState onInitialDragonPreSpawn$lambda$1(class_3218 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DelayState(false, 0, false, null, 15, null);
    }

    private static final DelayState onInitialDragonPreSpawn$lambda$2(Function1 $tmp0, Object p0) {
        return (DelayState)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J:\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00022\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0015\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u001eR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\"R\"\u0010\u0006\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b#\u0010\f\"\u0004\b$\u0010\u001eR$\u0010\b\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010%\u001a\u0004\b&\u0010\u0011\"\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/zephbyte/scaleddragonfight/DragonEventHandler$DelayState;", "", "", "delayActive", "", "ticksRemaining", "initialSpawnAttemptProcessed", "Lnet/minecraft/class_2881;", "fightInstance", "<init>", "(ZIZLnet/minecraft/class_2881;)V", "component1", "()Z", "component2", "()I", "component3", "component4", "()Lnet/minecraft/class_2881;", "copy", "(ZIZLnet/minecraft/class_2881;)Lcom/zephbyte/scaleddragonfight/DragonEventHandler$DelayState;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Z", "getDelayActive", "setDelayActive", "(Z)V", "I", "getTicksRemaining", "setTicksRemaining", "(I)V", "getInitialSpawnAttemptProcessed", "setInitialSpawnAttemptProcessed", "Lnet/minecraft/class_2881;", "getFightInstance", "setFightInstance", "(Lnet/minecraft/class_2881;)V", "ScaledDragonFight"})
    private static final class DelayState {
        private boolean delayActive;
        private int ticksRemaining;
        private boolean initialSpawnAttemptProcessed;
        @Nullable
        private class_2881 fightInstance;

        public DelayState(boolean delayActive, int ticksRemaining, boolean initialSpawnAttemptProcessed, @Nullable class_2881 fightInstance) {
            this.delayActive = delayActive;
            this.ticksRemaining = ticksRemaining;
            this.initialSpawnAttemptProcessed = initialSpawnAttemptProcessed;
            this.fightInstance = fightInstance;
        }

        public /* synthetic */ DelayState(boolean bl, int n, boolean bl2, class_2881 class_28812, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                bl2 = false;
            }
            if ((n2 & 8) != 0) {
                class_28812 = null;
            }
            this(bl, n, bl2, class_28812);
        }

        public final boolean getDelayActive() {
            return this.delayActive;
        }

        public final void setDelayActive(boolean bl) {
            this.delayActive = bl;
        }

        public final int getTicksRemaining() {
            return this.ticksRemaining;
        }

        public final void setTicksRemaining(int n) {
            this.ticksRemaining = n;
        }

        public final boolean getInitialSpawnAttemptProcessed() {
            return this.initialSpawnAttemptProcessed;
        }

        public final void setInitialSpawnAttemptProcessed(boolean bl) {
            this.initialSpawnAttemptProcessed = bl;
        }

        @Nullable
        public final class_2881 getFightInstance() {
            return this.fightInstance;
        }

        public final void setFightInstance(@Nullable class_2881 class_28812) {
            this.fightInstance = class_28812;
        }

        public final boolean component1() {
            return this.delayActive;
        }

        public final int component2() {
            return this.ticksRemaining;
        }

        public final boolean component3() {
            return this.initialSpawnAttemptProcessed;
        }

        @Nullable
        public final class_2881 component4() {
            return this.fightInstance;
        }

        @NotNull
        public final DelayState copy(boolean delayActive, int ticksRemaining, boolean initialSpawnAttemptProcessed, @Nullable class_2881 fightInstance) {
            return new DelayState(delayActive, ticksRemaining, initialSpawnAttemptProcessed, fightInstance);
        }

        public static /* synthetic */ DelayState copy$default(DelayState delayState, boolean bl, int n, boolean bl2, class_2881 class_28812, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = delayState.delayActive;
            }
            if ((n2 & 2) != 0) {
                n = delayState.ticksRemaining;
            }
            if ((n2 & 4) != 0) {
                bl2 = delayState.initialSpawnAttemptProcessed;
            }
            if ((n2 & 8) != 0) {
                class_28812 = delayState.fightInstance;
            }
            return delayState.copy(bl, n, bl2, class_28812);
        }

        @NotNull
        public String toString() {
            return "DelayState(delayActive=" + this.delayActive + ", ticksRemaining=" + this.ticksRemaining + ", initialSpawnAttemptProcessed=" + this.initialSpawnAttemptProcessed + ", fightInstance=" + this.fightInstance + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.delayActive);
            result = result * 31 + Integer.hashCode(this.ticksRemaining);
            result = result * 31 + Boolean.hashCode(this.initialSpawnAttemptProcessed);
            result = result * 31 + (this.fightInstance == null ? 0 : this.fightInstance.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DelayState)) {
                return false;
            }
            DelayState delayState = (DelayState)other;
            if (this.delayActive != delayState.delayActive) {
                return false;
            }
            if (this.ticksRemaining != delayState.ticksRemaining) {
                return false;
            }
            if (this.initialSpawnAttemptProcessed != delayState.initialSpawnAttemptProcessed) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fightInstance, (Object)delayState.fightInstance);
        }

        public DelayState() {
            this(false, 0, false, null, 15, null);
        }
    }
}

