/*
 * Decompiled with CFR 0.152.
 */
package net.nukebob.tetrismc.screen;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8662;
import net.nukebob.tetrismc.config.TetrisConfig;
import net.nukebob.tetrismc.game.HighScores;
import net.nukebob.tetrismc.game.tetris.Animation;
import net.nukebob.tetrismc.game.tetris.mino.Block;
import net.nukebob.tetrismc.game.tetris.mino.Mino;
import net.nukebob.tetrismc.game.tetris.mino.Mino_Bar;
import net.nukebob.tetrismc.game.tetris.mino.Mino_L1;
import net.nukebob.tetrismc.game.tetris.mino.Mino_L2;
import net.nukebob.tetrismc.game.tetris.mino.Mino_Square;
import net.nukebob.tetrismc.game.tetris.mino.Mino_T;
import net.nukebob.tetrismc.game.tetris.mino.Mino_Z1;
import net.nukebob.tetrismc.game.tetris.mino.Mino_Z2;

public class TetrisScreen
extends class_437 {
    public static int dropInterval = 60;
    static final int gridX = 10;
    static final int gridY = 16;
    public static final int WIDTH = Block.SIZE * 10;
    public static final int HEIGHT = Block.SIZE * 16;
    int levelLength = 5;
    public static final int nextWIDTH = Block.SIZE * 4;
    public static final int nextHEIGHT = Block.SIZE * 5;
    public static int left_x;
    public static int right_x;
    public static int top_y;
    public static int bottom_y;
    public static boolean upPressed;
    public static boolean downPressed;
    public static boolean leftPressed;
    public static boolean rightPressed;
    public static boolean spacePressed;
    public static boolean paused;
    public static boolean active;
    public static int hardDrop;
    public static ArrayList<Block> staticBlocks;
    public static ArrayList<Block> destroying;
    public static ArrayList<Animation> animations;
    public static int score;
    public static int linesCleared;
    public static int level;
    public static int combo;
    public static boolean isNewHighScore;
    public static class_2561 onScreenText;
    public static int onScreenTextColour;
    public static int onScreenTextOpacity;
    public static float animation;
    public final class_437 parent;
    public static Mino currentMino;
    public static Mino nextMino;
    private final TetrisConfig config = TetrisConfig.loadConfig();
    class_4185 playButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"tetrismc:game.start").method_54663(-256), button -> this.reset()).method_46431();

    public TetrisScreen(class_437 parent) {
        super(class_2561.method_30163((String)"Tetris Screen"));
        this.parent = parent;
        this.method_25426();
    }

    protected void method_25426() {
        left_x = this.field_22789 / 2 - WIDTH / 2;
        right_x = left_x + WIDTH;
        top_y = this.field_22790 / 2 - HEIGHT / 2;
        bottom_y = top_y + HEIGHT;
        paused = true;
        hardDrop = this.config.tetris_hard_drop;
        class_8662 returnButton = class_8662.method_52723((class_2561)class_2561.method_43473(), button -> this.field_22787.method_1507(this.parent), (boolean)true).method_52727(class_2960.method_60655((String)"tetrismc", (String)"icon/return"), 15, 15).method_52724();
        returnButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tetrismc:game.return")));
        returnButton.method_55444(20, 20, 20, 20);
        class_8662 restartButton = class_8662.method_52723((class_2561)class_2561.method_43473(), button -> this.gameOver(), (boolean)true).method_52727(class_2960.method_60655((String)"tetrismc", (String)"icon/restart"), 15, 15).method_52724();
        restartButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tetrismc:game.restart")));
        restartButton.method_55444(20, 20, 45, 20);
        class_8662 pauseButton = class_8662.method_52723((class_2561)class_2561.method_43473(), button -> {
            paused = !paused;
        }, (boolean)true).method_52727(class_2960.method_60655((String)"tetrismc", (String)"icon/pause"), 15, 15).method_52724();
        pauseButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tetrismc:game.pause")));
        pauseButton.method_55444(20, 20, 70, 20);
        this.playButton.method_48229(this.field_22789 / 2 - 75, this.field_22790 / 2 - 10);
        this.playButton.method_55445(150, 20);
        this.method_37063((class_364)returnButton);
        this.method_37063((class_364)restartButton);
        this.method_37063((class_364)pauseButton);
        this.method_37063((class_364)this.playButton);
    }

    public void reset() {
        score = 0;
        linesCleared = 0;
        level = 0;
        combo = 0;
        dropInterval = 60;
        onScreenTextOpacity = 60;
        onScreenTextColour = 0;
        onScreenText = class_2561.method_43473();
        animation = animation % 30.0f * 10.0f;
        isNewHighScore = false;
        paused = false;
        active = true;
        staticBlocks = new ArrayList();
        destroying = new ArrayList();
        animations = new ArrayList();
        currentMino = this.pickMino();
        currentMino.setXY(WIDTH / 2, Block.SIZE);
        spacePressed = false;
        downPressed = false;
        upPressed = false;
        rightPressed = false;
        leftPressed = false;
        nextMino = this.pickMino();
        nextMino.setXY(WIDTH + Block.SIZE * 2 + (nextMino instanceof Mino_L2 || nextMino instanceof Mino_Z1 ? Block.SIZE : (nextMino instanceof Mino_T ? Block.SIZE / 2 : 0)), HEIGHT - (int)((float)Block.SIZE * 2.5f));
    }

    public void manager() {
        if (currentMino == null) {
            this.reset();
        }
        if (!TetrisScreen.currentMino.active) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"block.stone.place")), (float)1.5f, (float)(5.0f * this.config.tetris_volume)));
            score += 10;
            staticBlocks.add(TetrisScreen.currentMino.b[0]);
            staticBlocks.add(TetrisScreen.currentMino.b[1]);
            staticBlocks.add(TetrisScreen.currentMino.b[2]);
            staticBlocks.add(TetrisScreen.currentMino.b[3]);
            int lines = 0;
            if (this.checkClear(TetrisScreen.currentMino.b[0].y)) {
                ++lines;
            }
            if (this.checkClear(TetrisScreen.currentMino.b[1].y)) {
                ++lines;
            }
            if (this.checkClear(TetrisScreen.currentMino.b[2].y)) {
                ++lines;
            }
            if (this.checkClear(TetrisScreen.currentMino.b[3].y)) {
                ++lines;
            }
            int height = 108;
            int width = 192;
            if (lines > 0) {
                if (++combo > 1) {
                    onScreenText = class_2561.method_43471((String)"tetrismc:tetris.combo").method_27693(" x" + combo);
                    onScreenTextOpacity = 30;
                    onScreenTextColour = combo > 3 ? -65536 : (combo > 2 ? -256 : -1);
                    score += 50 * (combo - 1);
                }
            } else {
                combo = 0;
            }
            switch (lines) {
                case 1: {
                    score += 100;
                    break;
                }
                case 2: {
                    score += 300;
                    break;
                }
                case 3: {
                    score += 500;
                    break;
                }
                case 4: {
                    score += 800;
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"entity.generic.explode")), (float)0.8f, (float)(5.0f * this.config.tetris_volume)));
                    animations.add(new Animation(this.field_22789 / 2 - width / 2, TetrisScreen.currentMino.b[2].y, width, height, "explosion", 20));
                    onScreenText = class_2561.method_43471((String)"tetrismc:tetris.tetris");
                    onScreenTextColour = 0xAA00AA;
                    onScreenTextOpacity = 30;
                }
            }
            switch (level) {
                case 1: {
                    dropInterval = 54;
                    break;
                }
                case 2: {
                    dropInterval = 48;
                    break;
                }
                case 3: {
                    dropInterval = 41;
                    break;
                }
                case 4: {
                    dropInterval = 35;
                    break;
                }
                case 5: {
                    dropInterval = 29;
                    break;
                }
                case 6: {
                    dropInterval = 22;
                    break;
                }
                case 7: {
                    dropInterval = 16;
                    break;
                }
                case 8: {
                    dropInterval = 10;
                    break;
                }
                case 9: {
                    dropInterval = 8;
                    break;
                }
                case 10: {
                    dropInterval = 6;
                }
            }
            for (Block b : TetrisScreen.currentMino.b) {
                if (b.y > Block.SIZE * 2) continue;
                this.gameOver();
                return;
            }
            currentMino = nextMino;
            currentMino.setXY(WIDTH / 2, Block.SIZE);
            nextMino = this.pickMino();
            nextMino.setXY(WIDTH + Block.SIZE * 2 + (nextMino instanceof Mino_L2 || nextMino instanceof Mino_Z1 ? Block.SIZE : (nextMino instanceof Mino_T ? Block.SIZE / 2 : 0)), HEIGHT - (int)((float)Block.SIZE * 2.5f));
        }
        float frameDuration = class_310.method_1551().method_61966().method_60636();
        currentMino.update(frameDuration * 3.0f);
        animation += frameDuration * 3.0f;
    }

    private void gameOver() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"entity.pig.ambient")), (float)1.0f, (float)(5.0f * this.config.tetris_volume)));
        isNewHighScore = score > HighScores.loadHighScores().tetrisHighScore;
        active = false;
    }

    private boolean checkClear(int y) {
        int count = 0;
        for (Block block : staticBlocks) {
            if (block.y != y) continue;
            ++count;
        }
        if (count < 10) {
            return false;
        }
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"block.deepslate.break")), (float)1.0f, (float)(5.0f * this.config.tetris_volume)));
        ++linesCleared;
        for (Block block : staticBlocks) {
            if (block.y != y) continue;
            destroying.add(block);
        }
        staticBlocks.removeIf(b -> b.y == y);
        for (Block block : staticBlocks) {
            if (block.y >= y) continue;
            block.y += Block.SIZE;
        }
        if (linesCleared % this.levelLength == 0) {
            ++level;
        }
        return true;
    }

    private Mino pickMino() {
        Mino_L1 mino = null;
        int i = new Random().nextInt(7);
        mino = switch (i) {
            case 0 -> new Mino_L1();
            case 1 -> new Mino_L2();
            case 2 -> new Mino_Square();
            case 3 -> new Mino_Bar();
            case 4 -> new Mino_T();
            case 5 -> new Mino_Z1();
            case 6 -> new Mino_Z2();
            default -> mino;
        };
        return mino;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (active) {
            super.method_25394(context, mouseX, mouseY, delta);
        }
        if (!paused && active) {
            this.manager();
        }
        if (paused) {
            spacePressed = false;
            rightPressed = false;
            leftPressed = false;
            downPressed = false;
            upPressed = false;
        }
        float scale = switch ((Integer)class_310.method_1551().field_1690.method_42474().method_41753()) {
            case 4 -> 0.8f;
            case 1 -> 3.0f;
            case 2 -> 1.6f;
            default -> 1.0f;
        };
        context.method_51448().pushMatrix();
        context.method_51448().scale(scale, scale);
        float offsetX = (float)context.method_51421() * (1.0f - scale) / (2.0f * scale);
        float offsetY = (float)context.method_51443() * (1.0f - scale) / (2.0f * scale);
        context.method_51448().translate(offsetX, offsetY);
        context.method_51738(left_x - 1, right_x, top_y - 1 + Block.SIZE * 3, new Color(1.0f, 0.0f, 0.0f, 0.3f).getRGB());
        context.method_49601(left_x - 1, top_y - 1, WIDTH + 2, HEIGHT + 2, -1);
        if (currentMino != null) {
            currentMino.draw(context);
            if (hardDrop > 0) {
                currentMino.drawHardDrop(context);
            }
        }
        context.method_49601(right_x + Block.SIZE - 1, bottom_y - nextHEIGHT + 1, nextWIDTH + 2, nextHEIGHT, -1);
        class_5250 nextText = class_2561.method_43471((String)"tetrismc:tetris.next");
        context.method_51439(this.field_22793, (class_2561)nextText, right_x + Block.SIZE * 2, bottom_y - nextHEIGHT + Block.SIZE / 2, -1, true);
        if (nextMino != null) {
            nextMino.draw(context);
        }
        class_5250 scoreText = class_2561.method_43471((String)"tetrismc:tetris.score").method_27693(": " + score);
        context.method_51439(this.field_22793, (class_2561)scoreText, right_x + Block.SIZE * 2, top_y + Block.SIZE, -1, true);
        class_5250 linesText = class_2561.method_43471((String)"tetrismc:tetris.lines").method_27693(": " + linesCleared);
        context.method_51439(this.field_22793, (class_2561)linesText, right_x + Block.SIZE * 2, top_y + Block.SIZE + 10, -1, true);
        for (Block block : staticBlocks) {
            block.draw(context);
        }
        for (Block d2 : destroying) {
            d2.destroying += class_310.method_1551().method_61966().method_60636() * 3.0f;
            if (d2.destroying > 9.0f) {
                d2.destroying = 9.0f;
            }
            d2.draw(context);
        }
        destroying.removeIf(d -> d.destroying >= 9.0f);
        for (Animation a : animations) {
            if (a.animation.equals("explosion")) {
                a.draw(context, this.field_22789 / 2 - a.width / 2, top_y + a.y - a.height / 2);
            } else {
                a.draw(context);
            }
            a.frame += 1.0f;
        }
        animations.removeIf(an -> an.frame > (float)an.frames);
        class_5250 pausedText = class_2561.method_43471((String)"tetrismc:tetris.paused");
        if (paused && active) {
            context.method_51439(this.field_22793, (class_2561)pausedText, this.field_22789 / 2 - 3 * pausedText.getString().length(), this.field_22790 / 2 - 7, -1, true);
        }
        if (onScreenTextOpacity > 0) {
            Color base = new Color(onScreenTextColour, false);
            float alpha = Math.clamp((float)onScreenTextOpacity / 10.0f, 0.0f, 1.0f);
            Color color = new Color((float)base.getRed() / 255.0f, (float)base.getGreen() / 255.0f, (float)base.getBlue() / 255.0f, alpha);
            context.method_51439(this.field_22793, onScreenText, this.field_22789 / 2 - onScreenText.getString().length(), this.field_22790 / 2, color.getRGB(), true);
            --onScreenTextOpacity;
        }
        boolean bl = this.playButton.field_22764 = !active;
        if (!active) {
            Color black = new Color(-16777216);
            context.method_25294(left_x - 1, top_y - 1, left_x - 1 + WIDTH + 2, top_y - 1 + HEIGHT + 2, new Color((float)black.getRed(), (float)black.getGreen(), (float)black.getBlue(), 0.75f).getRGB());
            super.method_25394(context, mouseX, mouseY, delta);
            if (currentMino != null) {
                class_5250 finalScoreText = class_2561.method_43471((String)"tetrismc:tetris.score").method_27693(": " + score).method_54663(-171);
                context.method_51439(this.field_22793, (class_2561)finalScoreText, this.field_22789 / 2 - finalScoreText.getString().length() * 3, this.field_22790 / 2 - 35, -1, true);
                class_5250 linesClearedText = class_2561.method_43471((String)"tetrismc:tetris.lines").method_27693(": " + linesCleared).method_54663(-171);
                context.method_51439(this.field_22793, (class_2561)linesClearedText, this.field_22789 / 2 - linesClearedText.getString().length() * 3, this.field_22790 / 2 - 25, -1, true);
                HighScores.loadHighScores();
                if (score > HighScores.loadHighScores().tetrisHighScore) {
                    HighScores.loadHighScores().tetrisHighScore = score;
                    HighScores.saveHighScores();
                }
                class_5250 highScoreClearedText = class_2561.method_43471((String)(isNewHighScore ? "tetrismc:tetris.new_high_score" : "tetrismc:tetris.high_score")).method_27693(": " + HighScores.loadHighScores().tetrisHighScore).method_54663(-256);
                if (HighScores.loadHighScores().tetrisHighScore > 0) {
                    context.method_51439(this.field_22793, (class_2561)highScoreClearedText, this.field_22789 / 2 - highScoreClearedText.getString().length() * 3, this.field_22790 / 2 + 25, -1, true);
                }
            }
        }
        context.method_51448().popMatrix();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        switch (keyCode) {
            case 68: 
            case 262: {
                rightPressed = true;
                break;
            }
            case 65: 
            case 263: {
                leftPressed = true;
                break;
            }
            case 83: 
            case 264: {
                downPressed = true;
                break;
            }
            case 87: 
            case 265: {
                upPressed = true;
                break;
            }
            case 32: {
                spacePressed = true;
            }
        }
        return false;
    }

    static {
        active = false;
        staticBlocks = new ArrayList();
        destroying = new ArrayList();
        animations = new ArrayList();
        score = 0;
        linesCleared = 0;
        level = 0;
        combo = 0;
        isNewHighScore = false;
        onScreenTextOpacity = 0;
        animation = 0.0f;
    }
}

