/*
 * Decompiled with CFR 0.152.
 */
package net.nukebob.tetrismc.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_310;
import net.nukebob.tetrismc.TetrisMC;

public class TetrisConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(String.valueOf(class_310.method_1551().field_1697) + "/config/tetrismc/config.json");
    private static TetrisConfig config;
    public boolean mod_enabled = true;
    public boolean tetris_random_textures = true;
    public int tetris_hard_drop = 1;
    public float tetris_volume = 1.0f;

    public static TetrisConfig loadConfig() {
        if (!CONFIG_FILE.exists()) {
            config = new TetrisConfig();
            TetrisConfig.saveConfig();
        } else {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (TetrisConfig)GSON.fromJson((Reader)reader, TetrisConfig.class);
            }
            catch (IOException e) {
                TetrisMC.LOGGER.error("Could not load config file", (Throwable)e);
            }
        }
        if (config == null) {
            config = new TetrisConfig();
            TetrisConfig.saveConfig();
        }
        return config;
    }

    public static void saveConfig() {
        if (!CONFIG_FILE.getParentFile().exists()) {
            CONFIG_FILE.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            TetrisMC.LOGGER.error("Could not save config file", (Throwable)e);
        }
    }
}

