/*
 * Decompiled with CFR 0.152.
 */
package net.nukebob.tetrismc.game.tetris.mino;

import java.awt.Color;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10889;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.nukebob.tetrismc.TetrisMC;
import net.nukebob.tetrismc.config.TetrisConfig;
import net.nukebob.tetrismc.game.tetris.HardDropAnimation;
import net.nukebob.tetrismc.game.tetris.mino.Block;
import net.nukebob.tetrismc.game.tetris.mino.Mino_Bar;
import net.nukebob.tetrismc.game.tetris.mino.Mino_L1;
import net.nukebob.tetrismc.game.tetris.mino.Mino_L2;
import net.nukebob.tetrismc.game.tetris.mino.Mino_Square;
import net.nukebob.tetrismc.game.tetris.mino.Mino_T;
import net.nukebob.tetrismc.game.tetris.mino.Mino_Z1;
import net.nukebob.tetrismc.game.tetris.mino.Mino_Z2;
import net.nukebob.tetrismc.screen.TetrisScreen;

public abstract class Mino {
    public Block[] b = new Block[4];
    public Block[] tempB = new Block[4];
    public String type = "";
    float dropCounter = 0.0f;
    public int direction = 1;
    boolean leftCollision;
    boolean rightCollision;
    boolean bottomCollision;
    public boolean active = true;
    private final TetrisConfig config = TetrisConfig.loadConfig();

    public Mino() {
        Mino mino = this;
        Objects.requireNonNull(mino);
        Mino mino2 = mino;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Mino_Square.class, Mino_Bar.class, Mino_T.class, Mino_L1.class, Mino_L2.class, Mino_Z1.class, Mino_Z2.class}, (Object)mino2, n)) {
            case 0: {
                Mino_Square ignored = (Mino_Square)mino2;
                this.type = "square";
                break;
            }
            case 1: {
                Mino_Bar ignored = (Mino_Bar)mino2;
                this.type = "bar";
                break;
            }
            case 2: {
                Mino_T ignored = (Mino_T)mino2;
                this.type = "t";
                break;
            }
            case 3: {
                Mino_L1 ignored = (Mino_L1)mino2;
                this.type = "l1";
                break;
            }
            case 4: {
                Mino_L2 ignored = (Mino_L2)mino2;
                this.type = "l2";
                break;
            }
            case 5: {
                Mino_Z1 ignored = (Mino_Z1)mino2;
                this.type = "z1";
                break;
            }
            case 6: {
                Mino_Z2 ignored = (Mino_Z2)mino2;
                this.type = "z2";
                break;
            }
        }
        class_3545<class_2960, class_5250> randomBlock = this.getRandomBlockTexture();
        this.create((class_2960)randomBlock.method_15442(), (class_5250)randomBlock.method_15441());
    }

    public void create(class_2960 texture, class_5250 name) {
        this.b[0] = new Block(texture, name, this.type);
        this.b[1] = new Block(texture, name, this.type);
        this.b[2] = new Block(texture, name, this.type);
        this.b[3] = new Block(texture, name, this.type);
        this.tempB[0] = new Block(texture, name, this.type);
        this.tempB[1] = new Block(texture, name, this.type);
        this.tempB[2] = new Block(texture, name, this.type);
        this.tempB[3] = new Block(texture, name, this.type);
    }

    public void setXY(int x, int y) {
    }

    public void updateXY(int direction) {
        for (Block b : this.tempB) {
            if (b.x < 0) {
                for (Block sB : TetrisScreen.staticBlocks) {
                    if (sB.x != b.x + Block.SIZE || sB.y != b.y) continue;
                    return;
                }
                for (Block block : this.tempB) {
                    block.x += Block.SIZE;
                }
            }
            if (b.x > TetrisScreen.WIDTH - Block.SIZE) {
                for (Block sB : TetrisScreen.staticBlocks) {
                    if (sB.x != b.x || sB.y != b.y) continue;
                    return;
                }
                for (Block block : this.tempB) {
                    block.x -= Block.SIZE;
                }
            }
            if (b.y > TetrisScreen.HEIGHT - Block.SIZE) {
                return;
            }
            for (Block sB : TetrisScreen.staticBlocks) {
                if (sB.x != b.x || sB.y != b.y) continue;
                return;
            }
        }
        this.direction = direction;
        this.b[0].x = this.tempB[0].x;
        this.b[0].y = this.tempB[0].y;
        this.b[1].x = this.tempB[1].x;
        this.b[1].y = this.tempB[1].y;
        this.b[2].x = this.tempB[2].x;
        this.b[2].y = this.tempB[2].y;
        this.b[3].x = this.tempB[3].x;
        this.b[3].y = this.tempB[3].y;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"block.wooden_button.click_on")), (float)2.0f, (float)this.config.tetris_volume));
    }

    public void getDirection1() {
    }

    public void getDirection2() {
    }

    public void getDirection3() {
    }

    public void getDirection4() {
    }

    public void checkMovementCollision() {
        this.leftCollision = false;
        this.rightCollision = false;
        this.bottomCollision = false;
        this.checkStaticBlockCollision();
        for (Block block : this.b) {
            if (block.x - Block.SIZE >= 0) continue;
            this.leftCollision = true;
            break;
        }
        for (Block block : this.b) {
            if (block.x + Block.SIZE < TetrisScreen.WIDTH) continue;
            this.rightCollision = true;
            break;
        }
        for (Block block : this.b) {
            if (block.y + Block.SIZE < TetrisScreen.HEIGHT) continue;
            this.bottomCollision = true;
            break;
        }
    }

    private void checkStaticBlockCollision() {
        block0: for (Block staticBlock : TetrisScreen.staticBlocks) {
            for (Block block : this.b) {
                if (block.y + Block.SIZE != staticBlock.y || block.x != staticBlock.x) continue;
                this.bottomCollision = true;
                break;
            }
            for (Block block : this.b) {
                if (block.x - Block.SIZE != staticBlock.x || block.y != staticBlock.y) continue;
                this.leftCollision = true;
                break;
            }
            for (Block block : this.b) {
                if (block.x + Block.SIZE != staticBlock.x || block.y != staticBlock.y) continue;
                this.rightCollision = true;
                continue block0;
            }
        }
    }

    protected class_3545<class_2960, class_5250> getRandomBlockTexture() {
        class_310 client = class_310.method_1551();
        ArrayList blocks = new ArrayList(class_7923.field_41175.method_10220().toList());
        Collections.shuffle(blocks);
        for (class_2248 block : blocks) {
            List quads;
            class_2680 blockState = (class_2680)block.method_9595().method_11662().get(TetrisMC.RANDOM.method_43048(block.method_9595().method_11662().size()));
            List parts = client.method_1541().method_3349(blockState).method_68512(TetrisMC.RANDOM);
            if (parts.isEmpty() || (quads = ((class_10889)parts.get(TetrisMC.RANDOM.method_43048(parts.size()))).method_68509(class_2350.method_10162((class_5819)TetrisMC.RANDOM))).isEmpty()) continue;
            class_7764 texture = ((class_777)quads.get(TetrisMC.RANDOM.method_43048(quads.size()))).comp_3724().method_45851();
            int corners = 0;
            if (!texture.method_45810(0, 0, 0)) {
                ++corners;
            }
            if (!texture.method_45810(0, 15, 0)) {
                ++corners;
            }
            if (!texture.method_45810(0, 0, 15)) {
                ++corners;
            }
            if (!texture.method_45810(0, 15, 15)) {
                ++corners;
            }
            if (corners < 3 || texture.method_45807() != 16) continue;
            return new class_3545((Object)texture.method_45816(), (Object)block.method_9518());
        }
        return new class_3545((Object)class_2960.method_60656((String)"block/iron_block"), (Object)class_2246.field_10085.method_9518());
    }

    public void update(float timePassed) {
        boolean proceed;
        this.checkMovementCollision();
        if (TetrisScreen.leftPressed) {
            this.checkMovementCollision();
            if (!this.leftCollision) {
                proceed = true;
                for (Block block : this.b) {
                    for (Block sBlock : TetrisScreen.staticBlocks) {
                        if (block.x - Block.SIZE != sBlock.x || block.y != sBlock.y) continue;
                        proceed = false;
                        break;
                    }
                    if (block.x - Block.SIZE >= 0) continue;
                    proceed = false;
                    break;
                }
                if (proceed) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"block.wooden_button.click_on")), (float)2.0f, (float)this.config.tetris_volume));
                    for (Block block : this.b) {
                        block.x -= Block.SIZE;
                    }
                }
            }
            TetrisScreen.leftPressed = false;
        }
        if (TetrisScreen.rightPressed) {
            this.checkMovementCollision();
            if (!this.rightCollision) {
                proceed = true;
                for (Block block : this.b) {
                    for (Block sBlock : TetrisScreen.staticBlocks) {
                        if (block.x + Block.SIZE != sBlock.x || block.y != sBlock.y) continue;
                        proceed = false;
                        break;
                    }
                    if (block.x + Block.SIZE <= TetrisScreen.WIDTH) continue;
                    proceed = false;
                    break;
                }
                if (proceed) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"block.wooden_button.click_on")), (float)2.0f, (float)this.config.tetris_volume));
                    for (Block block : this.b) {
                        block.x += Block.SIZE;
                    }
                }
            }
            TetrisScreen.rightPressed = false;
        }
        if (TetrisScreen.upPressed) {
            switch (this.direction) {
                case 1: {
                    this.getDirection2();
                    break;
                }
                case 2: {
                    this.getDirection3();
                    break;
                }
                case 3: {
                    this.getDirection4();
                    break;
                }
                case 4: {
                    this.getDirection1();
                }
            }
            TetrisScreen.upPressed = false;
        }
        if (TetrisScreen.downPressed) {
            if (this.bottomCollision) {
                this.dropCounter += 30.0f;
            } else {
                proceed = true;
                block12: for (Block block : this.b) {
                    for (Block b : TetrisScreen.staticBlocks) {
                        if (block.y + Block.SIZE != b.y || block.x != b.x) continue;
                        proceed = false;
                        continue block12;
                    }
                }
                if (proceed) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"block.wooden_button.click_on")), (float)2.0f, (float)this.config.tetris_volume));
                    for (Block block : this.b) {
                        block.y += Block.SIZE;
                    }
                    ++TetrisScreen.score;
                    this.dropCounter = 0.0f;
                }
            }
            TetrisScreen.downPressed = false;
        }
        if (TetrisScreen.spacePressed && TetrisScreen.hardDrop > 0) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60656((String)"entity.wind_charge.wind_burst")), (float)1.0f, (float)(this.config.tetris_volume / 2.0f)));
            int drop = this.getDropOffset();
            TetrisScreen.animations.add(new HardDropAnimation(this.b[0].x, this.b[0].y, 27, drop, 10));
            this.b[0].y += drop;
            this.b[1].y += drop;
            this.b[2].y += drop;
            this.b[3].y += drop;
            TetrisScreen.spacePressed = false;
            this.active = false;
            TetrisScreen.score += 2 * drop / Block.SIZE;
            return;
        }
        this.dropCounter += timePassed;
        if (Math.floor(this.dropCounter) >= (double)TetrisScreen.dropInterval) {
            if (this.bottomCollision) {
                this.checkStaticBlockCollision();
                this.checkMovementCollision();
                if (this.bottomCollision) {
                    this.active = false;
                }
            } else {
                proceed = true;
                block15: for (Block block : this.b) {
                    for (Block b : TetrisScreen.staticBlocks) {
                        if (block.y + Block.SIZE != b.y || block.x != b.x) continue;
                        proceed = false;
                        continue block15;
                    }
                }
                if (proceed) {
                    for (Block block : this.b) {
                        block.y += Block.SIZE;
                    }
                    this.dropCounter = 0.0f;
                }
            }
        }
    }

    public void draw(class_332 context) {
        for (Block block : this.b) {
            block.draw(context);
        }
    }

    public void drawHardDrop(class_332 context) {
        int yOffset = this.getDropOffset();
        Color color = new Color(1.0f, 1.0f, 1.0f, 0.5f);
        block4: for (Block block : this.b) {
            switch (TetrisScreen.hardDrop) {
                case 2: {
                    if (this.getOutline(block)[0]) {
                        context.method_51738(TetrisScreen.left_x + block.x, TetrisScreen.left_x + block.x + Block.SIZE - 1, TetrisScreen.top_y + block.y + yOffset, color.getRGB());
                    }
                    if (this.getOutline(block)[1]) {
                        context.method_51738(TetrisScreen.left_x + block.x, TetrisScreen.left_x + block.x + Block.SIZE - 1, TetrisScreen.top_y + block.y + Block.SIZE - 1 + yOffset, color.getRGB());
                    }
                    if (this.getOutline(block)[2]) {
                        context.method_51742(TetrisScreen.left_x + block.x, TetrisScreen.top_y + block.y + yOffset, TetrisScreen.top_y + block.y + Block.SIZE - 1 + yOffset, color.getRGB());
                        if (!this.getOutline(block)[1]) {
                            context.method_51742(TetrisScreen.left_x + block.x, TetrisScreen.top_y + block.y + Block.SIZE + yOffset - 1, TetrisScreen.top_y + block.y + Block.SIZE + yOffset - 1, color.getRGB());
                        }
                        if (!this.getOutline(block)[0]) {
                            context.method_51742(TetrisScreen.left_x + block.x, TetrisScreen.top_y + block.y + yOffset, TetrisScreen.top_y + block.y + yOffset, color.getRGB());
                        }
                    }
                    if (this.getOutline(block)[3]) {
                        context.method_51742(TetrisScreen.left_x + block.x + Block.SIZE - 1, TetrisScreen.top_y + block.y + yOffset, TetrisScreen.top_y + block.y + Block.SIZE - 1 + yOffset, color.getRGB());
                        if (!this.getOutline(block)[1]) {
                            context.method_51742(TetrisScreen.left_x + block.x + Block.SIZE - 1, TetrisScreen.top_y + block.y + Block.SIZE + yOffset - 1, TetrisScreen.top_y + block.y + Block.SIZE + yOffset - 1, color.getRGB());
                        }
                        if (!this.getOutline(block)[0]) {
                            context.method_51742(TetrisScreen.left_x + block.x + Block.SIZE - 1, TetrisScreen.top_y + block.y + yOffset, TetrisScreen.top_y + block.y + yOffset, color.getRGB());
                        }
                    }
                    if (this instanceof Mino_Square) continue block4;
                    if (!this.getOutline(block)[0] && !this.getOutline(block)[2]) {
                        context.method_51742(TetrisScreen.left_x + block.x, TetrisScreen.top_y + block.y + yOffset, TetrisScreen.top_y + block.y + yOffset, color.getRGB());
                    }
                    if (!this.getOutline(block)[0] && !this.getOutline(block)[3]) {
                        context.method_51742(TetrisScreen.left_x + block.x + Block.SIZE - 1, TetrisScreen.top_y + block.y + yOffset, TetrisScreen.top_y + block.y + yOffset, color.getRGB());
                    }
                    if (!this.getOutline(block)[1] && !this.getOutline(block)[2]) {
                        context.method_51742(TetrisScreen.left_x + block.x, TetrisScreen.top_y + block.y + Block.SIZE + yOffset - 1, TetrisScreen.top_y + block.y + Block.SIZE + yOffset - 1, color.getRGB());
                    }
                    if (this.getOutline(block)[1] || this.getOutline(block)[3]) continue block4;
                    context.method_51742(TetrisScreen.left_x + block.x + Block.SIZE - 1, TetrisScreen.top_y + block.y + Block.SIZE + yOffset - 1, TetrisScreen.top_y + block.y + Block.SIZE + yOffset - 1, color.getRGB());
                    continue block4;
                }
                case 3: {
                    block.draw(context, yOffset);
                }
            }
        }
    }

    private int getDropOffset() {
        int i;
        for (i = 0; i < TetrisScreen.HEIGHT / Block.SIZE; ++i) {
            for (Block b : this.b) {
                for (Block sB : TetrisScreen.staticBlocks) {
                    if (b.x != sB.x || b.y + i * Block.SIZE != sB.y) continue;
                    return i * Block.SIZE - Block.SIZE;
                }
                if (b.y + i * Block.SIZE <= TetrisScreen.HEIGHT - Block.SIZE) continue;
                return i * Block.SIZE - Block.SIZE;
            }
        }
        return i * Block.SIZE - Block.SIZE;
    }

    private boolean[] getOutline(Block b) {
        boolean top = true;
        boolean bottom = true;
        boolean left = true;
        boolean right = true;
        for (Block block : this.b) {
            if (b.y - Block.SIZE == block.y && b.x == block.x) {
                top = false;
            }
            if (b.y + Block.SIZE == block.y && b.x == block.x) {
                bottom = false;
            }
            if (b.x - Block.SIZE == block.x && b.y == block.y) {
                left = false;
            }
            if (b.x + Block.SIZE != block.x || b.y != block.y) continue;
            right = false;
        }
        return new boolean[]{top, bottom, left, right};
    }
}

