/*
 * Decompiled with CFR 0.152.
 */
package dev.quentintyr.visiblearmorslots.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    private Side positioning = Side.LEFT;
    private int marginX = 4;
    private int marginY = 0;
    private boolean enabled = true;
    private boolean showTooltips = true;
    private boolean autoPositioning = true;
    private boolean showOffhandSlot = true;
    private Set<String> allowedContainers = new HashSet<String>();
    private final Set<String> expandedAllowed = new HashSet<String>();
    private static final Map<String, List<String>> BLOCK_TO_HANDLERS = ModConfig.createBlockToHandlerMappings();
    private static final String FILE_NAME = "visiblearmorslots.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ModConfig instance;

    public static ModConfig getInstance() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    private ModConfig() {
        Collections.addAll(this.allowedContainers, "minecraft:crafting_table", "minecraft:anvil", "minecraft:enchanting_table", "minecraft:chest", "minecraft:trapped_chest", "minecraft:barrel", "minecraft:grindstone", "minecraft:smithing_table", "minecraft:shulker_box");
        this.rebuildExpanded();
    }

    public Side getPositioning() {
        return this.positioning;
    }

    public int getMarginX() {
        return this.marginX;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean shouldShowTooltips() {
        return this.showTooltips;
    }

    public boolean isAutoPositioning() {
        return this.autoPositioning;
    }

    public boolean isShowOffhandSlot() {
        return this.showOffhandSlot;
    }

    public Set<String> getAllowedContainers() {
        return Collections.unmodifiableSet(this.allowedContainers);
    }

    public void setPositioning(Side positioning) {
        this.positioning = positioning;
    }

    public void setMarginX(int marginX) {
        this.marginX = Math.max(0, Math.min(128, marginX));
    }

    public void setMarginY(int marginY) {
        this.marginY = Math.max(-64, Math.min(64, marginY));
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setShowTooltips(boolean showTooltips) {
        this.showTooltips = showTooltips;
    }

    public void setAutoPositioning(boolean autoPositioning) {
        this.autoPositioning = autoPositioning;
    }

    public void setShowOffhandSlot(boolean showOffhandSlot) {
        this.showOffhandSlot = showOffhandSlot;
    }

    public boolean isContainerAllowed(class_2960 id) {
        if (this.allowedContainers.isEmpty()) {
            return true;
        }
        return this.allowedContainers.contains(id.toString()) || this.expandedAllowed.contains(id.toString());
    }

    public static void load() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        if (!Files.exists(path, new LinkOption[0])) {
            ModConfig.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) {
                return;
            }
            ModConfig cfg = ModConfig.getInstance();
            if (root.has("enabled")) {
                cfg.enabled = root.get("enabled").getAsBoolean();
            }
            if (root.has("showOffhandSlot")) {
                cfg.showOffhandSlot = root.get("showOffhandSlot").getAsBoolean();
            }
            if (root.has("showTooltips")) {
                cfg.showTooltips = root.get("showTooltips").getAsBoolean();
            }
            if (root.has("autoPositioning")) {
                cfg.autoPositioning = root.get("autoPositioning").getAsBoolean();
            }
            if (root.has("positioning")) {
                try {
                    cfg.positioning = Side.valueOf(root.get("positioning").getAsString().toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (root.has("marginX")) {
                cfg.marginX = root.get("marginX").getAsInt();
            }
            if (root.has("marginY")) {
                cfg.marginY = root.get("marginY").getAsInt();
            }
            if (root.has("allowedContainers")) {
                cfg.allowedContainers.clear();
                JsonArray arr = root.getAsJsonArray("allowedContainers");
                arr.forEach(e -> cfg.allowedContainers.add(e.getAsString()));
            }
            cfg.rebuildExpanded();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void save() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        JsonObject root = new JsonObject();
        ModConfig cfg = ModConfig.getInstance();
        root.addProperty("enabled", Boolean.valueOf(cfg.enabled));
        root.addProperty("showOffhandSlot", Boolean.valueOf(cfg.showOffhandSlot));
        root.addProperty("showTooltips", Boolean.valueOf(cfg.showTooltips));
        root.addProperty("autoPositioning", Boolean.valueOf(cfg.autoPositioning));
        root.addProperty("positioning", cfg.positioning.name());
        root.addProperty("marginX", (Number)cfg.marginX);
        root.addProperty("marginY", (Number)cfg.marginY);
        JsonArray arr = new JsonArray();
        cfg.allowedContainers.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
        root.add("allowedContainers", (JsonElement)arr);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson((JsonElement)root, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Map<String, List<String>> createBlockToHandlerMappings() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("minecraft:crafting_table", List.of("minecraft:crafting"));
        map.put("minecraft:enchanting_table", List.of("minecraft:enchantment"));
        map.put("minecraft:smithing_table", List.of("minecraft:smithing"));
        map.put("minecraft:cartography_table", List.of("minecraft:cartography"));
        map.put("minecraft:stonecutter", List.of("minecraft:stonecutter"));
        map.put("minecraft:grindstone", List.of("minecraft:grindstone"));
        map.put("minecraft:loom", List.of("minecraft:loom"));
        map.put("minecraft:brewing_stand", List.of("minecraft:brewing_stand"));
        map.put("minecraft:hopper", List.of("minecraft:hopper"));
        map.put("minecraft:furnace", List.of("minecraft:furnace"));
        map.put("minecraft:blast_furnace", List.of("minecraft:blast_furnace"));
        map.put("minecraft:smoker", List.of("minecraft:smoker"));
        map.put("minecraft:anvil", List.of("minecraft:anvil"));
        map.put("minecraft:shulker_box", List.of("minecraft:shulker_box"));
        map.put("minecraft:chest", List.of("minecraft:generic_9x3", "minecraft:generic_9x6"));
        map.put("minecraft:trapped_chest", List.of("minecraft:generic_9x3", "minecraft:generic_9x6"));
        map.put("minecraft:barrel", List.of("minecraft:generic_9x3"));
        return map;
    }

    private void rebuildExpanded() {
        this.expandedAllowed.clear();
        for (String raw : this.allowedContainers) {
            this.expandedAllowed.add(raw);
            List<String> mapped = BLOCK_TO_HANDLERS.get(raw);
            if (mapped == null) continue;
            this.expandedAllowed.addAll(mapped);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Side {
        LEFT,
        RIGHT;

    }
}

