/*
 * Decompiled with CFR 0.152.
 */
package dev.quentintyr.visiblearmorslots.gui;

import dev.quentintyr.visiblearmorslots.action.ActionType;
import dev.quentintyr.visiblearmorslots.config.ModConfig;
import dev.quentintyr.visiblearmorslots.gui.SlotInfo;
import dev.quentintyr.visiblearmorslots.gui.widget.ArmorSlotWidget;
import dev.quentintyr.visiblearmorslots.gui.widget.OffhandSlotWidget;
import dev.quentintyr.visiblearmorslots.mixin.client.HandledScreenAccessor;
import dev.quentintyr.visiblearmorslots.network.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ArmorSlotsOverlay {
    private static final class_2960 COLUMN_TEXTURE_FULL = new class_2960("visiblearmorslots", "textures/gui/extra-slots.png");
    private static final class_2960 COLUMN_TEXTURE_COMPACT = new class_2960("visiblearmorslots", "textures/gui/extra-slots-no-second-hand.png");
    private final List<ArmorSlotWidget> armorSlots = new ArrayList<ArmorSlotWidget>();
    private OffhandSlotWidget offhandSlot;
    private int baseX;
    private int baseY;
    private int columnHeight = 100;
    private boolean visible = false;

    public int getBaseX() {
        return this.baseX;
    }

    public int getBaseY() {
        return this.baseY;
    }

    public void initialize(class_465<?> screen) {
        if (!ModConfig.getInstance().isEnabled()) {
            this.visible = false;
            return;
        }
        if (screen instanceof class_490) {
            this.visible = false;
            return;
        }
        try {
            class_3917 type = screen.method_17577().method_17358();
            class_2960 handlerId = class_7923.field_41187.method_10221((Object)type);
            if (handlerId != null && !ModConfig.getInstance().isContainerAllowed(handlerId)) {
                this.visible = false;
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.visible = true;
        this.columnHeight = ModConfig.getInstance().isShowOffhandSlot() ? 100 : 78;
        this.calculatePosition(screen);
        this.createSlots();
    }

    private void calculatePosition(class_465<?> screen) {
        HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
        int screenLeft = accessor.getX();
        int screenTop = accessor.getY();
        int screenHeight = accessor.getBackgroundHeight();
        ModConfig config = ModConfig.getInstance();
        if (config.getPositioning() == ModConfig.Side.RIGHT) {
            this.baseX = screenLeft + accessor.getBackgroundWidth() + config.getMarginX();
        } else {
            this.baseX = screenLeft - 28 - config.getMarginX();
            if (config.isAutoPositioning()) {
                class_310 mc = class_310.method_1551();
                class_746 player = mc.field_1724;
                if (player != null && player.method_6059(class_1294.field_5924)) {
                    this.baseX -= 24;
                }
            }
        }
        this.baseY = screenTop + screenHeight - (this.columnHeight + 4) + config.getMarginY();
    }

    private void createSlots() {
        this.armorSlots.clear();
        int itemX = this.baseX + 4;
        this.armorSlots.add(new ArmorSlotWidget(SlotInfo.SlotType.HELMET, itemX, this.baseY + 4));
        this.armorSlots.add(new ArmorSlotWidget(SlotInfo.SlotType.CHESTPLATE, itemX, this.baseY + 22));
        this.armorSlots.add(new ArmorSlotWidget(SlotInfo.SlotType.LEGGINGS, itemX, this.baseY + 40));
        this.armorSlots.add(new ArmorSlotWidget(SlotInfo.SlotType.BOOTS, itemX, this.baseY + 58));
        this.offhandSlot = ModConfig.getInstance().isShowOffhandSlot() ? new OffhandSlotWidget(itemX, this.baseY + 80) : null;
    }

    public void render(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1661 inventory = player.method_31548();
        boolean offhandShown = this.offhandSlot != null;
        class_2960 tex = offhandShown ? COLUMN_TEXTURE_FULL : COLUMN_TEXTURE_COMPACT;
        int texHeight = offhandShown ? 100 : 78;
        drawContext.method_25290(tex, this.baseX, this.baseY, 0.0f, 0.0f, 24, texHeight, 24, texHeight);
        for (int i = 0; i < this.armorSlots.size(); ++i) {
            ArmorSlotWidget slot = this.armorSlots.get(i);
            class_1799 stack = inventory.method_7372(3 - i);
            slot.render(drawContext, stack, mouseX, mouseY);
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            drawContext.method_25294(slot.getX(), slot.getY(), slot.getX() + 16, slot.getY() + 16, -2130706433);
        }
        if (this.offhandSlot != null) {
            class_1799 offhandStack = player.method_6079();
            this.offhandSlot.render(drawContext, offhandStack, mouseX, mouseY);
            if (this.offhandSlot.isMouseOver(mouseX, mouseY)) {
                drawContext.method_25294(this.offhandSlot.getX(), this.offhandSlot.getY(), this.offhandSlot.getX() + 16, this.offhandSlot.getY() + 16, -2130706433);
            }
        }
    }

    public void renderTooltips(class_332 drawContext, int mouseX, int mouseY) {
        if (!this.visible || !ModConfig.getInstance().shouldShowTooltips()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < this.armorSlots.size(); ++i) {
            ArmorSlotWidget slot = this.armorSlots.get(i);
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            class_1799 stack = inventory.method_7372(3 - i);
            if (!stack.method_7960()) {
                drawContext.method_51446(mc.field_1772, stack, mouseX, mouseY);
            } else {
                class_5250 tooltip = class_2561.method_43471((String)("gui.visiblearmorslots.empty." + slot.getSlotType().name().toLowerCase()));
                drawContext.method_51438(mc.field_1772, (class_2561)tooltip, mouseX, mouseY);
            }
            return;
        }
        if (this.offhandSlot != null && this.offhandSlot.isMouseOver(mouseX, mouseY)) {
            class_1799 offhandStack = player.method_6079();
            if (!offhandStack.method_7960()) {
                drawContext.method_51446(mc.field_1772, offhandStack, mouseX, mouseY);
            } else {
                class_5250 tooltip = class_2561.method_43471((String)"gui.visiblearmorslots.empty.offhand");
                drawContext.method_51438(mc.field_1772, (class_2561)tooltip, mouseX, mouseY);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        for (ArmorSlotWidget slot : this.armorSlots) {
            if (!slot.isMouseOver((int)mouseX, (int)mouseY)) continue;
            this.handleSlotClick(slot.getSlotType(), button, mc);
            return true;
        }
        if (this.offhandSlot != null && this.offhandSlot.isMouseOver((int)mouseX, (int)mouseY)) {
            this.handleSlotClick(SlotInfo.SlotType.OFFHAND, button, mc);
            return true;
        }
        return mouseX >= (double)this.baseX && mouseX < (double)(this.baseX + 24) && mouseY >= (double)this.baseY && mouseY < (double)(this.baseY + this.columnHeight);
    }

    private void handleSlotClick(SlotInfo.SlotType slotType, int button, class_310 mc) {
        ActionType actionType;
        if (mc.field_1724 == null || mc.field_1755 == null) {
            return;
        }
        boolean isShiftPressed = class_437.method_25442();
        boolean isCtrlPressed = class_437.method_25441();
        System.out.println("handleSlotClick: slot=" + String.valueOf((Object)slotType) + ", button=" + button + ", shift=" + isShiftPressed + ", ctrl=" + isCtrlPressed);
        if (isShiftPressed) {
            actionType = ActionType.QUICK_TRANSFER;
            System.out.println("SHIFT-CLICK detected for slot: " + String.valueOf((Object)slotType));
        } else {
            actionType = ActionType.MOUSE_SWAP;
            System.out.println("Normal click for slot: " + String.valueOf((Object)slotType));
        }
        ClientPlayNetworking.send((class_2960)NetworkManager.SLOT_ACTION_PACKET_ID, (class_2540)this.createPacketByteBuf(actionType, slotType.getEquipmentSlot(), -1, isShiftPressed, isCtrlPressed, mc.field_1724 != null && mc.field_1724.method_31549().field_7477));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.visible) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (keyCode == 81) {
            double mouseX = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
            double mouseY = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
            for (ArmorSlotWidget slot : this.armorSlots) {
                if (!slot.isMouseOver((int)mouseX, (int)mouseY)) continue;
                System.out.println("DROP requested for slot: " + String.valueOf((Object)slot.getSlotType()));
                ClientPlayNetworking.send((class_2960)NetworkManager.SLOT_ACTION_PACKET_ID, (class_2540)this.createPacketByteBuf(ActionType.DROP, slot.getSlotType().getEquipmentSlot(), -1, false, false, mc.field_1724 != null && mc.field_1724.method_31549().field_7477));
                return true;
            }
            if (this.offhandSlot != null && this.offhandSlot.isMouseOver((int)mouseX, (int)mouseY)) {
                System.out.println("DROP requested for offhand slot");
                ClientPlayNetworking.send((class_2960)NetworkManager.SLOT_ACTION_PACKET_ID, (class_2540)this.createPacketByteBuf(ActionType.DROP, SlotInfo.SlotType.OFFHAND.getEquipmentSlot(), -1, false, false, mc.field_1724 != null && mc.field_1724.method_31549().field_7477));
                return true;
            }
        }
        if (keyCode >= 49 && keyCode <= 57) {
            int hotbarSlot = keyCode - 49;
            double mouseX = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
            double mouseY = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
            for (ArmorSlotWidget slot : this.armorSlots) {
                if (!slot.isMouseOver((int)mouseX, (int)mouseY)) continue;
                System.out.println("HOTBAR SWAP requested: " + String.valueOf((Object)slot.getSlotType()) + " <-> hotbar slot " + (hotbarSlot + 1));
                ClientPlayNetworking.send((class_2960)NetworkManager.SLOT_ACTION_PACKET_ID, (class_2540)this.createPacketByteBuf(ActionType.HOTBAR_SWAP, slot.getSlotType().getEquipmentSlot(), hotbarSlot, false, false, mc.field_1724 != null && mc.field_1724.method_31549().field_7477));
                return true;
            }
            if (this.offhandSlot != null && this.offhandSlot.isMouseOver((int)mouseX, (int)mouseY)) {
                System.out.println("HOTBAR SWAP requested: OFFHAND <-> hotbar slot " + (hotbarSlot + 1));
                ClientPlayNetworking.send((class_2960)NetworkManager.SLOT_ACTION_PACKET_ID, (class_2540)this.createPacketByteBuf(ActionType.HOTBAR_SWAP, SlotInfo.SlotType.OFFHAND.getEquipmentSlot(), hotbarSlot, false, false, mc.field_1724 != null && mc.field_1724.method_31549().field_7477));
                return true;
            }
        }
        if (keyCode == 70 && this.offhandSlot != null) {
            ClientPlayNetworking.send((class_2960)NetworkManager.SLOT_ACTION_PACKET_ID, (class_2540)this.createPacketByteBuf(ActionType.OFFHAND_SWAP, SlotInfo.SlotType.OFFHAND.getEquipmentSlot(), -1, false, false, mc.field_1724 != null && mc.field_1724.method_31549().field_7477));
            return true;
        }
        return false;
    }

    private class_2540 createPacketByteBuf(ActionType actionType, class_1304 targetSlot, int hotbarSlot, boolean isShiftPressed, boolean isCtrlPressed, boolean isCreativeMode) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10817((Enum)actionType);
        buf.writeBoolean(targetSlot != null);
        if (targetSlot != null) {
            buf.method_10817((Enum)targetSlot);
        }
        buf.method_10804(hotbarSlot);
        buf.writeBoolean(isShiftPressed);
        buf.writeBoolean(isCtrlPressed);
        buf.writeBoolean(isCreativeMode);
        return buf;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

