/*
 * Decompiled with CFR 0.152.
 */
package dev.quentintyr.visiblearmorslots.gui.widget;

import dev.quentintyr.visiblearmorslots.gui.SlotInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ArmorSlotWidget {
    private final SlotInfo.SlotType slotType;
    private final int x;
    private final int y;
    private static final class_2960 EMPTY_HELMET_SLOT = new class_2960("minecraft", "textures/item/empty_armor_slot_helmet.png");
    private static final class_2960 EMPTY_CHEST_SLOT = new class_2960("minecraft", "textures/item/empty_armor_slot_chestplate.png");
    private static final class_2960 EMPTY_LEGS_SLOT = new class_2960("minecraft", "textures/item/empty_armor_slot_leggings.png");
    private static final class_2960 EMPTY_BOOTS_SLOT = new class_2960("minecraft", "textures/item/empty_armor_slot_boots.png");

    public ArmorSlotWidget(SlotInfo.SlotType slotType, int x, int y) {
        this.slotType = slotType;
        this.x = x;
        this.y = y;
    }

    public void render(class_332 context, class_1799 stack, int mouseX, int mouseY) {
        if (stack.method_7960()) {
            class_2960 emptyTexture = this.getEmptySlotTexture();
            context.method_25290(emptyTexture, this.x, this.y, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            context.method_51427(stack, this.x, this.y);
            context.method_51431(class_310.method_1551().field_1772, stack, this.x, this.y);
        }
    }

    public boolean canAcceptItem(class_1799 stack) {
        if (stack.method_7960()) {
            return true;
        }
        class_1792 item = stack.method_7909();
        if (!(item instanceof class_1738)) {
            return false;
        }
        class_1738 armorItem = (class_1738)item;
        class_1304 itemSlot = armorItem.method_7685();
        return itemSlot == this.slotType.getEquipmentSlot();
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + 16 && mouseY >= this.y && mouseY < this.y + 16;
    }

    private class_2960 getEmptySlotTexture() {
        return switch (this.slotType) {
            case SlotInfo.SlotType.HELMET -> EMPTY_HELMET_SLOT;
            case SlotInfo.SlotType.CHESTPLATE -> EMPTY_CHEST_SLOT;
            case SlotInfo.SlotType.LEGGINGS -> EMPTY_LEGS_SLOT;
            case SlotInfo.SlotType.BOOTS -> EMPTY_BOOTS_SLOT;
            default -> EMPTY_HELMET_SLOT;
        };
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public SlotInfo.SlotType getSlotType() {
        return this.slotType;
    }
}

