/*
 * Decompiled with CFR 0.152.
 */
package net.zenithm.cyclopsmod.entity.custom;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.IntFunction;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1670;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7995;
import net.minecraft.class_9109;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;

public class CyclopsMageEntity
extends class_1588 {
    public int spellTicks;
    private Spell spell = Spell.NONE;
    private static final class_2940<Byte> SPELL = class_2945.method_12791(CyclopsMageEntity.class, (class_2941)class_2943.field_13319);
    private static final class_9109 PROJECTILE_DEFLECTOR = (projectile, hitEntity, random) -> {
        hitEntity.method_73183().method_43129(null, hitEntity, class_3417.field_47725, hitEntity.method_5634(), 1.0f, 1.0f);
        class_9109.field_51510.deflect(projectile, hitEntity, random);
    };

    public CyclopsMageEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public boolean method_6049(class_1293 effect) {
        if (effect.method_55654(class_1294.field_5899)) {
            return false;
        }
        return super.method_6049(effect);
    }

    protected void method_48565(float v) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.0f, 0.2f);
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
        this.field_6011.method_12778(SPELL, (Object)((byte)spell.id));
    }

    protected Spell getSpell() {
        if (!this.method_73183().method_8608()) {
            return this.spell;
        }
        return Spell.byId(((Byte)this.field_6011.method_12789(SPELL)).byteValue());
    }

    protected void method_5958(class_3218 world) {
        super.method_5958(world);
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8608() && this.isSpellcasting()) {
            Spell spell = this.getSpell();
            float f = (float)spell.particleVelocity[0];
            float g = (float)spell.particleVelocity[1];
            float h = (float)spell.particleVelocity[2];
            float i = this.field_6283 * ((float)Math.PI / 180) + class_3532.method_15362((float)((float)this.field_6012 * 0.6662f)) * 0.25f;
            float j = class_3532.method_15362((float)i);
            float k = class_3532.method_15374((float)i);
            double d = 1.2 * (double)this.method_55693();
            double e = 3.0 * (double)this.method_55693();
            this.method_73183().method_8406((class_2394)class_9381.method_58255((class_2396)class_2398.field_11226, (float)f, (float)g, (float)h), this.method_23317() + (double)j * d, this.method_23318() + e, this.method_23321() + (double)k * d, 0.0, 0.0, 0.0);
            this.method_73183().method_8406((class_2394)class_9381.method_58255((class_2396)class_2398.field_11226, (float)f, (float)g, (float)h), this.method_23317() - (double)j * d, this.method_23318() + e, this.method_23321() - (double)k * d, 0.0, 0.0, 0.0);
        }
    }

    public State getState() {
        if (this.isSpellcasting()) {
            return State.SPELLCASTING;
        }
        if (this.canHeal()) {
            return State.HEALING;
        }
        return State.CROSSED;
    }

    public boolean isSpellcasting() {
        if (this.method_73183().method_8608() && !this.canHeal()) {
            return (Byte)this.field_6011.method_12789(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public boolean canHeal() {
        return this.method_6032() <= 22.0f && !this.method_6059(class_1294.field_5924);
    }

    public class_9109 method_56071(class_1676 projectile) {
        return class_9109.field_51509;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new LookAtTargetGoal());
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1657.class, 8.0f, 0.6, 1.0));
        this.field_6201.method_6277(3, (class_1352)new CyclopsMageHealGoal(this, this));
        this.field_6201.method_6277(5, (class_1352)new CyclopsMageSummonEndermanGoal(this, this));
        this.field_6201.method_6277(6, (class_1352)new LevitateTargetGoal(this, this));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.6));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public void method_6078(class_1282 damageSource) {
        class_1937 world;
        class_1309 target = this.method_49107();
        if (target != null && !(world = target.method_73183()).method_8608()) {
            for (int i = 0; i < 20; ++i) {
                world.method_43128(null, target.method_23317(), target.method_23318(), target.method_23321(), class_3417.field_14970, class_3419.field_15254, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
                class_1670 arrow = new class_1670(class_1299.field_6129, world);
                arrow.method_5814(target.method_23317() + (double)target.method_59922().method_39332(-10, 10), target.method_23318() + (double)target.method_59922().method_39332(20, 50), target.method_23321() + (double)target.method_59922().method_39332(-10, 10));
                arrow.method_60491(new class_243(0.0, -1.0, 0.0));
                target.method_73183().method_8649((class_1297)arrow);
            }
        }
        super.method_6078(damageSource);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPELL, (Object)0);
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        this.spellTicks = nbt.method_71424("SpellTicks", 0);
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71465("Persistent", 1);
        nbt.method_71465("SpellTicks", this.spellTicks);
    }

    public static class_5132.class_5133 createCyclopsMageAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23717, 12.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 1.0);
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected class_3414 getCastSpellSound() {
        return class_3417.field_14858;
    }

    protected static enum Spell {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_ENDERMAN(1, 0.7, 0.7, 0.8),
        LEVITATE(2, 0.4, 0.4, 0.4);

        private static final IntFunction<Spell> BY_ID;
        final int id;
        final double[] particleVelocity;

        private Spell(int id, double particleVelocityX, double particleVelocityY, double particleVelocityZ) {
            this.id = id;
            this.particleVelocity = new double[]{particleVelocityX, particleVelocityY, particleVelocityZ};
        }

        public static Spell byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = class_7995.method_47914(spell -> spell.id, (Object[])Spell.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        }
    }

    public static enum State {
        SPELLCASTING,
        HEALING,
        CROSSED;

    }

    protected class LookAtTargetGoal
    extends class_1352 {
        public LookAtTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return CyclopsMageEntity.this.getSpellTicks() > 0;
        }

        public void method_6269() {
            super.method_6269();
            CyclopsMageEntity.this.field_6189.method_6340();
        }

        public void method_6270() {
            super.method_6270();
            CyclopsMageEntity.this.setSpell(Spell.NONE);
        }

        public void method_6268() {
            if (CyclopsMageEntity.this.method_5968() != null) {
                CyclopsMageEntity.this.method_5988().method_6226((class_1297)CyclopsMageEntity.this.method_5968(), (float)CyclopsMageEntity.this.method_5986(), (float)CyclopsMageEntity.this.method_5978());
            }
        }
    }

    protected class CyclopsMageHealGoal
    extends class_1352 {
        protected int drinkingTicks;
        class_3414 sound = (class_3414)class_3417.field_20613.comp_349();
        private final CyclopsMageEntity entity;

        public CyclopsMageHealGoal(CyclopsMageEntity this$0, CyclopsMageEntity entity) {
            this.entity = entity;
        }

        public boolean method_6264() {
            return this.entity.canHeal();
        }

        public boolean method_6266() {
            return this.entity.canHeal();
        }

        public void method_6269() {
            this.drinkingTicks = 9;
            this.entity.method_5783(this.sound, 1.0f, 1.0f);
            this.entity.method_5673(class_1304.field_6173, class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8980));
        }

        public void method_6268() {
            --this.drinkingTicks;
            if (this.drinkingTicks == 6 || this.drinkingTicks == 3) {
                this.entity.method_56078(this.sound);
            }
            if (this.drinkingTicks <= 0) {
                this.entity.method_6033(this.entity.method_6032() + 17.0f);
                this.entity.method_5673(class_1304.field_6173, class_1799.field_8037);
            }
        }
    }

    protected class CyclopsMageSummonEndermanGoal
    extends CastSpellGoal {
        private final CyclopsMageEntity entity;
        Random random = new Random();

        public CyclopsMageSummonEndermanGoal(CyclopsMageEntity this$0, CyclopsMageEntity entity) {
            super(this$0, entity);
            this.entity = entity;
        }

        @Override
        public boolean method_6264() {
            return super.method_6264();
        }

        @Override
        protected int getSpellTicks() {
            return 25;
        }

        @Override
        protected int startTimeDelay() {
            return 340;
        }

        @Override
        protected void castSpell() {
            class_3218 serverWorld = (class_3218)this.entity.method_73183();
            class_268 team = this.entity.method_5781();
            for (int i = 0; i < 3; ++i) {
                class_2338 blockPos = this.entity.method_24515().method_10069(-2 + this.random.nextInt(5), 1, -2 + this.random.nextInt(5));
                class_1560 vexEntity = (class_1560)class_1299.field_6091.method_5883(this.entity.method_73183(), class_3730.field_16471);
                if (vexEntity == null) continue;
                vexEntity.method_5725(blockPos, 0.0f, 0.0f);
                vexEntity.method_5943((class_5425)serverWorld, this.entity.method_73183().method_8404(blockPos), class_3730.field_16471, null);
                vexEntity.method_5980(this.entity.method_5968());
                if (team != null) {
                    serverWorld.method_14170().method_1172(vexEntity.method_5820(), team);
                }
                serverWorld.method_30771((class_1297)vexEntity);
                serverWorld.method_43276((class_6880)class_5712.field_28738, blockPos, class_5712.class_7397.method_43285((class_1297)this.entity));
            }
        }

        @Override
        protected class_3414 getSoundPrepare() {
            return class_3417.field_15193;
        }

        @Override
        protected Spell getSpell() {
            return Spell.SUMMON_ENDERMAN;
        }
    }

    protected class LevitateTargetGoal
    extends CastSpellGoal {
        CyclopsMageEntity entity;

        public LevitateTargetGoal(CyclopsMageEntity this$0, CyclopsMageEntity entity) {
            super(this$0, entity);
            this.entity = entity;
        }

        @Override
        public boolean method_6264() {
            return super.method_6264();
        }

        @Override
        protected int getSpellTicks() {
            return 20;
        }

        @Override
        protected int startTimeDelay() {
            return 340;
        }

        @Override
        @Nullable
        protected class_3414 getSoundPrepare() {
            return null;
        }

        @Override
        protected Spell getSpell() {
            return Spell.LEVITATE;
        }

        @Override
        protected void castSpell() {
            class_1309 livingEntity = this.entity.method_5968();
            if (livingEntity != null) {
                livingEntity.method_6092(new class_1293(class_1294.field_5902, 10, 50));
                livingEntity.method_6092(new class_1293(class_1294.field_5919, 40, 5));
            }
        }
    }

    protected abstract class CastSpellGoal
    extends class_1352 {
        protected int spellCooldown;
        protected int startTime;
        private final CyclopsMageEntity entity;

        protected CastSpellGoal(CyclopsMageEntity this$0, CyclopsMageEntity entity) {
            this.entity = entity;
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.entity.method_5968();
            if (livingEntity == null || !livingEntity.method_5805()) {
                return false;
            }
            if (this.entity.isSpellcasting()) {
                return false;
            }
            return this.entity.field_6012 >= this.startTime;
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.entity.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.spellCooldown > 0;
        }

        public void method_6269() {
            this.spellCooldown = this.method_38847(this.getInitialCooldown());
            this.entity.spellTicks = this.getSpellTicks();
            this.startTime = this.entity.field_6012 + this.startTimeDelay();
            class_3414 soundEvent = this.getSoundPrepare();
            if (soundEvent != null) {
                this.entity.method_5783(soundEvent, 1.0f, 1.0f);
            }
            this.entity.setSpell(this.getSpell());
        }

        public void method_6268() {
            --this.spellCooldown;
            if (this.spellCooldown == 0) {
                this.castSpell();
                this.entity.method_5783(class_3417.field_14858, 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getInitialCooldown() {
            return 20;
        }

        protected abstract int getSpellTicks();

        protected abstract int startTimeDelay();

        @Nullable
        protected abstract class_3414 getSoundPrepare();

        protected abstract Spell getSpell();
    }
}

