/*
 * Decompiled with CFR 0.152.
 */
package net.zenithm.cyclopsmod.item;

import java.util.Optional;
import net.minecraft.class_10712;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import net.zenithm.cyclopsmod.item.component.LargeBundleContentsComponent;
import net.zenithm.cyclopsmod.item.component.LargeBundleTooltipData;
import net.zenithm.cyclopsmod.registry.savage_cyclopes.SavageCyclopesMiscStuff;
import org.apache.commons.lang3.math.Fraction;

public class LargeBundleItem
extends class_1792 {
    public static final int TOOLTIP_STACKS_COLUMNS = 4;
    public static final int TOOLTIP_STACKS_ROWS = 3;
    public static final int MAX_TOOLTIP_STACKS_SHOWN = 12;
    public static final int MAX_TOOLTIP_STACKS_SHOWN_WHEN_TOO_MANY_TYPES = 11;
    private static final int FULL_ITEM_BAR_COLOR = class_9848.method_61318((float)1.0f, (float)1.0f, (float)0.33f, (float)0.33f);
    private static final int ITEM_BAR_COLOR = class_9848.method_61318((float)1.0f, (float)0.44f, (float)0.53f, (float)1.0f);
    private static final int field_54109 = 10;
    private static final int field_54110 = 2;
    private static final int MAX_USE_TIME = 200;

    public LargeBundleItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static float getAmountFilled(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58695(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)LargeBundleContentsComponent.DEFAULT);
        return bundleContentsComponent.getOccupancy().floatValue();
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS);
        if (bundleContentsComponent == null) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        LargeBundleContentsComponent.Builder builder = new LargeBundleContentsComponent.Builder(bundleContentsComponent);
        if (clickType == class_5536.field_27013 && !itemStack.method_7960()) {
            if (builder.add(slot, player) > 0) {
                LargeBundleItem.playInsertSound((class_1297)player);
            } else {
                LargeBundleItem.playInsertFailSound((class_1297)player);
            }
            stack.method_57379(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)builder.build());
            this.onContentChanged(player);
            return true;
        }
        if (clickType == class_5536.field_27014 && itemStack.method_7960()) {
            class_1799 itemStack2 = builder.removeSelected();
            if (itemStack2 != null) {
                class_1799 itemStack3 = slot.method_32756(itemStack2);
                if (itemStack3.method_7947() > 0) {
                    builder.add(itemStack3);
                } else {
                    LargeBundleItem.playRemoveOneSound((class_1297)player);
                }
            }
            stack.method_57379(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)builder.build());
            this.onContentChanged(player);
            return true;
        }
        return false;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27013 && otherStack.method_7960()) {
            LargeBundleItem.setSelectedStackIndex(stack, -1);
            return false;
        }
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS);
        if (bundleContentsComponent == null) {
            return false;
        }
        LargeBundleContentsComponent.Builder builder = new LargeBundleContentsComponent.Builder(bundleContentsComponent);
        if (clickType == class_5536.field_27013 && !otherStack.method_7960()) {
            if (slot.method_32754(player) && builder.add(otherStack) > 0) {
                LargeBundleItem.playInsertSound((class_1297)player);
            } else {
                LargeBundleItem.playInsertFailSound((class_1297)player);
            }
            stack.method_57379(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)builder.build());
            this.onContentChanged(player);
            return true;
        }
        if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
            class_1799 itemStack;
            if (slot.method_32754(player) && (itemStack = builder.removeSelected()) != null) {
                LargeBundleItem.playRemoveOneSound((class_1297)player);
                cursorStackReference.method_32332(itemStack);
            }
            stack.method_57379(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)builder.build());
            this.onContentChanged(player);
            return true;
        }
        LargeBundleItem.setSelectedStackIndex(stack, -1);
        return false;
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        return class_1269.field_5812;
    }

    private void dropContentsOnUse(class_1937 world, class_1657 player, class_1799 stack) {
        if (this.dropFirstBundledStack(stack, player)) {
            LargeBundleItem.playDropContentsSound(world, (class_1297)player);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
    }

    public boolean method_31567(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58695(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)LargeBundleContentsComponent.DEFAULT);
        return bundleContentsComponent.getOccupancy().compareTo(Fraction.ZERO) > 0;
    }

    public int method_31569(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58695(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)LargeBundleContentsComponent.DEFAULT);
        return Math.min(1 + class_3532.method_59515((Fraction)bundleContentsComponent.getOccupancy(), (int)12), 13);
    }

    public int method_31571(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58695(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)LargeBundleContentsComponent.DEFAULT);
        return bundleContentsComponent.getOccupancy().compareTo(Fraction.ONE) >= 0 ? FULL_ITEM_BAR_COLOR : ITEM_BAR_COLOR;
    }

    public static void setSelectedStackIndex(class_1799 stack, int selectedStackIndex) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS);
        if (bundleContentsComponent != null) {
            LargeBundleContentsComponent.Builder builder = new LargeBundleContentsComponent.Builder(bundleContentsComponent);
            builder.setSelectedStackIndex(selectedStackIndex);
            stack.method_57379(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)builder.build());
        }
    }

    public static boolean hasSelectedStack(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS);
        return bundleContentsComponent != null && bundleContentsComponent.getSelectedStackIndex() != -1;
    }

    public static int getSelectedStackIndex(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58695(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)LargeBundleContentsComponent.DEFAULT);
        return bundleContentsComponent.getSelectedStackIndex();
    }

    public static class_1799 getSelectedStack(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS);
        return bundleContentsComponent != null && bundleContentsComponent.getSelectedStackIndex() != -1 ? bundleContentsComponent.get(bundleContentsComponent.getSelectedStackIndex()) : class_1799.field_8037;
    }

    public static int getNumberOfStacksShown(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58695(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)LargeBundleContentsComponent.DEFAULT);
        return bundleContentsComponent.getNumberOfStacksShown();
    }

    private boolean dropFirstBundledStack(class_1799 stack, class_1657 player) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS);
        if (bundleContentsComponent != null && !bundleContentsComponent.isEmpty()) {
            Optional<class_1799> optional = LargeBundleItem.popFirstBundledStack(stack, player, bundleContentsComponent);
            if (optional.isPresent()) {
                player.method_7328(optional.get(), true);
                return true;
            }
            return false;
        }
        return false;
    }

    private static Optional<class_1799> popFirstBundledStack(class_1799 stack, class_1657 player, LargeBundleContentsComponent contents) {
        LargeBundleContentsComponent.Builder builder = new LargeBundleContentsComponent.Builder(contents);
        class_1799 itemStack = builder.removeSelected();
        if (itemStack != null) {
            LargeBundleItem.playRemoveOneSound((class_1297)player);
            stack.method_57379(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)builder.build());
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (user instanceof class_1657) {
            boolean bl;
            class_1657 playerEntity = (class_1657)user;
            int i = this.method_7881(stack, user);
            boolean bl2 = bl = remainingUseTicks == i;
            if (bl || remainingUseTicks < i - 10 && remainingUseTicks % 2 == 0) {
                this.dropContentsOnUse(world, playerEntity, stack);
            }
        }
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 200;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_55494;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_10712 tooltipDisplayComponent = (class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
        return !tooltipDisplayComponent.method_67214(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS) ? Optional.empty() : Optional.ofNullable((LargeBundleContentsComponent)stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS)).map(LargeBundleTooltipData::new);
    }

    public void method_33261(class_1542 entity) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)entity.method_6983().method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS);
        if (bundleContentsComponent != null) {
            entity.method_6983().method_57379(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS, (Object)LargeBundleContentsComponent.DEFAULT);
            class_5328.method_33263((class_1542)entity, bundleContentsComponent.iterateCopy());
        }
    }

    private static void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_73183().method_8409().method_43057() * 0.4f);
    }

    private static void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_73183().method_8409().method_43057() * 0.4f);
    }

    private static void playInsertFailSound(class_1297 entity) {
        entity.method_5783(class_3417.field_52372, 1.0f, 1.0f);
    }

    private static void playDropContentsSound(class_1937 world, class_1297 entity) {
        world.method_8396(null, entity.method_24515(), class_3417.field_34375, class_3419.field_15248, 0.8f, 0.8f + entity.method_73183().method_8409().method_43057() * 0.4f);
    }

    private void onContentChanged(class_1657 user) {
        class_1703 screenHandler = user.field_7512;
        if (screenHandler != null) {
            screenHandler.method_7609((class_1263)user.method_31548());
        }
    }
}

