/*
 * Decompiled with CFR 0.152.
 */
package net.zenithm.cyclopsmod.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_10706;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.zenithm.cyclopsmod.registry.savage_cyclopes.SavageCyclopesMiscStuff;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class LargeBundleContentsComponent
implements class_5632 {
    public static final LargeBundleContentsComponent DEFAULT = new LargeBundleContentsComponent(List.of());
    public static final Codec<LargeBundleContentsComponent> CODEC = class_1799.field_24671.listOf().flatXmap(LargeBundleContentsComponent::validateOccupancy, component -> DataResult.success(component.stacks));
    public static final class_9139<class_9129, LargeBundleContentsComponent> PACKET_CODEC = class_1799.field_48349.method_56433(class_9135.method_56363()).method_56432(LargeBundleContentsComponent::new, component -> component.stacks);
    private static final Fraction NESTED_BUNDLE_OCCUPANCY = Fraction.getFraction((int)1, (int)16);
    private static final int ADD_TO_NEW_SLOT = -1;
    public static final int field_52591 = -1;
    final List<class_1799> stacks;
    final Fraction occupancy;
    final int selectedStackIndex;

    LargeBundleContentsComponent(List<class_1799> stacks, Fraction occupancy, int selectedStackIndex) {
        this.stacks = stacks;
        this.occupancy = occupancy;
        this.selectedStackIndex = selectedStackIndex;
    }

    private static DataResult<LargeBundleContentsComponent> validateOccupancy(List<class_1799> stacks) {
        try {
            Fraction fraction = LargeBundleContentsComponent.calculateOccupancy(stacks);
            return DataResult.success((Object)new LargeBundleContentsComponent(stacks, fraction, -1));
        }
        catch (ArithmeticException var2) {
            return DataResult.error(() -> "Excessive total bundle weight");
        }
    }

    public LargeBundleContentsComponent(List<class_1799> stacks) {
        this(stacks, LargeBundleContentsComponent.calculateOccupancy(stacks), -1);
    }

    private static Fraction calculateOccupancy(List<class_1799> stacks) {
        Fraction fraction = Fraction.ZERO;
        for (class_1799 itemStack : stacks) {
            fraction = fraction.add(LargeBundleContentsComponent.getOccupancy(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.method_7947(), (int)1)));
        }
        return fraction;
    }

    static Fraction getOccupancy(class_1799 stack) {
        LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS);
        if (bundleContentsComponent != null) {
            return NESTED_BUNDLE_OCCUPANCY.add(bundleContentsComponent.getOccupancy());
        }
        List list = ((class_10706)stack.method_58695(class_9334.field_49624, (Object)class_10706.field_56300)).comp_3585();
        return !list.isEmpty() ? Fraction.getFraction((double)2.0) : Fraction.getFraction((int)1, (int)stack.method_7914());
    }

    public static boolean canBeBundled(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909().method_31568() && stack.method_58694(class_9334.field_49622) == null && stack.method_58694(SavageCyclopesMiscStuff.LARGE_BUNDLE_CONTENTS) == null && stack.method_58694(class_9334.field_49650) == null && stack.method_7914() > 1;
    }

    public int getNumberOfStacksShown() {
        int size = this.size();
        if (size > 15) {
            return 14;
        }
        return size;
    }

    public class_1799 get(int index) {
        return this.stacks.get(index);
    }

    public Stream<class_1799> stream() {
        return this.stacks.stream().map(class_1799::method_7972);
    }

    public Iterable<class_1799> iterate() {
        return this.stacks;
    }

    public Iterable<class_1799> iterateCopy() {
        return Lists.transform(this.stacks, class_1799::method_7972);
    }

    public int size() {
        return this.stacks.size();
    }

    public Fraction getOccupancy() {
        return this.occupancy.divideBy(Fraction.getFraction((double)2.0));
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public int getSelectedStackIndex() {
        return this.selectedStackIndex;
    }

    public boolean hasSelectedStack() {
        return this.selectedStackIndex != -1;
    }

    public boolean equals(Object o) {
        boolean bl;
        if (this == o) {
            return true;
        }
        if (!(o instanceof LargeBundleContentsComponent)) {
            bl = false;
        } else {
            LargeBundleContentsComponent bundleContentsComponent = (LargeBundleContentsComponent)o;
            bl = this.occupancy.equals((Object)bundleContentsComponent.occupancy) && class_1799.method_57362(this.stacks, bundleContentsComponent.stacks);
        }
        return bl;
    }

    public int hashCode() {
        return class_1799.method_57361(this.stacks);
    }

    public String toString() {
        return "LargeBundleContents" + String.valueOf(this.stacks);
    }

    public static class Builder {
        private final List<class_1799> stacks;
        private Fraction occupancy;
        private int selectedStackIndex;

        public Builder(LargeBundleContentsComponent base) {
            this.stacks = new ArrayList<class_1799>(base.stacks);
            this.occupancy = base.occupancy;
            this.selectedStackIndex = base.selectedStackIndex;
        }

        public Builder clear() {
            this.stacks.clear();
            this.occupancy = Fraction.ZERO;
            this.selectedStackIndex = -1;
            return this;
        }

        private int getInsertionIndex(class_1799 stack) {
            if (!stack.method_7946()) {
                return -1;
            }
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (!class_1799.method_31577((class_1799)this.stacks.get(i), (class_1799)stack)) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAllowed(class_1799 stack) {
            Fraction fraction = Fraction.getFraction((double)2.0).subtract(this.occupancy);
            return Math.max(fraction.divideBy(LargeBundleContentsComponent.getOccupancy(stack)).intValue(), 0);
        }

        public int add(class_1799 stack) {
            if (!LargeBundleContentsComponent.canBeBundled(stack)) {
                return 0;
            }
            int i = Math.min(stack.method_7947(), this.getMaxAllowed(stack));
            if (i == 0) {
                return 0;
            }
            this.occupancy = this.occupancy.add(LargeBundleContentsComponent.getOccupancy(stack).multiplyBy(Fraction.getFraction((int)i, (int)1)));
            int j = this.getInsertionIndex(stack);
            if (j != -1) {
                class_1799 itemStack = this.stacks.remove(j);
                class_1799 itemStack2 = itemStack.method_46651(itemStack.method_7947() + i);
                stack.method_7934(i);
                this.stacks.add(0, itemStack2);
            } else {
                this.stacks.add(0, stack.method_7971(i));
            }
            return i;
        }

        public int add(class_1735 slot, class_1657 player) {
            class_1799 itemStack = slot.method_7677();
            int i = this.getMaxAllowed(itemStack);
            return LargeBundleContentsComponent.canBeBundled(itemStack) ? this.add(slot.method_32753(itemStack.method_7947(), i, player)) : 0;
        }

        public void setSelectedStackIndex(int selectedStackIndex) {
            this.selectedStackIndex = this.selectedStackIndex != selectedStackIndex && !this.isOutOfBounds(selectedStackIndex) ? selectedStackIndex : -1;
        }

        private boolean isOutOfBounds(int index) {
            return index < 0 || index >= this.stacks.size();
        }

        @Nullable
        public class_1799 removeSelected() {
            if (this.stacks.isEmpty()) {
                return null;
            }
            int i = 0;
            if (this.selectedStackIndex >= 1) {
                i = this.selectedStackIndex;
            }
            class_1799 itemStack = this.stacks.remove(i).method_7972();
            this.occupancy = this.occupancy.subtract(LargeBundleContentsComponent.getOccupancy(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.method_7947(), (int)1)));
            this.setSelectedStackIndex(-1);
            return itemStack;
        }

        public Fraction getOccupancy() {
            return this.occupancy;
        }

        public LargeBundleContentsComponent build() {
            return new LargeBundleContentsComponent(List.copyOf(this.stacks), this.occupancy, this.selectedStackIndex);
        }
    }
}

