/*
 * Decompiled with CFR 0.152.
 */
package net.zenithm.cyclopsmod.item.component;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_9334;
import net.zenithm.cyclopsmod.item.component.LargeBundleContentsComponent;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class LargeBundleTooltipComponent
implements class_5684 {
    private static final class_2960 BUNDLE_PROGRESS_BAR_BORDER_TEXTURE = class_2960.method_60656((String)"container/bundle/bundle_progressbar_border");
    private static final class_2960 BUNDLE_PROGRESS_BAR_FILL_TEXTURE = class_2960.method_60656((String)"container/bundle/bundle_progressbar_fill");
    private static final class_2960 BUNDLE_PROGRESS_BAR_FULL_TEXTURE = class_2960.method_60656((String)"container/bundle/bundle_progressbar_full");
    private static final class_2960 BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE = class_2960.method_60656((String)"container/bundle/slot_highlight_back");
    private static final class_2960 BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE = class_2960.method_60656((String)"container/bundle/slot_highlight_front");
    private static final class_2960 BUNDLE_SLOT_BACKGROUND_TEXTURE = class_2960.method_60656((String)"container/bundle/slot_background");
    private static final int SLOTS_PER_ROW = 4;
    private static final int SLOT_DIMENSION = 24;
    private static final int ROW_WIDTH = 116;
    private static final int field_52816 = 13;
    private static final int field_52817 = 116;
    private static final int field_52818 = 1;
    private static final int PROGRESS_BAR_WIDTH = 94;
    private static final int field_52820 = 4;
    private static final class_2561 BUNDLE_FULL = class_2561.method_43471((String)"item.minecraft.bundle.full");
    private static final class_2561 BUNDLE_EMPTY = class_2561.method_43471((String)"item.minecraft.bundle.empty");
    private static final class_2561 BUNDLE_EMPTY_DESCRIPTION = class_2561.method_43471((String)"item.cyclopsmod.large_bundle.empty.description");
    private final LargeBundleContentsComponent bundleContents;

    public LargeBundleTooltipComponent(LargeBundleContentsComponent bundleContents) {
        this.bundleContents = bundleContents;
    }

    public int method_32661(class_327 textRenderer) {
        return this.bundleContents.isEmpty() ? LargeBundleTooltipComponent.getHeightOfEmpty(textRenderer) : this.getHeightOfNonEmpty();
    }

    public int method_32664(class_327 textRenderer) {
        return 116;
    }

    public boolean method_62003() {
        return true;
    }

    private static int getHeightOfEmpty(class_327 textRenderer) {
        return LargeBundleTooltipComponent.getDescriptionHeight(textRenderer) + 13 + 8;
    }

    private int getHeightOfNonEmpty() {
        return this.getRowsHeight() + 13 + 8;
    }

    private int getRowsHeight() {
        return this.getRows() * 24;
    }

    private int getXMargin(int width) {
        return (width - 116) / 2;
    }

    private int getRows() {
        return class_3532.method_38788((int)this.getNumVisibleSlots(), (int)4);
    }

    private int getNumVisibleSlots() {
        return Math.min(12, this.bundleContents.size());
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        if (this.bundleContents.isEmpty()) {
            this.drawEmptyTooltip(textRenderer, x, y, width, height, context);
        } else {
            this.drawNonEmptyTooltip(textRenderer, x, y, width, height, context);
        }
    }

    private void drawEmptyTooltip(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        LargeBundleTooltipComponent.drawEmptyDescription(x + this.getXMargin(width), y, textRenderer, context);
        this.drawProgressBar(x + this.getXMargin(width), y + LargeBundleTooltipComponent.getDescriptionHeight(textRenderer) + 4, textRenderer, context);
    }

    private void drawNonEmptyTooltip(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        boolean bl = this.bundleContents.size() > 15;
        List<class_1799> list = this.firstStacksInContents(this.bundleContents.getNumberOfStacksShown());
        int i = x + this.getXMargin(width) + 106 + 12;
        int j = y + this.getRows() * 24;
        int k = 1;
        for (int l = 1; l <= this.getRows(); ++l) {
            for (int m = 1; m <= 5; ++m) {
                int n = i - m * 24;
                int o = j - l * 24;
                if (LargeBundleTooltipComponent.shouldDrawExtraItemsCount(bl, m, l)) {
                    LargeBundleTooltipComponent.drawExtraItemsCount(n, o, this.numContentItemsAfter(list), textRenderer, context);
                    continue;
                }
                if (!LargeBundleTooltipComponent.shouldDrawItem(list, k)) continue;
                this.drawItem(k, n, o, list, k, textRenderer, context);
                ++k;
            }
        }
        this.drawSelectedItemTooltip(textRenderer, context, x, y, width);
        this.drawProgressBar(x + this.getXMargin(width), y + this.getRowsHeight() + 4, textRenderer, context);
    }

    private List<class_1799> firstStacksInContents(int numberOfStacksShown) {
        int i = Math.min(this.bundleContents.size(), numberOfStacksShown);
        return this.bundleContents.stream().toList().subList(0, i);
    }

    private static boolean shouldDrawExtraItemsCount(boolean hasMoreItems, int column, int row) {
        return hasMoreItems && column * row == 1;
    }

    private static boolean shouldDrawItem(List<class_1799> items, int itemIndex) {
        return items.size() >= itemIndex;
    }

    private int numContentItemsAfter(List<class_1799> items) {
        return this.bundleContents.stream().skip(items.size()).mapToInt(class_1799::method_7947).sum();
    }

    private void drawItem(int index, int x, int y, List<class_1799> stacks, int seed, class_327 textRenderer, class_332 drawContext) {
        int i = stacks.size() - index;
        boolean bl = i == this.bundleContents.getSelectedStackIndex();
        class_1799 itemStack = stacks.get(i);
        if (bl) {
            drawContext.method_52706(class_10799.field_56883, BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE, x, y, 24, 24);
        } else {
            drawContext.method_52706(class_10799.field_56883, BUNDLE_SLOT_BACKGROUND_TEXTURE, x, y, 24, 24);
        }
        drawContext.method_51428(itemStack, x + 4, y + 4, seed);
        drawContext.method_51431(textRenderer, itemStack, x + 4, y + 4);
        if (bl) {
            drawContext.method_52706(class_10799.field_56883, BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE, x, y, 24, 24);
        }
    }

    private static void drawExtraItemsCount(int x, int y, int numExtra, class_327 textRenderer, class_332 drawContext) {
        drawContext.method_25300(textRenderer, "+" + numExtra, x + 12, y + 10, 0xFFFFFF);
    }

    private void drawSelectedItemTooltip(class_327 textRenderer, class_332 drawContext, int x, int y, int width) {
        if (this.bundleContents.hasSelectedStack()) {
            class_1799 itemStack = this.bundleContents.get(this.bundleContents.getSelectedStackIndex());
            class_2561 text = itemStack.method_63015();
            int i = textRenderer.method_30880(text.method_30937());
            int j = x + width / 2 - 12;
            drawContext.method_64235(textRenderer, text, j - i / 2, y - 15, (class_2960)itemStack.method_58694(class_9334.field_54198));
        }
    }

    private void drawProgressBar(int x, int y, class_327 textRenderer, class_332 drawContext) {
        drawContext.method_52706(class_10799.field_56883, this.getProgressBarFillTexture(), x + 1, y, this.getProgressBarFill(), 13);
        drawContext.method_52706(class_10799.field_56883, BUNDLE_PROGRESS_BAR_BORDER_TEXTURE, x, y, 116, 13);
        class_2561 text = this.getProgressBarLabel();
        if (text != null) {
            drawContext.method_27534(textRenderer, text, x + 48, y + 3, 0xFFFFFF);
        }
    }

    private static void drawEmptyDescription(int x, int y, class_327 textRenderer, class_332 drawContext) {
        drawContext.method_65179(textRenderer, (class_5348)BUNDLE_EMPTY_DESCRIPTION, x, y, 116, 0xAAAAAA);
    }

    private static int getDescriptionHeight(class_327 textRenderer) {
        return textRenderer.method_1728((class_5348)BUNDLE_EMPTY_DESCRIPTION, 116).size() * 9;
    }

    private int getProgressBarFill() {
        return class_3532.method_15340((int)class_3532.method_59515((Fraction)this.bundleContents.getOccupancy(), (int)94), (int)0, (int)94);
    }

    private class_2960 getProgressBarFillTexture() {
        return this.bundleContents.getOccupancy().compareTo(Fraction.ONE) >= 0 ? BUNDLE_PROGRESS_BAR_FULL_TEXTURE : BUNDLE_PROGRESS_BAR_FILL_TEXTURE;
    }

    @Nullable
    private class_2561 getProgressBarLabel() {
        if (this.bundleContents.isEmpty()) {
            return BUNDLE_EMPTY;
        }
        return this.bundleContents.getOccupancy().compareTo(Fraction.ONE) >= 0 ? BUNDLE_FULL : null;
    }

    @Environment(value=EnvType.CLIENT)
    static enum SlotSprite {
        BLOCKED_SLOT(class_2960.method_60656((String)"container/bundle/blocked_slot"), 18, 20),
        SLOT(class_2960.method_60656((String)"container/bundle/slot"), 18, 20);

        public final class_2960 texture;
        public final int width;
        public final int height;

        private SlotSprite(class_2960 texture, int width, int height) {
            this.texture = texture;
            this.width = width;
            this.height = height;
        }
    }
}

