/*
 * Decompiled with CFR 0.152.
 */
package dev.rilith.swinginglanterns.client.debug;

import dev.rilith.swinginglanterns.SwingingLanterns;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class LanternDebugTracker {
    private static final class_310 CLIENT = class_310.method_1551();
    private static boolean overlayEnabled = false;
    @Nullable
    private static DebugSample latestSample = null;
    private static long lastActionBarUpdate = 0L;
    private static final Map<SampleKey, PrevValues> LAST_VALUES = new HashMap<SampleKey, PrevValues>();
    private static final float JUMP_THRESHOLD = 0.25f;
    private static final long RESET_TICK_GAP = 2L;
    private static double sharedPhase = 0.0;
    private static long lastPhaseUpdate = 0L;

    private LanternDebugTracker() {
    }

    public static void tick(class_310 client) {
        if (client.method_1493()) {
            return;
        }
        long now = class_156.method_658();
        if (lastPhaseUpdate == 0L) {
            lastPhaseUpdate = now;
            return;
        }
        double deltaSeconds = (double)(now - lastPhaseUpdate) / 1000.0;
        lastPhaseUpdate = now;
        if (deltaSeconds > 0.1) {
            deltaSeconds = 0.1;
        }
        sharedPhase += deltaSeconds * (double)SwingingLanterns.CONFIG.speed * 2.0;
    }

    public static double getSharedPhase() {
        return sharedPhase;
    }

    public static void toggle() {
        boolean bl = overlayEnabled = !overlayEnabled;
        if (LanternDebugTracker.CLIENT.field_1724 != null) {
            String text = overlayEnabled ? "Lantern debug overlay attivo" : "Lantern debug overlay disattivato";
            LanternDebugTracker.CLIENT.field_1724.method_7353((class_2561)class_2561.method_43470((String)text), true);
        }
    }

    public static void pushSample(class_1937 world, class_2338 pos, double ticks, float tiltX, float tiltZ, float yaw, float spin) {
        DebugSample sample;
        String dimension = world.method_27983().method_29177().toString();
        SampleKey key = new SampleKey(dimension, pos);
        long currentTick = world.method_8510();
        PrevValues prev = LAST_VALUES.get(key);
        long gap = prev == null ? 0L : currentTick - prev.worldTick();
        boolean reset = prev == null || gap > 2L;
        float diffX = reset ? 0.0f : Math.abs(tiltX - prev.tiltX());
        float diffZ = reset ? 0.0f : Math.abs(tiltZ - prev.tiltZ());
        float diffYaw = reset ? 0.0f : Math.abs(yaw - prev.yaw());
        float diffSpin = reset ? 0.0f : Math.abs(spin - prev.spin());
        boolean jump = Math.max(Math.max(diffX, diffZ), Math.max(diffYaw, diffSpin)) > 0.25f;
        latestSample = sample = new DebugSample(dimension, pos, ticks, currentTick, tiltX, tiltZ, yaw, spin, diffX, diffZ, diffYaw, diffSpin, jump, reset, gap);
        LAST_VALUES.put(key, new PrevValues(tiltX, tiltZ, yaw, spin, currentTick));
        if (overlayEnabled && LanternDebugTracker.CLIENT.field_1724 != null) {
            boolean shouldSend;
            long now = class_156.method_658();
            boolean bl = shouldSend = jump || now - lastActionBarUpdate > 750L;
            if (shouldSend) {
                String text = String.format(Locale.ROOT, "Lantern %s%s  dX %.3f  dZ %.3f  dYaw %.3f  dSpin %.3f", reset ? "!RESET!" : (jump ? "!JUMP!" : ""), reset ? String.format(Locale.ROOT, " (\u0394tick %d)", gap) : "", Float.valueOf(sample.diffX()), Float.valueOf(sample.diffZ()), Float.valueOf(sample.diffYaw()), Float.valueOf(sample.diffSpin()));
                LanternDebugTracker.CLIENT.field_1724.method_7353((class_2561)class_2561.method_43470((String)text), true);
                lastActionBarUpdate = now;
            }
        }
    }

    public static void render(class_332 context) {
        if (!overlayEnabled || LanternDebugTracker.CLIENT.field_1690 == null) {
            return;
        }
        class_327 renderer = LanternDebugTracker.CLIENT.field_1772;
        if (renderer == null) {
            return;
        }
        int x = 6;
        int y = 6;
        if (latestSample == null) {
            context.method_51439(renderer, (class_2561)class_2561.method_43470((String)"Lantern debug: nessun dato (avvicinati a una lanterna)"), x, y, 0xFFAA00, true);
            return;
        }
        DebugSample sample = latestSample;
        context.method_51439(renderer, (class_2561)class_2561.method_43470((String)("Lantern debug: " + sample.dimension())), x, y, 0xFFAA00, true);
        context.method_51439(renderer, (class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, "Pos %s  tick %d  t=%.2f", sample.pos(), sample.worldTick(), sample.ticks())), x, y += 10, 0xFFFFFF, true);
        context.method_51439(renderer, (class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, "TiltX %.3f  TiltZ %.3f  Yaw %.3f  Spin %.3f", Float.valueOf(sample.tiltX()), Float.valueOf(sample.tiltZ()), Float.valueOf(sample.yaw()), Float.valueOf(sample.spin()))), x, y += 10, 0xFFFFFF, true);
        int color = sample.jump() ? 0xFF5555 : 0x55FF55;
        context.method_51439(renderer, (class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, "dX %.3f  dZ %.3f  dYaw %.3f  dSpin %.3f%s", Float.valueOf(sample.diffX()), Float.valueOf(sample.diffZ()), Float.valueOf(sample.diffYaw()), Float.valueOf(sample.diffSpin()), sample.jump() ? " !jump" : "")), x, y += 10, color, true);
        y += 10;
        if (sample.reset()) {
            context.method_51439(renderer, (class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, "RESET \u0394tick %d (dati azzerati)", sample.tickGap())), x, y, 0xFFFF55, true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record SampleKey(String dimension, class_2338 pos) {
    }

    @Environment(value=EnvType.CLIENT)
    private record PrevValues(float tiltX, float tiltZ, float yaw, float spin, long worldTick) {
    }

    @Environment(value=EnvType.CLIENT)
    private record DebugSample(String dimension, class_2338 pos, double ticks, long worldTick, float tiltX, float tiltZ, float yaw, float spin, float diffX, float diffZ, float diffYaw, float diffSpin, boolean jump, boolean reset, long tickGap) {
    }
}

