/*
 * Decompiled with CFR 0.152.
 */
package dev.rilith.swinginglanterns.client.render;

import dev.rilith.swinginglanterns.SwingingLanterns;
import dev.rilith.swinginglanterns.blockentity.SwingingLanternBlockEntity;
import dev.rilith.swinginglanterns.client.debug.LanternDebugTracker;
import dev.rilith.swinginglanterns.client.render.SwingingLanternRenderState;
import dev.rilith.swinginglanterns.config.LanternConfig;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11791;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3749;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class SwingingLanternRenderer
implements class_827<SwingingLanternBlockEntity, SwingingLanternRenderState> {
    private final class_776 blockRenderManager;

    public SwingingLanternRenderer(class_5614.class_5615 ctx) {
        this.blockRenderManager = ctx.comp_4535();
    }

    public SwingingLanternRenderState createRenderState() {
        return new SwingingLanternRenderState();
    }

    public void updateRenderState(SwingingLanternBlockEntity entity, SwingingLanternRenderState state, float tickDelta, class_243 offset, class_11683.class_11792 crumblingOverlay) {
        int maxStage;
        super.method_74331((class_2586)entity, (class_11954)state, tickDelta, offset, crumblingOverlay);
        class_1937 world = entity.method_10997();
        if (world == null || !entity.isHanging()) {
            state.hanging = false;
            state.movingState = null;
            state.crumbleStage = -1;
            state.lastCrumbleParticleTick = -1L;
            return;
        }
        class_2338 pos = entity.method_11016();
        state.hanging = true;
        class_2680 blockState = (class_2680)entity.method_11010().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true));
        LanternConfig cfg = SwingingLanterns.CONFIG;
        float angle = (float)LanternDebugTracker.getSharedPhase();
        if (cfg.offsetEnabled) {
            angle += entity.getPhaseOffset() * cfg.offsetAmount;
        }
        state.tiltX = class_3532.method_15374((float)angle) * cfg.amplitudeX;
        state.tiltZ = class_3532.method_15362((float)(angle * 0.85f + 1.2f)) * cfg.amplitudeZ;
        state.yaw = class_3532.method_15374((float)(angle * 0.5f + 0.8f)) * cfg.yawAmplitude;
        state.spin = class_3532.method_15374((float)(angle * 1.2f + 2.0f)) * cfg.spinAmplitude;
        LanternDebugTracker.pushSample(world, pos, angle, state.tiltX, state.tiltZ, state.yaw, state.spin);
        state.movingState = SwingingLanternRenderer.cacheMovingState(state.movingState, blockState, pos, world);
        int previousCrumble = state.crumbleStage;
        int crumbleStage = -1;
        if (state.field_62677 != null && (maxStage = class_1088.field_21772.size()) > 0) {
            crumbleStage = class_3532.method_15340((int)state.field_62677.comp_4656(), (int)0, (int)(maxStage - 1));
            if (world instanceof class_638) {
                class_638 clientWorld = (class_638)world;
                long time = clientWorld.method_8510();
                if (crumbleStage != previousCrumble || time - state.lastCrumbleParticleTick >= 4L) {
                    SwingingLanternRenderer.spawnHitParticle(clientWorld, pos);
                    state.lastCrumbleParticleTick = time;
                }
            }
        }
        state.crumbleStage = crumbleStage;
    }

    public void render(SwingingLanternRenderState state, class_4587 matrices, class_11659 commands, class_12075 camera) {
        if (state.movingState == null) {
            return;
        }
        float pivotY = state.hanging ? 1.0f : 0.5f;
        matrices.method_22903();
        matrices.method_46416(0.5f, pivotY, 0.5f);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(state.yaw));
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(state.tiltZ));
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(state.tiltX));
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(state.spin));
        matrices.method_46416(-0.5f, -pivotY, -0.5f);
        if (state.hanging) {
            matrices.method_46416(0.0f, 0.03125f, 0.0f);
        }
        commands.method_73485(matrices, state.movingState);
        if (state.field_62677 != null) {
            this.renderCrumblingOverlay(commands, matrices, state);
        }
        matrices.method_22909();
    }

    public boolean method_3563() {
        return true;
    }

    private static class_11791 cacheMovingState(class_11791 existing, class_2680 state, class_2338 pos, class_1937 world) {
        class_11791 renderState = existing;
        if (renderState == null || !renderState.field_62247.equals((Object)state)) {
            renderState = new class_11791();
            renderState.field_62247 = state;
            renderState.field_62248 = world.method_23753(pos);
        }
        renderState.field_62245 = pos;
        renderState.field_62246 = pos;
        renderState.field_62249 = world;
        return renderState;
    }

    private void renderCrumblingOverlay(class_11659 commands, class_4587 matrices, SwingingLanternRenderState state) {
        class_11791 movingState = state.movingState;
        if (movingState == null || movingState.field_62249 == null) {
            return;
        }
        int maxStage = class_1088.field_21772.size();
        if (maxStage == 0) {
            return;
        }
        int stage = class_3532.method_15340((int)state.field_62677.comp_4656(), (int)0, (int)(maxStage - 1));
        class_1921 renderLayer = (class_1921)class_1088.field_21772.get(stage);
        class_2680 blockState = movingState.field_62247;
        class_2338 blockPos = movingState.field_62246;
        class_776 renderManager = this.blockRenderManager;
        commands.method_73483(matrices, renderLayer, (matrixEntry, vertexConsumer) -> {
            class_4587 stack = new class_4587();
            stack.method_23760().method_66521(matrixEntry);
            class_1087 model = renderManager.method_3349(blockState);
            class_5819 random = class_5819.method_43049((long)blockState.method_26190(blockPos));
            List parts = model.method_68512(random);
            class_4583 overlayConsumer = new class_4583(vertexConsumer, state.field_62677.comp_4657(), 1.0f);
            renderManager.method_3350().method_3374((class_1920)movingState, parts, blockState, blockPos, stack, (class_4588)overlayConsumer, true, class_4608.field_21444);
        });
    }

    private static void spawnHitParticle(class_638 world, class_2338 pos) {
        world.method_74254(pos, class_2350.method_10162((class_5819)world.method_8409()));
    }
}

