/*
 * Decompiled with CFR 0.152.
 */
package dev.rilith.swinginglanterns.client.screen;

import dev.rilith.swinginglanterns.SwingingLanterns;
import dev.rilith.swinginglanterns.config.LanternConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class LanternConfigScreen
extends class_437 {
    private final class_437 parent;
    private class_4185 offsetToggle;
    private FloatSlider offsetAmount;
    private FloatSlider amplitudeX;
    private FloatSlider amplitudeZ;
    private FloatSlider yaw;
    private FloatSlider spin;
    private FloatSlider speed;

    public LanternConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.swinginglanterns.config"));
        this.parent = parent;
    }

    protected void method_25426() {
        int slidersHeight;
        int buttonBlockHeight;
        int available;
        int minTop;
        int startY;
        int resetY;
        int cancelY;
        int doneY;
        int overflow;
        int maxSpacing;
        LanternConfig cfg = SwingingLanterns.CONFIG;
        int centerX = this.field_22789 / 2;
        int controlCount = 7;
        int controlHeight = 20;
        int preferredSpacing = 24;
        int minSpacing = 12;
        int columnSpacing = 12;
        int columns = this.field_22789 >= 320 || this.field_22790 < 260 ? 2 : 1;
        int controlWidth = Math.min(200, this.field_22789 - 40);
        if (columns == 2 && (controlWidth = (this.field_22789 - 40 - columnSpacing) / 2) < 120) {
            columns = 1;
            controlWidth = Math.min(200, this.field_22789 - 40);
        }
        controlWidth = Math.max(140, controlWidth);
        int rows = (controlCount + columns - 1) / columns;
        int spaceForControls = Math.max(0, this.field_22790 - 32 - 84 - 30);
        int rowSpacing = preferredSpacing;
        if (rows > 1 && (maxSpacing = (spaceForControls - rows * controlHeight) / (rows - 1)) < preferredSpacing) {
            rowSpacing = Math.max(minSpacing, maxSpacing);
        }
        if ((overflow = (doneY = (cancelY = (resetY = (startY = (minTop = 32) + Math.max(0, (available = this.field_22790 - minTop - (buttonBlockHeight = 84) - (slidersHeight = rows * controlHeight + (rows - 1) * rowSpacing)) / 2)) + slidersHeight + 12) + 24) + 24) + 30 - this.field_22790) > 0 && rows > 1 && rowSpacing > minSpacing) {
            int reductionPerGap = (int)Math.ceil((double)overflow / (double)(rows - 1));
            rowSpacing = Math.max(minSpacing, rowSpacing - reductionPerGap);
            slidersHeight = rows * controlHeight + (rows - 1) * rowSpacing;
            available = this.field_22790 - minTop - buttonBlockHeight - slidersHeight;
            startY = minTop + Math.max(0, available / 2);
            resetY = startY + slidersHeight + 12;
            cancelY = resetY + 24;
            doneY = cancelY + 24;
            overflow = doneY + 30 - this.field_22790;
        }
        if (overflow > 0) {
            startY = Math.max(minTop, startY - overflow);
            resetY = startY + slidersHeight + 12;
            cancelY = resetY + 24;
            doneY = cancelY + 24;
        }
        int totalControlsWidth = columns * controlWidth + (columns - 1) * columnSpacing;
        int controlsStartX = Math.max(10, centerX - totalControlsWidth / 2);
        int idx = 0;
        this.offsetToggle = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.offsetToggleLabel(cfg.offsetEnabled), button -> {
            cfg.offsetEnabled = !cfg.offsetEnabled;
            button.method_25355(this.offsetToggleLabel(cfg.offsetEnabled));
            if (this.offsetAmount != null) {
                this.offsetAmount.field_22763 = cfg.offsetEnabled;
            }
        }).method_46434(this.controlX(controlsStartX, idx, columns, controlWidth, columnSpacing), this.controlY(startY, idx, columns, controlHeight, rowSpacing), controlWidth, controlHeight).method_46431());
        this.offsetAmount = this.addSlider(this.controlX(controlsStartX, ++idx, columns, controlWidth, columnSpacing), this.controlY(startY, idx, columns, controlHeight, rowSpacing), controlWidth, (class_2561)class_2561.method_43471((String)"option.swinginglanterns.offset_amount"), cfg.offsetAmount, 0.0f, 3.0f, value -> {
            cfg.offsetAmount = value;
        });
        this.offsetAmount.field_22763 = cfg.offsetEnabled;
        this.amplitudeX = this.addSlider(this.controlX(controlsStartX, ++idx, columns, controlWidth, columnSpacing), this.controlY(startY, idx, columns, controlHeight, rowSpacing), controlWidth, (class_2561)class_2561.method_43471((String)"option.swinginglanterns.amplitude_x"), cfg.amplitudeX, 0.0f, 10.0f, value -> {
            cfg.amplitudeX = value;
        });
        this.amplitudeZ = this.addSlider(this.controlX(controlsStartX, ++idx, columns, controlWidth, columnSpacing), this.controlY(startY, idx, columns, controlHeight, rowSpacing), controlWidth, (class_2561)class_2561.method_43471((String)"option.swinginglanterns.amplitude_z"), cfg.amplitudeZ, 0.0f, 10.0f, value -> {
            cfg.amplitudeZ = value;
        });
        this.yaw = this.addSlider(this.controlX(controlsStartX, ++idx, columns, controlWidth, columnSpacing), this.controlY(startY, idx, columns, controlHeight, rowSpacing), controlWidth, (class_2561)class_2561.method_43471((String)"option.swinginglanterns.yaw"), cfg.yawAmplitude, 0.0f, 5.0f, value -> {
            cfg.yawAmplitude = value;
        });
        this.spin = this.addSlider(this.controlX(controlsStartX, ++idx, columns, controlWidth, columnSpacing), this.controlY(startY, idx, columns, controlHeight, rowSpacing), controlWidth, (class_2561)class_2561.method_43471((String)"option.swinginglanterns.spin"), cfg.spinAmplitude, 0.0f, 5.0f, value -> {
            cfg.spinAmplitude = value;
        });
        this.speed = this.addSlider(this.controlX(controlsStartX, ++idx, columns, controlWidth, columnSpacing), this.controlY(startY, idx, columns, controlHeight, rowSpacing), controlWidth, (class_2561)class_2561.method_43471((String)"option.swinginglanterns.speed"), cfg.speed, 0.1f, 3.0f, value -> {
            cfg.speed = value;
        });
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.swinginglanterns.reset_defaults"), button -> this.resetToDefaults()).method_46434(centerX - 100, resetY, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> {
            SwingingLanterns.CONFIG.save();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX - 100, doneY, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX - 100, cancelY, 200, 20).method_46431());
    }

    private FloatSlider addSlider(int x, int y, int width, class_2561 label, float current, float min, float max, ValueConsumer consumer) {
        FloatSlider slider = new FloatSlider(x, y, width, 20, label, current, min, max, consumer);
        this.method_37063((class_364)slider);
        return slider;
    }

    private int controlX(int controlsStartX, int index, int columns, int controlWidth, int columnSpacing) {
        int col = index % columns;
        return controlsStartX + col * (controlWidth + columnSpacing);
    }

    private int controlY(int startY, int index, int columns, int controlHeight, int rowSpacing) {
        int row = index / columns;
        return startY + row * (controlHeight + rowSpacing);
    }

    private class_2561 offsetToggleLabel(boolean enabled) {
        return class_2561.method_43471((String)"option.swinginglanterns.offset_enabled").method_27661().method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)(enabled ? "options.on" : "options.off")));
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void resetToDefaults() {
        LanternConfig cfg = SwingingLanterns.CONFIG;
        cfg.resetToDefaults();
        if (this.offsetToggle != null) {
            this.offsetToggle.method_25355(this.offsetToggleLabel(cfg.offsetEnabled));
        }
        if (this.offsetAmount != null) {
            this.offsetAmount.setActualValue(cfg.offsetAmount);
            this.offsetAmount.field_22763 = cfg.offsetEnabled;
        }
        if (this.amplitudeX != null) {
            this.amplitudeX.setActualValue(cfg.amplitudeX);
        }
        if (this.amplitudeZ != null) {
            this.amplitudeZ.setActualValue(cfg.amplitudeZ);
        }
        if (this.yaw != null) {
            this.yaw.setActualValue(cfg.yawAmplitude);
        }
        if (this.spin != null) {
            this.spin.setActualValue(cfg.spinAmplitude);
        }
        if (this.speed != null) {
            this.speed.setActualValue(cfg.speed);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, 0xFFFFFF);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    private static interface ValueConsumer {
        public void accept(float var1);
    }

    @Environment(value=EnvType.CLIENT)
    private static final class FloatSlider
    extends class_357 {
        private final class_2561 label;
        private final float min;
        private final float max;
        private final ValueConsumer consumer;

        private FloatSlider(int x, int y, int width, int height, class_2561 label, float current, float min, float max, ValueConsumer consumer) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), (double)((current - min) / (max - min)));
            this.label = label;
            this.min = min;
            this.max = max;
            this.consumer = consumer;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)String.format("%s: %.2f", this.label.getString(), Float.valueOf(this.getValue()))));
        }

        protected void method_25344() {
            float value = this.getValue();
            this.consumer.accept(value);
        }

        private float getValue() {
            return (float)(this.field_22753 * (double)(this.max - this.min) + (double)this.min);
        }

        private void setActualValue(float actual) {
            this.field_22753 = class_3532.method_15363((float)((actual - this.min) / (this.max - this.min)), (float)0.0f, (float)1.0f);
            this.method_25346();
        }
    }
}

