/*
 * Decompiled with CFR 0.152.
 */
package dev.rilith.swinginglanterns.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import dev.rilith.swinginglanterns.SwingingLanterns;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class LanternConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Path.of("config", "swinginglanterns.json");
    private static final int CURRENT_VERSION = 2;
    public int schemaVersion = 2;
    public float amplitudeX = 4.0f;
    public float amplitudeZ = 2.5f;
    public float yawAmplitude = 1.3f;
    public float spinAmplitude = 0.6f;
    public float speed = 1.0f;
    public boolean offsetEnabled = true;
    public float offsetAmount = 1.0f;

    public void resetToDefaults() {
        this.schemaVersion = 2;
        this.amplitudeX = 4.0f;
        this.amplitudeZ = 2.5f;
        this.yawAmplitude = 1.3f;
        this.spinAmplitude = 0.6f;
        this.speed = 1.0f;
        this.offsetEnabled = true;
        this.offsetAmount = 1.0f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LanternConfig load() {
        JsonObject rawJson = null;
        boolean changed = false;
        LanternConfig cfg = null;
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                rawJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                cfg = (LanternConfig)GSON.fromJson((JsonElement)rawJson, LanternConfig.class);
                if (cfg != null) {
                    changed = LanternConfig.applyMissingDefaults(cfg, rawJson);
                    if (changed) {
                        cfg.save();
                    }
                    LanternConfig lanternConfig = cfg;
                    return lanternConfig;
                }
            }
            catch (JsonSyntaxException | IOException e) {
                SwingingLanterns.LOGGER.warn("Unable to read config, using defaults", e);
            }
        }
        cfg = new LanternConfig();
        cfg.save();
        return cfg;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            SwingingLanterns.LOGGER.warn("Unable to save config", (Throwable)e);
        }
    }

    private static boolean applyMissingDefaults(LanternConfig cfg, JsonObject rawJson) {
        int rawVersion;
        boolean changed = false;
        int n = rawVersion = rawJson != null && rawJson.has("schemaVersion") ? rawJson.get("schemaVersion").getAsInt() : 0;
        if (rawVersion < 2) {
            if (!cfg.offsetEnabled) {
                cfg.offsetEnabled = true;
                changed = true;
            }
            if (cfg.offsetAmount == 0.0f) {
                cfg.offsetAmount = 1.0f;
                changed = true;
            }
            cfg.schemaVersion = 2;
            changed = true;
        }
        return changed;
    }
}

