/*
 * Decompiled with CFR 0.152.
 */
package dev.rilith.swinginglanterns.util;

import dev.rilith.swinginglanterns.blockentity.SwingingLanternBlockEntity;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3749;

public final class LanternBlockEntityRefresher {
    private LanternBlockEntityRefresher() {
    }

    public static void init() {
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (chunk instanceof class_2818) {
                class_2818 worldChunk = chunk;
                LanternBlockEntityRefresher.backfillLanternBlockEntities(worldChunk);
            }
        });
    }

    private static void backfillLanternBlockEntities(class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        int startX = chunkPos.method_8326();
        int startZ = chunkPos.method_8328();
        int bottomY = chunk.method_31607();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        class_2826[] sections = chunk.method_12006();
        for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
            class_2826 section = sections[sectionIndex];
            if (section == null || section.method_38292() || !section.method_19523(LanternBlockEntityRefresher::isHangingLantern)) continue;
            int sectionStartY = bottomY + (sectionIndex << 4);
            for (int localY = 0; localY < 16; ++localY) {
                int worldY = sectionStartY + localY;
                for (int localX = 0; localX < 16; ++localX) {
                    int worldX = startX + localX;
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        class_2680 state = section.method_12254(localX, localY, localZ);
                        if (!LanternBlockEntityRefresher.isHangingLantern(state)) continue;
                        int worldZ = startZ + localZ;
                        mutablePos.method_10103(worldX, worldY, worldZ);
                        class_2586 existing = chunk.method_8321((class_2338)mutablePos);
                        if (existing instanceof SwingingLanternBlockEntity) continue;
                        SwingingLanternBlockEntity lantern = new SwingingLanternBlockEntity(mutablePos.method_10062(), state);
                        chunk.method_12007((class_2586)lantern);
                    }
                }
            }
        }
    }

    private static boolean isHangingLantern(class_2680 state) {
        return state.method_26204() instanceof class_3749 && (Boolean)state.method_11654((class_2769)class_3749.field_16545) != false;
    }
}

