/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.addons.node;

import java.io.IOException;
import java.io.InputStream;
import kasuga.lib.core.addons.resource.FlatFilesystem;
import kasuga.lib.core.addons.resource.HierarchicalFilesystem;
import kasuga.lib.core.addons.resource.ResourceProvider;

public class PackageReader
implements ResourceProvider {
    public String path;
    public ResourceProvider provider;

    public PackageReader(String path, ResourceProvider provider) {
        this.path = path;
        this.provider = provider;
    }

    @Override
    public InputStream open(String file) throws IOException {
        return this.provider.open(this.path + "/" + ResourceProvider.firstSplash(file));
    }

    @Override
    public boolean exists(String file) {
        return this.provider.exists(this.path + "/" + ResourceProvider.firstSplash(file));
    }

    @Override
    public boolean isRegularFile(String file) {
        return this.provider.exists(this.path + "/" + ResourceProvider.firstSplash(file));
    }

    @Override
    public boolean isDirectory(String file) {
        return this.provider.isDirectory(this.path + "/" + ResourceProvider.firstSplash(file));
    }

    public boolean isHierarchical() {
        return this.provider instanceof HierarchicalFilesystem;
    }

    public boolean isFlat() {
        return this.provider instanceof FlatFilesystem;
    }

    public HierarchicalFilesystem asRawHierarchical() {
        return (HierarchicalFilesystem)this.provider;
    }

    public FlatFilesystem asRawFlat() {
        return (FlatFilesystem)this.provider;
    }

    public String getPath() {
        return this.path;
    }
}

