/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.addons.resource;

import java.util.ArrayList;
import java.util.List;
import kasuga.lib.core.addons.resource.ResourceProvider;
import kasuga.lib.core.addons.resource.VanillaFileResourcePackProvider;
import kasuga.lib.core.addons.resource.VanillaFolderResourcePackProvider;
import kasuga.lib.core.addons.resource.VanillaPathResourcePackProvider;
import kasuga.lib.core.util.Envs;
import kasuga.lib.mixins.mixin.resources.DelegatingResourcePackMixin;
import kasuga.lib.mixins.mixin.resources.FilePackResourceMixin;
import net.minecraft.client.resources.DefaultClientPackResources;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraftforge.resource.DelegatingResourcePack;
import net.minecraftforge.resource.PathResourcePack;

public class ResourceAdapter {
    public static List<PackResources> flatten(List<PackResources> resources) {
        ArrayList<PackResources> result = new ArrayList<PackResources>();
        for (PackResources resource : resources) {
            if (resource instanceof DelegatingResourcePack) {
                DelegatingResourcePack delegating = (DelegatingResourcePack)resource;
                result.addAll(ResourceAdapter.flatten(((DelegatingResourcePackMixin)delegating).getDelegates()));
                continue;
            }
            result.add(resource);
        }
        return result;
    }

    public static List<ResourceProvider> transform(List<PackResources> resources) {
        ArrayList<ResourceProvider> result = new ArrayList<ResourceProvider>();
        for (PackResources resource : resources) {
            if (resource instanceof FilePackResources) {
                FilePackResources file = (FilePackResources)resource;
                result.add(new VanillaFileResourcePackProvider(((FilePackResourceMixin)file).invokeGetOrCreateZipFile()));
                continue;
            }
            if (resource instanceof PathResourcePack) {
                PathResourcePack path = (PathResourcePack)resource;
                result.add(new VanillaPathResourcePackProvider(path.getSource(), path));
                continue;
            }
            if (resource instanceof FolderPackResources) {
                FolderPackResources folder = (FolderPackResources)resource;
                result.add(new VanillaFolderResourcePackProvider(folder.f_10203_));
                continue;
            }
            if (resource instanceof DefaultClientPackResources) continue;
            if (Envs.isDevEnvironment()) {
                throw new IllegalArgumentException("Unknown resource type: " + resource.getClass());
            }
            System.err.println("Unknown resource type: " + resource.getClass());
        }
        return result;
    }

    public static List<ResourceProvider> adapt(List<PackResources> resources) {
        for (PackResources packResources : ResourceAdapter.flatten(resources)) {
            System.out.printf("Asset pack: " + packResources.m_8017_() + " - " + packResources.getClass().getName() + "\n", new Object[0]);
        }
        return ResourceAdapter.transform(ResourceAdapter.flatten(resources));
    }
}

