/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kasuga.lib.core.client.animation.infrastructure.AnimAssignable;
import kasuga.lib.core.client.animation.infrastructure.AnimationElement;
import kasuga.lib.core.client.animation.infrastructure.Condition;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.data.Variable;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import kasuga.lib.vendor_modules.interpreter.logic.data.LogicalBool;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Trigger
extends AnimationElement
implements AnimAssignable {
    Condition condition;
    private final ArrayList<Formula> functions;
    private final HashMap<Formula, ArrayList<String>> controlled;
    private final Namespace namespace;

    public Trigger(String key, Namespace namespace) {
        super(key);
        this.namespace = namespace;
        this.functions = new ArrayList();
        this.controlled = new HashMap();
        this.condition = Condition.defaultTrue("condition", namespace);
    }

    @Override
    public void init() {
    }

    public static Trigger decode(String key, Namespace namespace, JsonObject object) {
        LogicalData data = LogicalBool.defaultTrue();
        if (object.has("condition")) {
            String element = object.get("condition").getAsString();
            data = element.equals("true") || element.equals("false") ? new LogicalBool(element.equals("true")) : namespace.decodeLogical(element);
        }
        Condition condition1 = new Condition("condition", namespace, data);
        Trigger trigger = new Trigger(key, namespace);
        JsonArray funcs = object.getAsJsonArray("action");
        for (JsonElement element : funcs) {
            trigger.addFunction(element.getAsString());
        }
        trigger.condition = condition1;
        return trigger;
    }

    public void action() {
        if (!this.condition.result()) {
            return;
        }
        for (Formula trg : this.functions) {
            float result = trg.getResult();
            if (!this.controlled.containsKey(trg)) continue;
            for (String var : this.controlled.get(trg)) {
                this.namespace.assign(var, result);
            }
        }
    }

    public void addFunction(String function) {
        String[] strs = (function = function.replace(" ", "")).split("=");
        if (strs.length == 1) {
            this.functions.add(this.namespace.decodeFormula(function));
        } else if (strs.length == 2) {
            String[] vars = strs[0].split(",");
            Formula formula = this.namespace.decodeFormula(strs[1]);
            this.functions.add(formula);
            this.controlled.put(formula, new ArrayList<String>(List.of(vars)));
            for (String var : vars) {
                if (this.namespace.containsInstance(var)) continue;
                this.namespace.registerInstance(var, new Variable(var, this.namespace, formula.getResult()));
            }
        }
    }

    public ArrayList<Formula> getFunctions() {
        return this.functions;
    }

    @Override
    public boolean isAssignable() {
        return this.namespace.hasInstance();
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void assign(String codec, float value) {
        this.namespace.assign(codec, value);
    }
}

