/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.rotation;

import com.mojang.blaze3d.vertex.PoseStack;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import kasuga.lib.core.client.animation.neo_neo.base.ICustom;
import kasuga.lib.core.client.animation.neo_neo.point.PivotPoint;
import kasuga.lib.core.client.animation.neo_neo.rotation.Rotation;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.interpreter.Code;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class CustomRotation
extends Rotation
implements ICustom {
    Namespace namespace;
    Formula x;
    Formula y;
    Formula z;
    Pair<Float, Vec3> cache;

    public CustomRotation(Namespace namespace, String x, String y, String z, float startTime, float endTime, boolean degree) {
        super(Vec3.f_82478_, startTime, endTime, degree);
        this.namespace = namespace;
        this.setFormulas(x, y, z);
        namespace.assign("start_time", startTime);
        namespace.assign("end_time", endTime);
    }

    public CustomRotation(String x, String y, String z, float startTime, float endTime, boolean degree) {
        this(new Namespace(Code.ROOT_NAMESPACE), x, y, z, startTime, endTime, degree);
    }

    public CustomRotation(Namespace namespace, float startTime, float endTime, boolean degree) {
        this(namespace, "0", "0", "0", startTime, endTime, degree);
    }

    public CustomRotation(float startTime, float endTime, boolean degree) {
        this("0", "0", "0", startTime, endTime, degree);
    }

    @Override
    public Vec3 getPercentage(float percentage) {
        if (percentage == this.cache.getFirst().floatValue()) {
            return this.cache.getSecond();
        }
        this.namespace.assign("t", percentage);
        Vec3 result = new Vec3((double)this.x.getResult(), (double)this.y.getResult(), (double)this.z.getResult());
        this.cache = Pair.of(Float.valueOf(percentage), result);
        return result;
    }

    @Override
    public void move(float time, PoseStack pose) {
        this.getPivot().apply(pose);
        VectorUtil.rot(pose, this.getPercentage(time), this.isDegree());
        this.getPivot().reverseApply(pose);
    }

    @Override
    public void setX(String x) {
        this.x = this.namespace.decodeFormula(x);
    }

    @Override
    public void setY(String y) {
        this.y = this.namespace.decodeFormula(y);
    }

    @Override
    public void setZ(String z) {
        this.y = this.namespace.decodeFormula(z);
    }

    @Override
    public Formula getX() {
        return this.x;
    }

    @Override
    public Formula getY() {
        return this.y;
    }

    @Override
    public Formula getZ() {
        return this.z;
    }

    public void setFormulas(String x, String y, String z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.updateMovement();
    }

    @Override
    public void setStartTime(float startTime) {
        super.setStartTime(startTime);
        this.namespace.assign("start_time", startTime);
    }

    @Override
    public void setEndTime(float endTime) {
        super.setEndTime(endTime);
        this.namespace.assign("end_time", endTime);
    }

    @Override
    public void reset() {
        this.x = this.namespace.decodeFormula("0");
        this.y = this.namespace.decodeFormula("0");
        this.z = this.namespace.decodeFormula("0");
        this.cache = Pair.of(Float.valueOf(0.0f), Vec3.f_82478_);
        this.setData(Vec3.f_82478_);
    }

    public void updateMovement() {
        float t = this.namespace.getInstance("t").getValue("t");
        this.namespace.assign("t", 1.0f);
        this.setData(new Vec3((double)this.x.getResult(), (double)this.y.getResult(), (double)this.z.getResult()));
        this.namespace.assign("t", t);
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public void apply(PivotPoint point, float time) {
        point.rotate(this.getPercentage(time), this.isDegree());
    }

    public PivotPoint creatPivot() {
        return new PivotPoint(this.isDegree());
    }

    @Override
    public void write(CompoundTag nbt) {
        super.write(nbt);
        this.writeCustomFormulas(nbt, "custom");
    }

    @Override
    public void read(CompoundTag nbt) {
        super.read(nbt);
        this.readCustomFormulas(nbt, "custom");
    }
}

