/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.common.layouting;

import java.util.Objects;

public class LayoutBox {
    public static final LayoutBox ZERO = LayoutBox.of(0.0f, 0.0f, 0.0f, 0.0f);
    public final float x;
    public final float y;
    public final float width;
    public final float height;

    public LayoutBox(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public static LayoutBox of(float x, float y, float width, float height) {
        return new LayoutBox(x, y, width, height);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LayoutBox layoutBox = (LayoutBox)object;
        return this.x == layoutBox.x && this.y == layoutBox.y && this.width == layoutBox.width && this.height == layoutBox.height;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public LayoutBox addCoordinateFrom(LayoutBox target) {
        return new LayoutBox(target.x + this.x, target.y + this.y, this.width, this.height);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public boolean contains(int x, int y) {
        return (float)x >= this.x && (float)x <= this.x + this.width && (float)y >= this.y && (float)y <= this.y + this.height;
    }
}

