/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture.old;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.util.Resources;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class SimpleTexture {
    int uOffset;
    int vOffset;
    int uWidth;
    int vHeight;
    int imgWidth;
    int imgHeight;
    SimpleColor color;
    float fuOffset;
    float fvOffset;
    float fuWidth;
    float fvHeight;
    float zoom = 1.0f;
    static final int COLOR_DEFAULT = 0xFFFFFF;
    final ResourceLocation location;
    BufferedImage image;
    byte[] bytesOfImage;

    public SimpleTexture(@Nonnull ResourceLocation location, int uOffset, int vOffset, int uWidth, int vHeight, SimpleColor color, BufferedImage image, byte[] bytesOfImage) {
        this.location = location;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.color = color;
        this.image = image;
        this.bytesOfImage = bytesOfImage;
        this.imgWidth = image.getWidth();
        this.imgHeight = image.getHeight();
        this.refreshImage();
    }

    public SimpleTexture(@Nonnull ResourceLocation location, int uOffset, int vOffset, int uWidth, int vHeight, int color, float alpha) {
        this.location = location;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.color = SimpleColor.fromRGBA(color, alpha);
        if (KasugaLib.STACKS.isTextureRegistryFired()) {
            this.uploadPicture(location);
        } else {
            KasugaLib.STACKS.putUnregisteredPicIn(this);
        }
    }

    public SimpleTexture(@Nonnull ResourceLocation location, InputStream stream, int uOffset, int vOffset, int uWidth, int vHeight, int color, float alpha) {
        this.location = location;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.color = SimpleColor.fromRGBA(color, alpha);
        try {
            byte[] bytes = stream.readAllBytes();
            ByteArrayInputStream readStream = new ByteArrayInputStream(bytes);
            Minecraft.m_91087_().f_90987_.m_118495_(location, (AbstractTexture)new DynamicTexture(NativeImage.m_85058_((InputStream)readStream)));
            readStream = new ByteArrayInputStream(bytes);
            this.image = ImageIO.read(readStream);
            this.bytesOfImage = stream.readAllBytes();
            this.imgWidth = this.image.getWidth();
            this.imgHeight = this.image.getHeight();
            this.refreshImage();
        }
        catch (Exception e) {
            Minecraft.m_91332_((CrashReport)CrashReport.m_127521_((Throwable)e, (String)""));
        }
    }

    public void uploadPicture(@Nonnull ResourceLocation location) {
        try {
            Resource resource = Resources.getResource(location);
            InputStream stream = resource.m_6679_();
            this.image = ImageIO.read(stream);
            this.bytesOfImage = stream.readAllBytes();
            stream.close();
            this.imgWidth = this.image.getWidth();
            this.imgHeight = this.image.getHeight();
            this.refreshImage();
        }
        catch (Exception e) {
            Minecraft.m_91332_((CrashReport)CrashReport.m_127521_((Throwable)e, (String)""));
        }
    }

    public SimpleTexture(@Nonnull ResourceLocation location, int uOffset, int vOffset, int uWidth, int vHeight, int color) {
        this(location, uOffset, vOffset, uWidth, vHeight, color, 1.0f);
    }

    public SimpleTexture(@Nonnull ResourceLocation location, int uOffset, int vOffset, int uWidth, int vHeight) {
        this(location, uOffset, vOffset, uWidth, vHeight, 0xFFFFFF, 1.0f);
    }

    public SimpleTexture(@Nonnull ResourceLocation location, int uWidth, int vHeight, int color, float alpha) {
        this(location, 0, 0, uWidth, vHeight, color, alpha);
    }

    public SimpleTexture(@Nonnull ResourceLocation location, int uWidth, int vHeight, int color) {
        this(location, 0, 0, uWidth, vHeight, color, 1.0f);
    }

    public SimpleTexture(@Nonnull ResourceLocation location, int uWidth, int vHeight) {
        this(location, 0, 0, uWidth, vHeight, 0xFFFFFF, 1.0f);
    }

    public SimpleTexture(@Nonnull ResourceLocation location, int color, float alpha) {
        this(location, 0, 0, 0, 0, color, alpha);
        this.uWidth = this.imgWidth;
        this.vHeight = this.imgHeight;
        if (KasugaLib.STACKS.isTextureRegistryFired()) {
            this.refreshImage();
        }
    }

    public SimpleTexture(@Nonnull ResourceLocation location, int color) {
        this(location, color, 1.0f);
    }

    public SimpleTexture(@Nonnull ResourceLocation location, float alpha) {
        this(location, 0xFFFFFF, alpha);
    }

    public SimpleTexture(@Nonnull ResourceLocation location) {
        this(location, 0xFFFFFF, 1.0f);
    }

    public SimpleTexture cut(int left, int up, int right, int down) {
        return new SimpleTexture(this.location, this.uOffset + left, this.vOffset + up, this.uWidth - right - left, this.vHeight - down - up, this.color.getRGB(), this.color.getA());
    }

    public SimpleTexture cutSize(int left, int up, int width, int height) {
        return new SimpleTexture(this.location, this.uOffset + left, this.vOffset + up, width, height, this.color, this.image, this.bytesOfImage);
    }

    public SimpleTexture flipY() {
        return new SimpleTexture(this.location, this.uOffset + this.uWidth, this.vOffset, -this.uWidth, this.vHeight, this.color.getRGB(), this.color.getA());
    }

    public SimpleTexture flipX() {
        return new SimpleTexture(this.location, this.uOffset, this.vOffset + this.vHeight, this.uWidth, -this.vHeight, this.color.getRGB(), this.color.getA());
    }

    public static SimpleTexture fromByteBuf(FriendlyByteBuf buf) {
        ResourceLocation location1 = buf.m_130281_();
        int uOffset = buf.readInt();
        int vOffset = buf.readInt();
        int uWidth = buf.readInt();
        int vHeight = buf.readInt();
        CompoundTag colorTag = buf.m_130261_();
        SimpleColor color = SimpleColor.fromNbt(colorTag);
        byte[] bytes = buf.m_130052_();
        return new SimpleTexture(location1, new ByteArrayInputStream(bytes), uOffset, vOffset, uWidth, vHeight, color.getRGB(), color.getA());
    }

    public void toByteBuf(FriendlyByteBuf buf) {
        buf.m_130085_(this.location);
        buf.writeInt(this.uOffset);
        buf.writeInt(this.vOffset);
        buf.writeInt(this.uWidth);
        buf.writeInt(this.vHeight);
        CompoundTag colorTag = new CompoundTag();
        this.color.toNbt(colorTag);
        buf.m_130079_(colorTag);
        buf.m_130087_(this.bytesOfImage);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    private double aspectRatio() {
        return (double)this.uWidth / (double)this.vHeight;
    }

    public double widthHeightRatio() {
        return this.aspectRatio();
    }

    public double heightWidthRatio() {
        return 1.0 / this.aspectRatio();
    }

    public int getFixedHeight(int fromWidth) {
        return (int)((double)fromWidth / this.widthHeightRatio());
    }

    public int getFixedWidth(int fromHeight) {
        return (int)((double)fromHeight * this.widthHeightRatio());
    }

    public int uOffset() {
        return this.uOffset;
    }

    public int vOffset() {
        return this.vOffset;
    }

    public float fuOffset() {
        return (float)this.uOffset / (float)this.imgWidth;
    }

    public float fvOffset() {
        return (float)this.vOffset / (float)this.imgHeight;
    }

    public float fuWidth() {
        return (float)this.uWidth / (float)this.imgWidth;
    }

    public float fvHeight() {
        return (float)this.vHeight / (float)this.imgHeight;
    }

    public float fuOffsetR() {
        return this.fuOffset() + this.fuWidth();
    }

    public float fvOffsetD() {
        return this.fvOffset() + this.fvHeight();
    }

    public int width() {
        return (int)(this.zoom * (float)this.uWidth);
    }

    public int height() {
        return (int)(this.zoom * (float)this.vHeight);
    }

    public void zoom(float zoom) {
        this.zoom = Math.min(Math.max(zoom, 0.0f), 5.0f);
    }

    public float getAlpha() {
        return this.color.getA();
    }

    public void setAlpha(float alpha) {
        this.color = this.color.setA(alpha);
    }

    public SimpleColor getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = SimpleColor.fromRGBAInt(color);
    }

    public void setColor(int r, int g, int b, float a) {
        this.color = this.color.setR(r).setG(g).setB(b).setA(a);
    }

    public SimpleTexture withColor(int color, float alpha) {
        return new SimpleTexture(this.location, this.uOffset, this.vOffset, this.uWidth, this.vHeight, color, alpha);
    }

    public void refreshImage() {
        this.fuOffset = (float)this.uOffset / (float)this.imgWidth;
        this.fvOffset = (float)this.vOffset / (float)this.imgHeight;
        this.fuWidth = (float)this.uWidth / (float)this.imgWidth;
        this.fvHeight = (float)this.vHeight / (float)this.imgHeight;
    }

    public void setColor(int r, int g, int b) {
        this.color = this.color.setR(r).setG(g).setB(b);
    }

    public void render(int x, int y, int width, int height) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.location);
        RenderSystem.m_157429_((float)this.color.getfR(), (float)this.color.getfG(), (float)this.color.getfB(), (float)this.color.getA());
        RenderSystem.m_69478_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(this.fuOffset, this.fvOffset).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(this.fuOffset, this.fvOffset + this.fvHeight).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(this.fuOffset + this.fuWidth, this.fvOffset + this.fvHeight).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(this.fuOffset + this.fuWidth, this.fvOffset).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
        RenderSystem.m_69461_();
    }

    public void renderScaled(int x, int y, int axis, boolean isWidth) {
        if (isWidth) {
            this.render(x, y, axis, this.getFixedHeight(axis));
        } else {
            this.render(x, y, this.getFixedWidth(axis), axis);
        }
    }

    public void renderLazy(int x, int y) {
        this.render(x, y, (int)((float)this.uWidth * this.zoom), (int)((float)this.vHeight * this.zoom));
    }

    public void renderCenteredLazy(int centerX, int centerY) {
        this.renderCentered(centerX, centerY, (int)((float)this.uWidth * this.zoom), (int)((float)this.vHeight * this.zoom));
    }

    public void renderCentered(int centerX, int centerY, int width, int height) {
        this.render(centerX - width / 2, centerY - height / 2, width, height);
    }

    public void renderUV(int x, int y, int width, int height, float baseU, float baseV, float additionU, float additionV) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.location);
        RenderSystem.m_157429_((float)this.color.getfR(), (float)this.color.getfG(), (float)this.color.getfB(), (float)this.color.getA());
        RenderSystem.m_69478_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(baseU, baseV).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(baseU, baseV + additionV).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(baseU + additionU, baseV + additionV).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(baseU + additionU, baseV).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
        RenderSystem.m_69461_();
    }

    public void renderNineSliceScaled(float r, int x, int y, int w, int h, float scale) {
        int border = (int)(r * scale);
        float borderU = (float)border / (float)w;
        float borderV = (float)border / (float)h;
        float centerU = this.fuWidth - 2.0f * borderU;
        float centerV = this.fvHeight - 2.0f * borderV;
        this.renderUV(x, y, border, border, this.fuOffset, this.fvOffset, borderU, borderV);
        this.renderUV(x + border, y, w - 2 * border, border, this.fuOffset + borderU, this.fvOffset, centerU, borderV);
        this.renderUV(x + w - border, y, border, border, this.fuOffset + this.fuWidth - borderU, this.fvOffset, borderU, borderV);
        this.renderUV(x, y + border, border, h - 2 * border, this.fuOffset, this.fvOffset + borderV, borderU, centerV);
        this.renderUV(x + border, y + border, w - 2 * border, h - 2 * border, this.fuOffset + borderU, this.fvOffset + borderV, centerU, centerV);
        this.renderUV(x + w - border, y + border, border, h - 2 * border, this.fuOffset + this.fuWidth - borderU, this.fvOffset + borderV, borderU, centerV);
        this.renderUV(x, y + h - border, border, border, this.fuOffset, this.fvOffset + this.fvHeight - borderV, borderU, borderV);
        this.renderUV(x + border, y + h - border, w - 2 * border, border, this.fuOffset + borderU, this.fvOffset + this.fvHeight - borderV, centerU, borderV);
        this.renderUV(x + w - border, y + h - border, border, border, this.fuOffset + this.fuWidth - borderU, this.fvOffset + this.fvHeight - borderV, borderU, borderV);
    }

    public void renderCenteredScaled(int centerX, int centerY, int axis, boolean isWidth) {
        if (isWidth) {
            this.renderCentered(centerX, centerY, axis, this.getFixedHeight(axis));
        } else {
            this.renderCentered(centerX, centerY, this.getFixedWidth(axis), axis);
        }
    }

    public int getImgWidth() {
        return this.imgWidth;
    }

    public int getImgHeight() {
        return this.imgHeight;
    }
}

