/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.registration;

import java.util.HashSet;
import java.util.Set;
import kasuga.lib.core.util.LazyRecomputable;
import kasuga.lib.core.util.data_type.Pair;

public class RegistrySet<T, C extends Comparable<C>> {
    Set<Pair<T, C>> registry = new HashSet<Pair<T, C>>();
    LazyRecomputable<T> present = LazyRecomputable.of(() -> {
        Comparable currentMaxPriority = null;
        Object currentItem = null;
        for (Pair<T, C> registryItem : this.registry) {
            if (currentMaxPriority == null) {
                currentItem = registryItem.getFirst();
                currentMaxPriority = (Comparable)registryItem.getSecond();
            }
            if (((Comparable)registryItem.getSecond()).compareTo(currentMaxPriority) <= 0) continue;
            currentItem = registryItem.getFirst();
            currentMaxPriority = (Comparable)registryItem.getSecond();
        }
        return currentItem;
    });

    public T getPresent() {
        return this.present.get();
    }

    public void register(T item, C priority) {
        this.registry.add(Pair.of(item, priority));
        this.present.clear();
    }

    public void remove(T item, C priority) {
        this.registry.remove(Pair.of(item, priority));
        this.present.clear();
    }

    public boolean empty() {
        return this.registry.isEmpty();
    }
}

