/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.ArrayList;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.common.BucketItemReg;
import kasuga.lib.registrations.common.CreativeTabReg;
import kasuga.lib.registrations.common.FluidBlockReg;
import kasuga.lib.registrations.common.ItemReg;
import kasuga.lib.registrations.common.MenuReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegistryObject;

public class FluidReg<E extends ForgeFlowingFluid>
extends Reg {
    private RegistryObject<E> stillObject = null;
    private RegistryObject<E> flowingObject = null;
    private RegistryObject<? extends BucketItem> itemRegistryObject = null;
    private FluidAttributes.Builder properties;
    private ForgeFlowingFluid.Properties fluidProp = null;
    private FluidBuilder<E> stillBuilder = null;
    private FluidBuilder<E> flowingBuilder = null;
    private PropertyBuilder propertyBuilder = null;
    private BucketItemReg<? extends BucketItem> itemReg = null;
    private final ArrayList<FluidPropertyBuilder> builders = new ArrayList();
    private FluidBlockReg<? extends LiquidBlock> block;
    private FluidAttributes type = null;
    private String stillTexturePath = null;
    private String flowingTexturePath = null;
    private String overlayTexturePath = null;
    private MenuReg<?, ?> menuReg = null;
    private int tintColor = 0xFFFFFF;
    boolean registerItem = false;
    boolean registerBlock = false;
    boolean registerMenu = false;

    public FluidReg(String registrationKey) {
        super(registrationKey);
        this.block = new FluidBlockReg(registrationKey);
    }

    @Mandatory
    public FluidReg<E> still(FluidBuilder<? extends E> builder, String stillTexPath) {
        this.stillBuilder = builder;
        this.stillTexturePath = stillTexPath;
        return this;
    }

    @Mandatory
    public FluidReg<E> flow(FluidBuilder<? extends E> builder, String flowingTexPath) {
        this.flowingBuilder = builder;
        this.flowingTexturePath = flowingTexPath;
        return this;
    }

    @Mandatory
    public FluidReg<E> blockType(FluidBlockReg.FluidBlockBuilder<? extends LiquidBlock> builder) {
        this.block.blockType(builder);
        this.registerBlock = true;
        return this;
    }

    public FluidReg<E> blockType(FluidBlockReg<? extends LiquidBlock> reg) {
        this.block = reg;
        this.registerBlock = false;
        return this;
    }

    @Optional
    public FluidReg<E> type(FluidAttributes type) {
        this.type = type;
        return this;
    }

    @Mandatory
    public <R extends BucketItem> FluidReg<E> bucketItem(BucketItemReg.BucketBuilder<? extends BucketItem> builder) {
        this.itemReg = new BucketItemReg(this.registrationKey + ".bucket");
        this.itemReg.itemType(builder);
        this.registerItem = true;
        return this;
    }

    public FluidReg<E> bucketItem(BucketItemReg<? extends BucketItem> reg) {
        this.itemReg = reg;
        this.registerItem = false;
        return this;
    }

    @Optional
    public FluidReg<E> bucketModel(ResourceLocation resourceLocation) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "bucketModel");
            return this;
        }
        this.itemReg.model(resourceLocation);
        return this;
    }

    @Optional
    public FluidReg<E> itemProperty(ItemReg.PropertyIdentifier identifier) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "itemProperty");
            return this;
        }
        this.itemReg.withProperty(identifier);
        return this;
    }

    @Optional
    public FluidReg<E> shouldCustomRenderItem(boolean flag) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "shouldCustomRenderItem");
            return this;
        }
        this.itemReg.shouldCustomRender(flag);
        return this;
    }

    @Optional
    public FluidReg<E> tab(CreativeModeTab tab) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "tab");
            return this;
        }
        this.itemReg.tab(tab);
        return this;
    }

    @Optional
    public FluidReg<E> tab(CreativeTabReg reg) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "tab");
            return this;
        }
        this.itemReg.tab(reg);
        return this;
    }

    @Optional
    public FluidReg<E> stackTo(int size) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "stackTo");
            return this;
        }
        this.itemReg.stackTo(size);
        return this;
    }

    @Optional
    public <F extends AbstractContainerMenu, U extends Screen> FluidReg<E> withMenu(String registrationKey, IContainerFactory<?> menu, MenuReg.ScreenInvoker<U> screen) {
        this.menuReg = new MenuReg(registrationKey).withMenuAndScreen(menu, screen);
        this.registerMenu = true;
        return this;
    }

    @Optional
    public FluidReg<E> withMenu(MenuReg<?, ?> menuReg) {
        this.menuReg = menuReg;
        this.registerMenu = false;
        return this;
    }

    @Optional
    public FluidReg<E> withBlockProperty(BlockReg.PropertyIdentifier identifier) {
        if (this.block == null) {
            this.crashOnNotPresent(FluidBlockReg.class, "fluidBlockReg", "withBlockProperty");
            return this;
        }
        this.block.addProperty(identifier);
        return this;
    }

    @Optional
    public FluidReg<E> tintColor(int r, int g, int b) {
        this.tintColor = r * 255 * 255 + g * 255 + b;
        return this;
    }

    @Optional
    public FluidReg<E> tintColor(int color) {
        this.tintColor = color;
        return this;
    }

    @Optional
    public FluidReg<E> overlayTexPath(String path) {
        this.overlayTexturePath = path;
        return this;
    }

    @Optional
    public FluidReg<E> typeProperty(PropertyBuilder builder) {
        this.propertyBuilder = builder;
        return this;
    }

    @Optional
    public FluidReg<E> fluidProperty(FluidPropertyBuilder builder) {
        this.builders.add(builder);
        return this;
    }

    @Override
    @Mandatory
    public FluidReg<E> submit(SimpleRegistry registry) {
        this.initDefaultType(registry);
        this.properties.translationKey(this.registrationKey);
        if (this.propertyBuilder != null) {
            this.propertyBuilder.build(this.properties);
        }
        if (this.flowingBuilder == null) {
            this.crashOnNotPresent(ForgeFlowingFluid.class, "flow", "submit");
        }
        if (this.stillBuilder == null) {
            this.crashOnNotPresent(ForgeFlowingFluid.class, "still", "submit");
        }
        this.block.fluid(() -> (ForgeFlowingFluid)this.stillObject.get());
        this.block.submit(registry);
        this.fluidProp = new ForgeFlowingFluid.Properties(() -> (Fluid)this.stillObject.get(), () -> (Fluid)this.flowingObject.get(), this.properties);
        for (FluidPropertyBuilder builder : this.builders) {
            builder.build(this.fluidProp);
        }
        if (this.stillBuilder != null) {
            this.stillObject = registry.fluid().register(this.registrationKey + "_still", () -> (ForgeFlowingFluid)this.stillBuilder.build(this.fluidProp));
        }
        if (this.flowingBuilder != null) {
            this.flowingObject = registry.fluid().register(this.registrationKey + "_flow", () -> (ForgeFlowingFluid)this.flowingBuilder.build(this.fluidProp));
        }
        if (this.registerItem) {
            this.itemReg.submit(registry);
        }
        if (this.menuReg != null && this.registerMenu && !registry.hasMenuCache(this.toString())) {
            registry.cacheMenuIn(this.menuReg);
        }
        return this;
    }

    @Inner
    private void initDefaultType(SimpleRegistry registry) {
        ResourceLocation stillLoc = this.stillTexturePath == null ? null : new ResourceLocation(registry.namespace, this.stillTexturePath);
        ResourceLocation flowingLoc = this.flowingTexturePath == null ? null : new ResourceLocation(registry.namespace, this.flowingTexturePath);
        ResourceLocation overlayLoc = this.overlayTexturePath == null ? null : new ResourceLocation(registry.namespace, this.overlayTexturePath);
        this.properties = FluidAttributes.builder((ResourceLocation)stillLoc, (ResourceLocation)flowingLoc);
        if (overlayLoc != null) {
            this.properties.overlay(overlayLoc);
        }
        this.properties.color(this.tintColor);
    }

    public RegistryObject<E> still() {
        return this.stillObject;
    }

    public RegistryObject<E> flowing() {
        return this.flowingObject;
    }

    public FluidAttributes FluidAttributes() {
        return this.type;
    }

    public ForgeFlowingFluid stillFluid() {
        return (ForgeFlowingFluid)this.stillObject.get();
    }

    public ForgeFlowingFluid flowingFluid() {
        return (ForgeFlowingFluid)this.flowingObject.get();
    }

    public RegistryObject<? extends BucketItem> itemRegistryObject() {
        return this.itemRegistryObject;
    }

    public BucketItem bucket() {
        return (BucketItem)this.itemRegistryObject.get();
    }

    public LiquidBlock legacyBlock() {
        return this.block.getBlock();
    }

    @Override
    public String getIdentifier() {
        return "fluid";
    }

    public static interface FluidBuilder<T extends Fluid> {
        public T build(ForgeFlowingFluid.Properties var1);
    }

    public static interface PropertyBuilder {
        public void build(FluidAttributes.Builder var1);
    }

    public static interface FluidPropertyBuilder {
        public void build(ForgeFlowingFluid.Properties var1);
    }
}

